/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.math.jet.math.Arithmetic;
import org.apache.mahout.math.jet.random.AbstractDiscreteDistribution;
import org.apache.mahout.math.jet.random.Gamma;
import org.apache.mahout.math.jet.random.Poisson;
import org.apache.mahout.math.jet.stat.Probability;

public final class NegativeBinomial
extends AbstractDiscreteDistribution {
    private final int r;
    private final double p;
    private final Gamma gamma;
    private final Poisson poisson;

    public NegativeBinomial(int r, double p, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.r = r;
        this.p = p;
        this.gamma = new Gamma(r, 1.0, randomGenerator);
        this.poisson = new Poisson(0.0, randomGenerator);
    }

    public double cdf(int k) {
        return Probability.negativeBinomial(k, this.r, this.p);
    }

    public double pdf(int k) {
        return Arithmetic.binomial(k + this.r - 1, this.r - 1) * Math.pow(this.p, this.r) * Math.pow(1.0 - this.p, k);
    }

    @Override
    public int nextInt() {
        return this.nextInt(this.r, this.p);
    }

    public int nextInt(int r, double p) {
        return this.poisson.nextInt(this.gamma.nextDouble(r, p / (1.0 - p)));
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.r + ',' + this.p + ')';
    }
}

