/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.math.jet.random.AbstractContinousDistribution;
import org.apache.mahout.math.jet.stat.Probability;

public class Gamma
extends AbstractContinousDistribution {
    private final double alpha;
    private final double rate;

    public Gamma(double alpha, double rate, Random randomGenerator) {
        this.alpha = alpha;
        this.rate = rate;
        this.setRandomGenerator(randomGenerator);
    }

    @Override
    public double cdf(double x) {
        return Probability.gamma(this.alpha, this.rate, x);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.alpha, this.rate);
    }

    public double nextDouble(double alpha, double rate) {
        double w;
        double sign_u;
        double e;
        double q;
        double v;
        double v2;
        double v1;
        double v12;
        if (alpha <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (rate <= 0.0) {
            throw new IllegalArgumentException();
        }
        double b = 0.0;
        if (alpha < 1.0) {
            double gds;
            b = 1.0 + 0.36788794412 * alpha;
            while (true) {
                double p;
                if ((p = b * this.randomGenerator.nextDouble()) <= 1.0) {
                    gds = Math.exp(Math.log(p) / alpha);
                    if (!(Math.log(this.randomGenerator.nextDouble()) <= -gds)) continue;
                    return gds / rate;
                }
                gds = -Math.log((b - p) / alpha);
                if (Math.log(this.randomGenerator.nextDouble()) <= (alpha - 1.0) * Math.log(gds)) break;
            }
            return gds / rate;
        }
        double ss = 0.0;
        double s = 0.0;
        double d = 0.0;
        if (alpha != -1.0) {
            ss = alpha - 0.5;
            s = Math.sqrt(ss);
            d = 5.656854249 - 12.0 * s;
        }
        while ((v12 = (v1 = 2.0 * this.randomGenerator.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.randomGenerator.nextDouble() - 1.0) * v2) > 1.0) {
        }
        double t = v1 * Math.sqrt(-2.0 * Math.log(v12) / v12);
        double x = s + 0.5 * t;
        double gds = x * x;
        if (t >= 0.0) {
            return gds / rate;
        }
        double u = this.randomGenerator.nextDouble();
        if (d * u <= t * t * t) {
            return gds / rate;
        }
        double q0 = 0.0;
        double si = 0.0;
        double c = 0.0;
        if (alpha != -1.0) {
            double r = 1.0 / alpha;
            double q9 = 1.71032E-4;
            double q8 = -4.701849E-4;
            double q7 = 6.053049E-4;
            double q6 = 3.340332E-4;
            double q5 = -3.349403E-4;
            double q4 = 0.0015746717;
            double q3 = 0.0079849875;
            double q2 = 0.0208333723;
            double q1 = 0.0416666664;
            q0 = ((((((((q9 * r + q8) * r + q7) * r + q6) * r + q5) * r + q4) * r + q3) * r + q2) * r + q1) * r;
            if (alpha > 3.686) {
                if (alpha > 13.022) {
                    b = 1.77;
                    si = 0.75;
                    c = 0.1515 / s;
                } else {
                    b = 1.654 + 0.0076 * ss;
                    si = 1.68 / s + 0.275;
                    c = 0.062 / s + 0.024;
                }
            } else {
                b = 0.463 + s - 0.178 * ss;
                si = 1.235;
                c = 0.195 / s - 0.079 + 0.016 * s;
            }
        }
        double a9 = 0.104089866;
        double a8 = -0.112750886;
        double a7 = 0.11036831;
        double a6 = -0.124385581;
        double a5 = 0.142873973;
        double a4 = -0.166677482;
        double a3 = 0.199999867;
        double a2 = -0.249999949;
        double a1 = 0.333333333;
        if (x > 0.0) {
            v = t / (s + s);
            q = Math.abs(v) > 0.25 ? q0 - s * t + 0.25 * t * t + (ss + ss) * Math.log(1.0 + v) : q0 + 0.5 * t * t * ((((((((a9 * v + a8) * v + a7) * v + a6) * v + a5) * v + a4) * v + a3) * v + a2) * v + a1) * v;
            if (Math.log(1.0 - u) <= q) {
                return gds / rate;
            }
        }
        double e7 = 2.47453E-4;
        double e6 = 0.001353826;
        double e5 = 0.008345522;
        double e4 = 0.041664508;
        double e3 = 0.166666848;
        double e2 = 0.499999994;
        double e1 = 1.0;
        do {
            e = -Math.log(this.randomGenerator.nextDouble());
            u = this.randomGenerator.nextDouble();
        } while ((t = b + e * si * (sign_u = (u = u + u - 1.0) > 0.0 ? 1.0 : -1.0)) <= -0.71874483771719 || (q = Math.abs(v = t / (s + s)) > 0.25 ? q0 - s * t + 0.25 * t * t + (ss + ss) * Math.log(1.0 + v) : q0 + 0.5 * t * t * ((((((((a9 * v + a8) * v + a7) * v + a6) * v + a5) * v + a4) * v + a3) * v + a2) * v + a1) * v) <= 0.0 || !(c * u * sign_u <= (w = q > 0.5 ? Math.exp(q) - 1.0 : ((((((e7 * q + e6) * q + e5) * q + e4) * q + e3) * q + e2) * q + e1) * q) * Math.exp(e - 0.5 * t * t)));
        x = s + 0.5 * t;
        return x * x / rate;
    }

    @Override
    public double pdf(double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException();
        }
        if (x == 0.0) {
            if (this.alpha == 1.0) {
                return this.rate;
            }
            if (this.alpha < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        if (this.alpha == 1.0) {
            return this.rate * Math.exp(-x * this.rate);
        }
        return this.rate * Math.exp((this.alpha - 1.0) * Math.log(x * this.rate) - x * this.rate - Gamma.logGamma(this.alpha));
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.rate + ',' + this.alpha + ')';
    }

    public static double logGamma(double x) {
        if (x <= 0.0) {
            return -999.0;
        }
        double z = 1.0;
        while (x < 11.0) {
            z *= x;
            x += 1.0;
        }
        double r = 1.0 / (x * x);
        double c6 = -0.0019175269175269174;
        double c5 = 8.417508417508417E-4;
        double c4 = -5.952380952380953E-4;
        double c3 = 7.936507936507937E-4;
        double c2 = -0.002777777777777778;
        double c1 = 0.08333333333333333;
        double g = c1 + r * (c2 + r * (c3 + r * (c4 + r * (c5 + r + c6))));
        double c0 = 0.9189385332046728;
        g = (x - 0.5) * Math.log(x) - x + c0 + g / x;
        if (z == 1.0) {
            return g;
        }
        return g - Math.log(z);
    }
}

