/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer;

import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.decomposer.EigenStatus;
import org.apache.mahout.math.decomposer.SingularVectorVerifier;

public class SimpleEigenVerifier
implements SingularVectorVerifier {
    @Override
    public EigenStatus verify(VectorIterable corpus, Vector vector) {
        Vector resultantVector = corpus.timesSquared(vector);
        double newNorm = resultantVector.norm(2.0);
        double oldNorm = vector.norm(2.0);
        double eigenValue = newNorm > 0.0 && oldNorm > 0.0 ? newNorm / oldNorm : 1.0;
        double cosAngle = newNorm > 0.0 && oldNorm > 0.0 ? resultantVector.dot(vector) / (newNorm * oldNorm) : 0.0;
        return new EigenStatus(eigenValue, cosAngle, false);
    }
}

