/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Map;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.map.OpenIntObjectHashMap;

public class SparseMatrix
extends AbstractMatrix {
    private OpenIntObjectHashMap<Vector> rows;

    public SparseMatrix() {
    }

    public SparseMatrix(int[] cardinality, Map<Integer, RandomAccessSparseVector> rows) {
        this.cardinality = (int[])cardinality.clone();
        this.rows = new OpenIntObjectHashMap();
        for (Map.Entry<Integer, RandomAccessSparseVector> entry : rows.entrySet()) {
            this.rows.put(entry.getKey().intValue(), (Object)entry.getValue().clone());
        }
    }

    public SparseMatrix(int[] cardinality) {
        this.cardinality = (int[])cardinality.clone();
        this.rows = new OpenIntObjectHashMap();
    }

    public SparseMatrix(int rows, int columns) {
        this(new int[]{rows, columns});
    }

    @Override
    public Matrix clone() {
        SparseMatrix clone = (SparseMatrix)super.clone();
        clone.cardinality = (int[])this.cardinality.clone();
        clone.rows = this.rows.clone();
        return clone;
    }

    @Override
    public double getQuick(int row, int column) {
        Vector r = (Vector)this.rows.get(row);
        return r == null ? 0.0 : r.getQuick(column);
    }

    @Override
    public Matrix like() {
        return new SparseMatrix(this.cardinality);
    }

    @Override
    public Matrix like(int rows, int columns) {
        return new SparseMatrix(new int[]{rows, columns});
    }

    @Override
    public void setQuick(int row, int column, double value) {
        Vector r = (Vector)this.rows.get(row);
        if (r == null) {
            r = new RandomAccessSparseVector(this.cardinality[1]);
            this.rows.put(row, (Object)r);
        }
        r.setQuick(column, value);
    }

    @Override
    public int[] getNumNondefaultElements() {
        int[] result = new int[2];
        result[0] = this.rows.size();
        for (Vector vectorEntry : this.rows.values()) {
            result[1] = Math.max(result[1], vectorEntry.getNumNondefaultElements());
        }
        return result;
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        if (offset[0] < 0) {
            throw new IndexException(offset[0], this.cardinality[0]);
        }
        if (offset[0] + size[0] > this.cardinality[0]) {
            throw new IndexException(offset[0] + size[0], this.cardinality[0]);
        }
        if (offset[1] < 0) {
            throw new IndexException(offset[1], this.cardinality[1]);
        }
        if (offset[1] + size[1] > this.cardinality[1]) {
            throw new IndexException(offset[1] + size[1], this.cardinality[1]);
        }
        return new MatrixView(this, offset, size);
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        if (this.cardinality[0] != other.size()) {
            throw new CardinalityException(this.cardinality[0], other.size());
        }
        if (column < 0 || column >= this.cardinality[1]) {
            throw new IndexException(column, this.cardinality[1]);
        }
        for (int row = 0; row < this.cardinality[0]; ++row) {
            double val = other.getQuick(row);
            if (val == 0.0) continue;
            Vector r = (Vector)this.rows.get(row);
            if (r == null) {
                r = new RandomAccessSparseVector(this.cardinality[1]);
                this.rows.put(row, (Object)r);
            }
            r.setQuick(column, val);
        }
        return this;
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        if (this.cardinality[1] != other.size()) {
            throw new CardinalityException(this.cardinality[1], other.size());
        }
        if (row < 0 || row >= this.cardinality[0]) {
            throw new IndexException(row, this.cardinality[0]);
        }
        this.rows.put(row, (Object)other);
        return this;
    }

    @Override
    public Vector getColumn(int column) {
        if (column < 0 || column >= this.cardinality[1]) {
            throw new IndexException(column, this.cardinality[1]);
        }
        double[] d = new double[this.cardinality[0]];
        for (int row = 0; row < this.cardinality[0]; ++row) {
            d[row] = this.getQuick(row, column);
        }
        return new DenseVector(d);
    }

    @Override
    public Vector getRow(int row) {
        if (row < 0 || row >= this.cardinality[0]) {
            throw new IndexException(row, this.cardinality[0]);
        }
        Vector res = (Vector)this.rows.get(row);
        if (res == null) {
            res = new RandomAccessSparseVector(this.cardinality[1]);
        }
        return res;
    }
}

