/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;

public class SparseColumnMatrix
extends AbstractMatrix {
    private Vector[] columns;

    public SparseColumnMatrix() {
    }

    public SparseColumnMatrix(int[] cardinality, RandomAccessSparseVector[] columns) {
        this.cardinality = (int[])cardinality.clone();
        this.columns = (Vector[])columns.clone();
        for (int col = 0; col < cardinality[1]; ++col) {
            this.columns[col] = columns[col].clone();
        }
    }

    public SparseColumnMatrix(int[] cardinality) {
        this.cardinality = (int[])cardinality.clone();
        this.columns = new RandomAccessSparseVector[cardinality[1]];
        for (int col = 0; col < cardinality[1]; ++col) {
            this.columns[col] = new RandomAccessSparseVector(cardinality[0]);
        }
    }

    @Override
    public Matrix clone() {
        SparseColumnMatrix clone = (SparseColumnMatrix)super.clone();
        clone.cardinality = (int[])this.cardinality.clone();
        clone.columns = new Vector[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            clone.columns[i] = this.columns[i].clone();
        }
        return clone;
    }

    @Override
    protected Vector slice(int index) {
        return this.getColumn(index);
    }

    @Override
    public int numSlices() {
        return this.numCols();
    }

    @Override
    public double getQuick(int row, int column) {
        return this.columns[column] == null ? 0.0 : this.columns[column].getQuick(row);
    }

    @Override
    public Matrix like() {
        return new SparseColumnMatrix(this.cardinality);
    }

    @Override
    public Matrix like(int rows, int columns) {
        int[] c = new int[]{rows, columns};
        return new SparseColumnMatrix(c);
    }

    @Override
    public void setQuick(int row, int column, double value) {
        if (this.columns[column] == null) {
            this.columns[column] = new RandomAccessSparseVector(this.cardinality[0]);
        }
        this.columns[column].setQuick(row, value);
    }

    @Override
    public int[] getNumNondefaultElements() {
        int[] result = new int[2];
        result[1] = this.columns.length;
        for (int col = 0; col < this.cardinality[1]; ++col) {
            result[0] = Math.max(result[0], this.columns[col].getNumNondefaultElements());
        }
        return result;
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        if (offset[0] < 0) {
            throw new IndexException(offset[0], this.columns[1].size());
        }
        if (offset[0] + size[0] > this.columns[1].size()) {
            throw new IndexException(offset[0] + size[0], this.columns[1].size());
        }
        if (offset[1] < 0) {
            throw new IndexException(offset[1], this.columns.length);
        }
        if (offset[1] + size[1] > this.columns.length) {
            throw new IndexException(offset[1] + size[1], this.columns.length);
        }
        return new MatrixView(this, offset, size);
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        if (this.cardinality[0] != other.size()) {
            throw new CardinalityException(this.cardinality[0], other.size());
        }
        if (column < 0 || column >= this.cardinality[1]) {
            throw new IndexException(column, this.cardinality[1]);
        }
        this.columns[column].assign(other);
        return this;
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        if (this.cardinality[1] != other.size()) {
            throw new CardinalityException(this.cardinality[1], other.size());
        }
        if (row < 0 || row >= this.cardinality[0]) {
            throw new IndexException(row, this.cardinality[0]);
        }
        for (int col = 0; col < this.cardinality[1]; ++col) {
            this.columns[col].setQuick(row, other.getQuick(col));
        }
        return this;
    }

    @Override
    public Vector getColumn(int column) {
        if (column < 0 || column >= this.cardinality[1]) {
            throw new IndexException(column, this.cardinality[1]);
        }
        return this.columns[column];
    }

    @Override
    public Vector getRow(int row) {
        if (row < 0 || row >= this.cardinality[0]) {
            throw new IndexException(row, this.cardinality[0]);
        }
        return new AbstractMatrix.TransposeViewVector(this, row, false);
    }
}

