/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.IntDoubleProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntDoubleHashMap;

public class RandomAccessSparseVector
extends AbstractVector {
    private static final int INITIAL_CAPACITY = 11;
    private OpenIntDoubleHashMap values;

    public RandomAccessSparseVector() {
        super(0);
    }

    public RandomAccessSparseVector(int cardinality) {
        this(cardinality, Math.min(cardinality, 11));
    }

    public RandomAccessSparseVector(int cardinality, int initialCapacity) {
        super(cardinality);
        this.values = new OpenIntDoubleHashMap(initialCapacity);
    }

    public RandomAccessSparseVector(Vector other) {
        this(other.size(), other.getNumNondefaultElements());
        Vector.Element e;
        Iterator<Vector.Element> it = other.iterateNonZero();
        while (it.hasNext() && (e = it.next()) != null) {
            this.values.put(e.index(), e.get());
        }
    }

    private RandomAccessSparseVector(int cardinality, OpenIntDoubleHashMap values) {
        super(cardinality);
        this.values = values;
    }

    public RandomAccessSparseVector(RandomAccessSparseVector other, boolean shallowCopy) {
        super(other.size());
        this.values = shallowCopy ? other.values : (OpenIntDoubleHashMap)other.values.clone();
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        int[] cardinality = new int[]{rows, columns};
        return new SparseRowMatrix(cardinality);
    }

    @Override
    public RandomAccessSparseVector clone() {
        return new RandomAccessSparseVector(this.size(), (OpenIntDoubleHashMap)this.values.clone());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('{');
        Iterator<Vector.Element> it = this.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            result.append(e.index());
            result.append(':');
            result.append(e.get());
            result.append(',');
        }
        if (result.length() > 1) {
            result.setCharAt(result.length() - 1, '}');
        }
        return result.toString();
    }

    @Override
    public Vector assign(Vector other) {
        Vector.Element e;
        if (this.size() != other.size()) {
            throw new CardinalityException(this.size(), other.size());
        }
        this.values.clear();
        Iterator<Vector.Element> it = other.iterateNonZero();
        while (it.hasNext() && (e = it.next()) != null) {
            this.setQuick(e.index(), e.get());
        }
        return this;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public double getQuick(int index) {
        return this.values.get(index);
    }

    @Override
    public void setQuick(int index, double value) {
        this.lengthSquared = -1.0;
        if (value == 0.0) {
            this.values.removeKey(index);
        } else {
            this.values.put(index, value);
        }
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.size();
    }

    @Override
    public RandomAccessSparseVector like() {
        return new RandomAccessSparseVector(this.size(), this.values.size());
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonDefaultIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    @Override
    public void addTo(Vector v) {
        if (v.size() != this.size()) {
            throw new CardinalityException(this.size(), v.size());
        }
        this.values.forEachPair((IntDoubleProcedure)new AddToVector(v));
    }

    @Override
    public double dot(Vector x) {
        if (this.size() != x.size()) {
            throw new CardinalityException(this.size(), x.size());
        }
        if (this == x) {
            return this.dotSelf();
        }
        double result = 0.0;
        if (x instanceof SequentialAccessSparseVector) {
            Iterator<Vector.Element> iter = x.iterateNonZero();
            while (iter.hasNext()) {
                Vector.Element element = iter.next();
                result += element.get() * this.getQuick(element.index());
            }
            return result;
        }
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            result += element.get() * x.getQuick(element.index());
        }
        return result;
    }

    private final class RandomAccessElement
    implements Vector.Element {
        int index;

        private RandomAccessElement() {
        }

        @Override
        public double get() {
            return RandomAccessSparseVector.this.values.get(this.index);
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void set(double value) {
            RandomAccessSparseVector.this.lengthSquared = -1.0;
            if (value == 0.0) {
                RandomAccessSparseVector.this.values.removeKey(this.index);
            } else {
                RandomAccessSparseVector.this.values.put(this.index, value);
            }
        }
    }

    private final class AllIterator
    extends AbstractIterator<Vector.Element> {
        private final RandomAccessElement element;

        private AllIterator() {
            this.element = new RandomAccessElement();
            this.element.index = -1;
        }

        protected Vector.Element computeNext() {
            if (this.element.index + 1 < RandomAccessSparseVector.this.size()) {
                ++this.element.index;
                return this.element;
            }
            return (Vector.Element)this.endOfData();
        }
    }

    private final class NonDefaultIterator
    extends AbstractIterator<Vector.Element> {
        private final RandomAccessElement element;
        private final IntArrayList indices;
        private int offset;

        private NonDefaultIterator() {
            this.element = new RandomAccessElement();
            this.indices = new IntArrayList();
            RandomAccessSparseVector.this.values.keys(this.indices);
        }

        protected Vector.Element computeNext() {
            if (this.offset >= this.indices.size()) {
                return (Vector.Element)this.endOfData();
            }
            this.element.index = this.indices.get(this.offset);
            ++this.offset;
            return this.element;
        }
    }

    private static final class AddToVector
    implements IntDoubleProcedure {
        private final Vector v;

        private AddToVector(Vector v) {
            this.v = v;
        }

        public boolean apply(int key, double value) {
            this.v.set(key, value + this.v.get(key));
            return true;
        }
    }
}

