/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;

public final class Algebra {
    private Algebra() {
    }

    public static Vector mult(Matrix m, Vector v) {
        if (m.numRows() != v.size()) {
            throw new CardinalityException(m.numRows(), v.size());
        }
        DenseVector result = new DenseVector(m.numRows());
        for (int i = 0; i < m.numRows(); ++i) {
            result.set(i, m.getRow(i).dot(v));
        }
        return result;
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static double getNorm(Matrix m) {
        double max = 0.0;
        for (int i = 0; i < m.numRows(); ++i) {
            int sum = 0;
            Vector cv = m.getRow(i);
            for (int j = 0; j < cv.size(); ++j) {
                sum = (int)((double)sum + Math.abs(cv.getQuick(j)));
            }
            if (!((double)sum > max)) continue;
            max = sum;
        }
        return max;
    }
}

