/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;

public abstract class AbstractVector
implements Vector {
    private int size;
    protected double lengthSquared = -1.0;

    protected AbstractVector(int size) {
        this.size = size;
    }

    @Override
    public double aggregate(DoubleDoubleFunction aggregator, DoubleFunction map) {
        if (this.size < 1) {
            throw new IllegalArgumentException("Cannot aggregate empty vector");
        }
        double result = map.apply(this.getQuick(0));
        for (int i = 1; i < this.size; ++i) {
            result = aggregator.apply(result, map.apply(this.getQuick(i)));
        }
        return result;
    }

    @Override
    public double aggregate(Vector other, DoubleDoubleFunction aggregator, DoubleDoubleFunction combiner) {
        if (this.size < 1) {
            throw new IllegalArgumentException("Cannot aggregate empty vector");
        }
        double result = combiner.apply(this.getQuick(0), other.getQuick(0));
        for (int i = 1; i < this.size; ++i) {
            result = aggregator.apply(result, combiner.apply(this.getQuick(i), other.getQuick(i)));
        }
        return result;
    }

    protected abstract Matrix matrixLike(int var1, int var2);

    @Override
    public Vector viewPart(int offset, int length) {
        if (offset < 0) {
            throw new IndexException(offset, this.size);
        }
        if (offset + length > this.size) {
            throw new IndexException(offset + length, this.size);
        }
        return new VectorView(this, offset, length);
    }

    @Override
    public Vector clone() {
        try {
            AbstractVector r = (AbstractVector)super.clone();
            r.size = this.size;
            r.lengthSquared = this.lengthSquared;
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Can't happen");
        }
    }

    @Override
    public Vector divide(double x) {
        if (x == 1.0) {
            return this.like().assign(this);
        }
        Vector result = this.like().assign(this);
        Iterator<Vector.Element> iter = result.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            element.set(element.get() / x);
        }
        return result;
    }

    @Override
    public double dot(Vector x) {
        if (this.size != x.size()) {
            throw new CardinalityException(this.size, x.size());
        }
        if (this == x) {
            return this.dotSelf();
        }
        double result = 0.0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            result += element.get() * x.getQuick(element.index());
        }
        return result;
    }

    public double dotSelf() {
        double result = 0.0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            double value = iter.next().get();
            result += value * value;
        }
        return result;
    }

    @Override
    public double get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexException(index, this.size);
        }
        return this.getQuick(index);
    }

    @Override
    public Vector.Element getElement(int index) {
        return new LocalElement(index);
    }

    @Override
    public Vector minus(Vector that) {
        if (this.size != that.size()) {
            throw new CardinalityException(this.size, that.size());
        }
        Vector result = this.like().assign(this);
        Iterator<Vector.Element> iter = that.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element thatElement = iter.next();
            int index = thatElement.index();
            result.setQuick(index, this.getQuick(index) - thatElement.get());
        }
        return result;
    }

    @Override
    public Vector normalize() {
        return this.divide(Math.sqrt(this.dotSelf()));
    }

    @Override
    public Vector normalize(double power) {
        return this.divide(this.norm(power));
    }

    @Override
    public Vector logNormalize() {
        return this.logNormalize(2.0, Math.sqrt(this.dotSelf()));
    }

    @Override
    public Vector logNormalize(double power) {
        return this.logNormalize(power, this.norm(power));
    }

    public Vector logNormalize(double power, double normLength) {
        if (Double.isInfinite(power) || power <= 1.0) {
            throw new IllegalArgumentException("Power must be > 1 and < infinity");
        }
        double denominator = normLength * Math.log(power);
        Vector result = this.like().assign(this);
        Iterator<Vector.Element> iter = result.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            element.set(Math.log(1.0 + element.get()) / denominator);
        }
        return result;
    }

    @Override
    public double norm(double power) {
        if (power < 0.0) {
            throw new IllegalArgumentException("Power must be >= 0");
        }
        if (Double.isInfinite(power)) {
            double val = 0.0;
            Iterator<Vector.Element> iter = this.iterateNonZero();
            while (iter.hasNext()) {
                val = Math.max(val, Math.abs(iter.next().get()));
            }
            return val;
        }
        if (power == 2.0) {
            return Math.sqrt(this.dotSelf());
        }
        if (power == 1.0) {
            double val = 0.0;
            Iterator<Vector.Element> iter = this.iterateNonZero();
            while (iter.hasNext()) {
                val += Math.abs(iter.next().get());
            }
            return val;
        }
        if (power == 0.0) {
            double val = 0.0;
            Iterator<Vector.Element> iter = this.iterateNonZero();
            while (iter.hasNext()) {
                val += iter.next().get() == 0.0 ? 0.0 : 1.0;
            }
            return val;
        }
        double val = 0.0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            val += Math.pow(element.get(), power);
        }
        return Math.pow(val, 1.0 / power);
    }

    @Override
    public double getLengthSquared() {
        if (this.lengthSquared >= 0.0) {
            return this.lengthSquared;
        }
        this.lengthSquared = this.dotSelf();
        return this.lengthSquared;
    }

    @Override
    public double getDistanceSquared(Vector v) {
        Vector randomlyAccessed;
        Iterator<Vector.Element> it;
        if (this.size != v.size()) {
            throw new CardinalityException(this.size, v.size());
        }
        if (this.lengthSquared >= 0.0 && v instanceof AbstractVector && ((AbstractVector)v).lengthSquared >= 0.0) {
            return this.lengthSquared + v.getLengthSquared() - 2.0 * this.dot(v);
        }
        double d = 0.0;
        if (this.lengthSquared >= 0.0) {
            it = v.iterateNonZero();
            randomlyAccessed = this;
            d += this.lengthSquared;
        } else {
            it = this.iterateNonZero();
            randomlyAccessed = v;
            d += v.getLengthSquared();
        }
        while (it.hasNext()) {
            Vector.Element e = it.next();
            double value = e.get();
            d += value * (value - 2.0 * randomlyAccessed.getQuick(e.index()));
        }
        return Math.abs(d);
    }

    @Override
    public double maxValue() {
        double result = Double.NEGATIVE_INFINITY;
        int nonZeroElements = 0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            ++nonZeroElements;
            Vector.Element element = iter.next();
            result = Math.max(result, element.get());
        }
        if (nonZeroElements < this.size) {
            return Math.max(result, 0.0);
        }
        return result;
    }

    @Override
    public int maxValueIndex() {
        int result = -1;
        double max = Double.NEGATIVE_INFINITY;
        int nonZeroElements = 0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            ++nonZeroElements;
            Vector.Element element = iter.next();
            double tmp = element.get();
            if (!(tmp > max)) continue;
            max = tmp;
            result = element.index();
        }
        if (nonZeroElements < this.size && max < 0.0) {
            for (Vector.Element element : this) {
                if (element.get() != 0.0) continue;
                return element.index();
            }
        }
        return result;
    }

    @Override
    public double minValue() {
        double result = Double.POSITIVE_INFINITY;
        int nonZeroElements = 0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            ++nonZeroElements;
            Vector.Element element = iter.next();
            result = Math.min(result, element.get());
        }
        if (nonZeroElements < this.size) {
            return Math.min(result, 0.0);
        }
        return result;
    }

    @Override
    public int minValueIndex() {
        int result = -1;
        double min = Double.POSITIVE_INFINITY;
        int nonZeroElements = 0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            ++nonZeroElements;
            Vector.Element element = iter.next();
            double tmp = element.get();
            if (!(tmp < min)) continue;
            min = tmp;
            result = element.index();
        }
        if (nonZeroElements < this.size && min > 0.0) {
            for (Vector.Element element : this) {
                if (element.get() != 0.0) continue;
                return element.index();
            }
        }
        return result;
    }

    @Override
    public Vector plus(double x) {
        Vector result = this.like().assign(this);
        if (x == 0.0) {
            return result;
        }
        int size = result.size();
        for (int i = 0; i < size; ++i) {
            result.setQuick(i, this.getQuick(i) + x);
        }
        return result;
    }

    @Override
    public Vector plus(Vector x) {
        if (this.size != x.size()) {
            throw new CardinalityException(this.size, x.size());
        }
        if (!this.isDense() && (x.isDense() || x.getNumNondefaultElements() > this.getNumNondefaultElements())) {
            return x.plus(this);
        }
        Vector result = this.like().assign(this);
        Iterator<Vector.Element> iter = x.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element e = iter.next();
            int index = e.index();
            result.setQuick(index, this.getQuick(index) + e.get());
        }
        return result;
    }

    @Override
    public void addTo(Vector v) {
        Iterator<Vector.Element> it = this.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            int index = e.index();
            v.setQuick(index, v.getQuick(index) + e.get());
        }
    }

    @Override
    public void set(int index, double value) {
        if (index < 0 || index >= this.size) {
            throw new IndexException(index, this.size);
        }
        this.setQuick(index, value);
    }

    @Override
    public Vector times(double x) {
        if (x == 0.0) {
            return this.like();
        }
        Vector result = this.like().assign(this);
        if (x == 1.0) {
            return result;
        }
        Iterator<Vector.Element> iter = result.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            element.set(element.get() * x);
        }
        return result;
    }

    @Override
    public Vector times(Vector x) {
        if (this.size != x.size()) {
            throw new CardinalityException(this.size, x.size());
        }
        Vector to = this;
        Vector from = x;
        if (this.isDense() || !x.isDense() && this.getNumNondefaultElements() > x.getNumNondefaultElements()) {
            to = x;
            from = this;
        }
        Vector result = to.like().assign(to);
        Iterator<Vector.Element> iter = result.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            element.set(element.get() * from.getQuick(element.index()));
        }
        return result;
    }

    @Override
    public double zSum() {
        double result = 0.0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            result += iter.next().get();
        }
        return result;
    }

    @Override
    public Vector assign(double value) {
        for (int i = 0; i < this.size; ++i) {
            this.setQuick(i, value);
        }
        return this;
    }

    @Override
    public Vector assign(double[] values) {
        if (this.size != values.length) {
            throw new CardinalityException(this.size, values.length);
        }
        for (int i = 0; i < this.size; ++i) {
            this.setQuick(i, values[i]);
        }
        return this;
    }

    @Override
    public Vector assign(Vector other) {
        if (this.size != other.size()) {
            throw new CardinalityException(this.size, other.size());
        }
        for (int i = 0; i < this.size; ++i) {
            this.setQuick(i, other.getQuick(i));
        }
        return this;
    }

    @Override
    public Vector assign(DoubleDoubleFunction f, double y) {
        Iterator<Vector.Element> it;
        Iterator<Vector.Element> iterator = it = f.apply(0.0, y) == 0.0 ? this.iterateNonZero() : this.iterator();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            e.set(f.apply(e.get(), y));
        }
        return this;
    }

    @Override
    public Vector assign(DoubleFunction function) {
        Iterator<Vector.Element> it;
        Iterator<Vector.Element> iterator = it = function.apply(0.0) == 0.0 ? this.iterateNonZero() : this.iterator();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            e.set(function.apply(e.get()));
        }
        return this;
    }

    @Override
    public Vector assign(Vector other, DoubleDoubleFunction function) {
        if (this.size != other.size()) {
            throw new CardinalityException(this.size, other.size());
        }
        for (int i = 0; i < this.size; ++i) {
            this.setQuick(i, function.apply(this.getQuick(i), other.getQuick(i)));
        }
        return this;
    }

    @Override
    public Matrix cross(Vector other) {
        Matrix result = this.matrixLike(this.size, other.size());
        for (int row = 0; row < this.size; ++row) {
            result.assignRow(row, other.times(this.getQuick(row)));
        }
        return result;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public String asFormatString() {
        return this.toString();
    }

    public int hashCode() {
        int result = this.size;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element ele = iter.next();
            result += ele.index() * RandomUtils.hashDouble(ele.get());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector that = (Vector)o;
        if (this.size != that.size()) {
            return false;
        }
        for (int index = 0; index < this.size; ++index) {
            if (this.getQuick(index) == that.getQuick(index)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('{');
        for (int index = 0; index < this.size; ++index) {
            double value = this.getQuick(index);
            if (value == 0.0) continue;
            result.append(index);
            result.append(':');
            result.append(value);
            result.append(',');
        }
        if (result.length() > 1) {
            result.setCharAt(result.length() - 1, '}');
        }
        return result.toString();
    }

    protected final class LocalElement
    implements Vector.Element {
        int index;

        LocalElement(int index) {
            this.index = index;
        }

        @Override
        public double get() {
            return AbstractVector.this.getQuick(this.index);
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void set(double value) {
            AbstractVector.this.setQuick(this.index, value);
        }
    }
}

