/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;

class SummaryExtractor {
    private static final String SUMMARY_INFORMATION = "\u0005SummaryInformation";
    private static final String DOCUMENT_SUMMARY_INFORMATION = "\u0005DocumentSummaryInformation";
    private final Metadata metadata;

    public SummaryExtractor(Metadata metadata) {
        this.metadata = metadata;
    }

    public void parseSummaries(POIFSFileSystem filesystem) throws IOException, TikaException {
        this.parseSummaryEntryIfExists(filesystem, SUMMARY_INFORMATION);
        this.parseSummaryEntryIfExists(filesystem, DOCUMENT_SUMMARY_INFORMATION);
    }

    private void parseSummaryEntryIfExists(POIFSFileSystem filesystem, String entryName) throws IOException, TikaException {
        try {
            DocumentEntry entry = (DocumentEntry)filesystem.getRoot().getEntry(entryName);
            PropertySet properties = new PropertySet((InputStream)new DocumentInputStream(entry));
            if (properties.isSummaryInformation()) {
                this.parse(new SummaryInformation(properties));
            }
            if (properties.isDocumentSummaryInformation()) {
                this.parse(new DocumentSummaryInformation(properties));
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (NoPropertySetStreamException e) {
            throw new TikaException("Not a HPSF document", (Throwable)e);
        }
        catch (UnexpectedPropertySetTypeException e) {
            throw new TikaException("Unexpected HPSF document", (Throwable)e);
        }
        catch (MarkUnsupportedException e) {
            throw new TikaException("Invalid DocumentInputStream", (Throwable)e);
        }
    }

    private void parse(SummaryInformation summary) {
        this.set("title", summary.getTitle());
        this.set("Author", summary.getAuthor());
        this.set("Keywords", summary.getKeywords());
        this.set("subject", summary.getSubject());
        this.set("Last-Author", summary.getLastAuthor());
        this.set("Comments", summary.getComments());
        this.set("Template", summary.getTemplate());
        this.set("Application-Name", summary.getApplicationName());
        this.set("Revision-Number", summary.getRevNumber());
        this.set("Creation-Date", summary.getCreateDateTime());
        this.set("Character Count", summary.getCharCount());
        this.set("Edit-Time", summary.getEditTime());
        this.set("Last-Save-Date", summary.getLastSaveDateTime());
        this.set("Page-Count", summary.getPageCount());
        this.set("Security", summary.getSecurity());
        this.set("Word-Count", summary.getWordCount());
        this.set("Last-Printed", summary.getLastPrinted());
    }

    private void parse(DocumentSummaryInformation summary) {
        this.set("Company", summary.getCompany());
        this.set("Manager", summary.getManager());
        this.set("language", this.getLanguage(summary));
        this.set("Category", summary.getCategory());
    }

    private String getLanguage(DocumentSummaryInformation summary) {
        Object value;
        CustomProperties customProperties = summary.getCustomProperties();
        if (customProperties != null && (value = customProperties.get("Language")) instanceof String) {
            return (String)value;
        }
        return null;
    }

    private void set(String name, String value) {
        if (value != null) {
            this.metadata.set(name, value);
        }
    }

    private void set(String name, Date value) {
        if (value != null) {
            this.metadata.set(name, value.toString());
        }
    }

    private void set(String name, long value) {
        if (value > 0L) {
            this.metadata.set(name, Long.toString(value));
        }
    }
}

