/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageParser
implements Parser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.image((String)"bmp"), MediaType.image((String)"gif"), MediaType.image((String)"png"), MediaType.image((String)"tiff"), MediaType.image((String)"vnd.wap.wbmp"), MediaType.image((String)"x-icon"), MediaType.image((String)"x-psd"), MediaType.image((String)"x-xcf"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        String type = metadata.get("Content-Type");
        if (type != null) {
            try {
                Iterator<ImageReader> iterator = ImageIO.getImageReadersByMIMEType(type);
                if (iterator.hasNext()) {
                    ImageReader reader = iterator.next();
                    reader.setInput(ImageIO.createImageInputStream(new CloseShieldInputStream(stream)));
                    metadata.set("height", Integer.toString(reader.getHeight(0)));
                    metadata.set("width", Integer.toString(reader.getWidth(0)));
                    reader.dispose();
                }
            }
            catch (IIOException e) {
                throw new TikaException(type + " parse error", (Throwable)e);
            }
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }
}

