/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.lucene;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.utils.vectors.io.DelimitedTermInfoWriter;
import org.apache.mahout.utils.vectors.io.SequenceFileVectorWriter;
import org.apache.mahout.utils.vectors.io.VectorWriter;
import org.apache.mahout.utils.vectors.lucene.CachedTermInfo;
import org.apache.mahout.utils.vectors.lucene.LuceneIterable;
import org.apache.mahout.utils.vectors.lucene.TFDFMapper;
import org.apache.mahout.vectorizer.TF;
import org.apache.mahout.vectorizer.TFIDF;
import org.apache.mahout.vectorizer.Weight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Driver {
    private static final Logger log = LoggerFactory.getLogger(Driver.class);

    private Driver() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws IOException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption inputOpt = obuilder.withLongName("dir").withRequired(true).withArgument(abuilder.withName("dir").withMinimum(1).withMaximum(1).create()).withDescription("The Lucene directory").withShortName("d").create();
        DefaultOption outputOpt = obuilder.withLongName("output").withRequired(true).withArgument(abuilder.withName("output").withMinimum(1).withMaximum(1).create()).withDescription("The output file").withShortName("o").create();
        DefaultOption fieldOpt = obuilder.withLongName("field").withRequired(true).withArgument(abuilder.withName("field").withMinimum(1).withMaximum(1).create()).withDescription("The field in the index").withShortName("f").create();
        DefaultOption idFieldOpt = obuilder.withLongName("idField").withRequired(false).withArgument(abuilder.withName("idField").withMinimum(1).withMaximum(1).create()).withDescription("The field in the index containing the index.  If null, then the Lucene internal doc id is used which is prone to error if the underlying index changes").withShortName("i").create();
        DefaultOption dictOutOpt = obuilder.withLongName("dictOut").withRequired(true).withArgument(abuilder.withName("dictOut").withMinimum(1).withMaximum(1).create()).withDescription("The output of the dictionary").withShortName("t").create();
        DefaultOption weightOpt = obuilder.withLongName("weight").withRequired(false).withArgument(abuilder.withName("weight").withMinimum(1).withMaximum(1).create()).withDescription("The kind of weight to use. Currently TF or TFIDF").withShortName("w").create();
        DefaultOption delimiterOpt = obuilder.withLongName("delimiter").withRequired(false).withArgument(abuilder.withName("delimiter").withMinimum(1).withMaximum(1).create()).withDescription("The delimiter for outputting the dictionary").withShortName("l").create();
        DefaultOption powerOpt = obuilder.withLongName("norm").withRequired(false).withArgument(abuilder.withName("norm").withMinimum(1).withMaximum(1).create()).withDescription("The norm to use, expressed as either a double or \"INF\" if you want to use the Infinite norm.  Must be greater or equal to 0.  The default is not to normalize").withShortName("n").create();
        DefaultOption maxOpt = obuilder.withLongName("max").withRequired(false).withArgument(abuilder.withName("max").withMinimum(1).withMaximum(1).create()).withDescription("The maximum number of vectors to output.  If not specified, then it will loop over all docs").withShortName("m").create();
        DefaultOption minDFOpt = obuilder.withLongName("minDF").withRequired(false).withArgument(abuilder.withName("minDF").withMinimum(1).withMaximum(1).create()).withDescription("The minimum document frequency.  Default is 1").withShortName("md").create();
        DefaultOption maxDFPercentOpt = obuilder.withLongName("maxDFPercent").withRequired(false).withArgument(abuilder.withName("maxDFPercent").withMinimum(1).withMaximum(1).create()).withDescription("The max percentage of docs for the DF.  Can be used to remove really high frequency terms.  Expressed as an integer between 0 and 100. Default is 99.").withShortName("x").create();
        DefaultOption helpOpt = obuilder.withLongName("help").withDescription("Print out help").withShortName("h").create();
        Group group = gbuilder.withName("Options").withOption((Option)inputOpt).withOption((Option)idFieldOpt).withOption((Option)outputOpt).withOption((Option)delimiterOpt).withOption((Option)helpOpt).withOption((Option)fieldOpt).withOption((Option)maxOpt).withOption((Option)dictOutOpt).withOption((Option)powerOpt).withOption((Option)maxDFPercentOpt).withOption((Option)weightOpt).withOption((Option)minDFOpt).create();
        try {
            TFIDF weight;
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption((Option)helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return;
            }
            if (!cmdLine.hasOption((Option)inputOpt)) return;
            File file = new File(cmdLine.getValue((Option)inputOpt).toString());
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("Lucene directory: " + file.getAbsolutePath() + " does not exist or is not a directory");
            }
            long maxDocs = Long.MAX_VALUE;
            if (cmdLine.hasOption((Option)maxOpt)) {
                maxDocs = Long.parseLong(cmdLine.getValue((Option)maxOpt).toString());
            }
            if (maxDocs < 0L) {
                throw new IllegalArgumentException("maxDocs must be >= 0");
            }
            FSDirectory dir = FSDirectory.open((File)file);
            IndexReader reader = IndexReader.open((Directory)dir, (boolean)true);
            if (cmdLine.hasOption((Option)weightOpt)) {
                String wString = cmdLine.getValue((Option)weightOpt).toString();
                if ("tf".equalsIgnoreCase(wString)) {
                    weight = new TF();
                } else {
                    if (!"tfidf".equalsIgnoreCase(wString)) throw new OptionException((Option)weightOpt);
                    weight = new TFIDF();
                }
            } else {
                weight = new TFIDF();
            }
            String field = cmdLine.getValue((Option)fieldOpt).toString();
            int minDf = 1;
            if (cmdLine.hasOption((Option)minDFOpt)) {
                minDf = Integer.parseInt(cmdLine.getValue((Option)minDFOpt).toString());
            }
            int maxDFPercent = 99;
            if (cmdLine.hasOption((Option)maxDFPercentOpt)) {
                maxDFPercent = Integer.parseInt(cmdLine.getValue((Option)maxDFPercentOpt).toString());
            }
            CachedTermInfo termInfo = new CachedTermInfo(reader, field, minDf, maxDFPercent);
            TFDFMapper mapper = new TFDFMapper(reader, (Weight)weight, termInfo);
            double norm = -1.0;
            if (cmdLine.hasOption((Option)powerOpt)) {
                String power = cmdLine.getValue((Option)powerOpt).toString();
                norm = "INF".equals(power) ? Double.POSITIVE_INFINITY : Double.parseDouble(power);
            }
            String idField = null;
            if (cmdLine.hasOption((Option)idFieldOpt)) {
                idField = cmdLine.getValue((Option)idFieldOpt).toString();
            }
            LuceneIterable iterable = norm == -1.0 ? new LuceneIterable(reader, idField, field, mapper, -1.0) : new LuceneIterable(reader, idField, field, mapper, norm);
            String outFile = cmdLine.getValue((Option)outputOpt).toString();
            log.info("Output File: {}", (Object)outFile);
            VectorWriter vectorWriter = Driver.getSeqFileWriter(outFile);
            long numDocs = vectorWriter.write(iterable, maxDocs);
            vectorWriter.close();
            log.info("Wrote: {} vectors", (Object)numDocs);
            String delimiter = cmdLine.hasOption((Option)delimiterOpt) ? cmdLine.getValue((Option)delimiterOpt).toString() : "\t";
            File dictOutFile = new File(cmdLine.getValue((Option)dictOutOpt).toString());
            log.info("Dictionary Output file: {}", (Object)dictOutFile);
            BufferedWriter writer = Files.newWriter((File)dictOutFile, (Charset)Charsets.UTF_8);
            DelimitedTermInfoWriter tiWriter = new DelimitedTermInfoWriter(writer, delimiter, field);
            tiWriter.write(termInfo);
            tiWriter.close();
            ((Writer)writer).close();
            return;
        }
        catch (OptionException e) {
            log.error("Exception", (Throwable)e);
            CommandLineUtil.printHelp((Group)group);
        }
    }

    private static VectorWriter getSeqFileWriter(String outFile) throws IOException {
        Path path = new Path(outFile);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        SequenceFile.Writer seqWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)path, LongWritable.class, VectorWritable.class);
        return new SequenceFileVectorWriter(seqWriter);
    }
}

