/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.vectors.io.VectorWriter;

public class TextualVectorWriter
implements VectorWriter {
    private final Writer writer;

    public TextualVectorWriter(Writer writer) {
        this.writer = writer;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    @Override
    public long write(Iterable<Vector> iterable) throws IOException {
        return this.write(iterable, Long.MAX_VALUE);
    }

    @Override
    public long write(Iterable<Vector> iterable, long maxDocs) throws IOException {
        long result = 0L;
        for (Vector vector : iterable) {
            if (result >= maxDocs) break;
            this.write(vector);
            ++result;
        }
        return result;
    }

    @Override
    public void write(Vector vector) throws IOException {
        this.writer.write(vector.asFormatString());
        this.writer.write(10);
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

