/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.arff;

import com.google.common.collect.AbstractIterator;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.vectors.arff.ARFFModel;

final class ARFFIterator
extends AbstractIterator<Vector> {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    private final BufferedReader reader;
    private final ARFFModel model;

    ARFFIterator(BufferedReader reader, ARFFModel model) {
        this.reader = reader;
        this.model = model;
    }

    protected Vector computeNext() {
        DenseVector result;
        String line;
        try {
            while ((line = this.reader.readLine()) != null && ((line = line.trim()).length() <= 0 || line.startsWith("%"))) {
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        if (line == null) {
            IOUtils.quietClose((Closeable[])new Closeable[]{this.reader});
            return (Vector)this.endOfData();
        }
        if (line.startsWith("{")) {
            line = line.substring(1, line.length() - 1);
            String[] splits = COMMA_PATTERN.split(line);
            result = new RandomAccessSparseVector(this.model.getLabelSize());
            for (String split : splits) {
                String[] data = SPACE_PATTERN.split(split);
                int idx = Integer.parseInt(data[0]);
                result.setQuick(idx, this.model.getValue(data[1], idx));
            }
        } else {
            result = new DenseVector(this.model.getLabelSize());
            String[] splits = COMMA_PATTERN.split(line);
            for (int i = 0; i < splits.length; ++i) {
                result.setQuick(i, this.model.getValue(splits[i], i));
            }
        }
        return result;
    }
}

