/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.eval;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.als.PredictionJob;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.IntPairWritable;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;

public class ParallelFactorizationEvaluator
extends AbstractJob {
    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new ParallelFactorizationEvaluator(), (String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        this.addOption("pairs", "p", "path containing the test ratings, each line must be userID,itemID,rating", true);
        this.addOption("userFeatures", "u", "path to the user feature matrix", true);
        this.addOption("itemFeatures", "i", "path to the item feature matrix", true);
        this.addOutputOption();
        Map parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Path tempDir = new Path((String)parsedArgs.get("--tempDir"));
        Path predictions = new Path(tempDir, "predictions");
        Path errors = new Path(tempDir, "errors");
        ToolRunner.run((Configuration)this.getConf(), (Tool)new PredictionJob(), (String[])new String[]{"--output", predictions.toString(), "--pairs", (String)parsedArgs.get("--pairs"), "--userFeatures", (String)parsedArgs.get("--userFeatures"), "--itemFeatures", (String)parsedArgs.get("--itemFeatures"), "--tempDir", tempDir.toString()});
        Job estimationErrors = this.prepareJob(new Path((String)parsedArgs.get("--pairs") + ',' + predictions), errors, TextInputFormat.class, PairsWithRatingMapper.class, IntPairWritable.class, DoubleWritable.class, ErrorReducer.class, DoubleWritable.class, NullWritable.class, SequenceFileOutputFormat.class);
        estimationErrors.waitForCompletion(true);
        BufferedWriter writer = null;
        try {
            FileSystem fs = FileSystem.get((URI)this.getOutputPath().toUri(), (Configuration)this.getConf());
            FSDataOutputStream outputStream = fs.create(new Path(this.getOutputPath(), "rmse.txt"));
            double rmse = this.computeRmse(errors);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream));
            writer.write(String.valueOf(rmse));
        }
        catch (Throwable throwable) {
            IOUtils.quietClose((Closeable[])new Closeable[]{writer});
            throw throwable;
        }
        IOUtils.quietClose((Closeable[])new Closeable[]{writer});
        return 0;
    }

    protected double computeRmse(Path errors) {
        FullRunningAverage average = new FullRunningAverage();
        for (Pair entry : new SequenceFileDirIterable(errors, PathType.LIST, this.getConf())) {
            DoubleWritable error = (DoubleWritable)entry.getFirst();
            average.addDatum(error.get() * error.get());
        }
        return Math.sqrt(average.getAverage());
    }

    public static class ErrorReducer
    extends Reducer<IntPairWritable, DoubleWritable, DoubleWritable, NullWritable> {
        protected void reduce(IntPairWritable key, Iterable<DoubleWritable> ratingAndEstimate, Reducer.Context ctx) throws IOException, InterruptedException {
            double error = Double.NaN;
            boolean bothFound = false;
            for (DoubleWritable ratingOrEstimate : ratingAndEstimate) {
                if (Double.isNaN(error)) {
                    error = ratingOrEstimate.get();
                    continue;
                }
                error -= ratingOrEstimate.get();
                bothFound = true;
                break;
            }
            if (bothFound) {
                ctx.write((Object)new DoubleWritable(error), (Object)NullWritable.get());
            }
        }
    }

    public static class PairsWithRatingMapper
    extends Mapper<LongWritable, Text, IntPairWritable, DoubleWritable> {
        protected void map(LongWritable key, Text value, Mapper.Context ctx) throws IOException, InterruptedException {
            String[] tokens = TasteHadoopUtils.splitPrefTokens((CharSequence)value.toString());
            int userIDIndex = TasteHadoopUtils.idToIndex((long)Long.parseLong(tokens[0]));
            int itemIDIndex = TasteHadoopUtils.idToIndex((long)Long.parseLong(tokens[1]));
            double rating = Double.parseDouble(tokens[2]);
            ctx.write((Object)new IntPairWritable(userIDIndex, itemIDIndex), (Object)new DoubleWritable(rating));
        }
    }
}

