/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.eval;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class InMemoryFactorizationEvaluator
extends AbstractJob {
    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new InMemoryFactorizationEvaluator(), (String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        this.addOption("pairs", "p", "path containing the test ratings, each line must be userID,itemID,rating", true);
        this.addOption("userFeatures", "u", "path to the user feature matrix", true);
        this.addOption("itemFeatures", "i", "path to the item feature matrix", true);
        this.addOutputOption();
        Map parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Path pairs = new Path((String)parsedArgs.get("--pairs"));
        Path userFeatures = new Path((String)parsedArgs.get("--userFeatures"));
        Path itemFeatures = new Path((String)parsedArgs.get("--itemFeatures"));
        Matrix u = this.readMatrix(userFeatures);
        Matrix m = this.readMatrix(itemFeatures);
        FullRunningAverage rmseAvg = new FullRunningAverage();
        FullRunningAverage maeAvg = new FullRunningAverage();
        int pairsUsed = 1;
        OutputStreamWriter writer = new OutputStreamWriter(System.out);
        try {
            for (Preference pref : this.readProbePreferences(pairs)) {
                int userID = (int)pref.getUserID();
                int itemID = (int)pref.getItemID();
                double rating = pref.getValue();
                double estimate = u.getRow(userID).dot(m.getRow(itemID));
                double err = rating - estimate;
                rmseAvg.addDatum(err * err);
                maeAvg.addDatum(Math.abs(err));
                writer.write("Probe [" + pairsUsed + "], rating of user [" + userID + "] towards item [" + itemID + "], " + "[" + rating + "] estimated [" + estimate + "]\n");
                ++pairsUsed;
            }
            double rmse = Math.sqrt(rmseAvg.getAverage());
            double mae = maeAvg.getAverage();
            writer.write("RMSE: " + rmse + ", MAE: " + mae + "\n");
        }
        catch (Throwable throwable) {
            IOUtils.quietClose((Closeable[])new Closeable[]{writer});
            throw throwable;
        }
        IOUtils.quietClose((Closeable[])new Closeable[]{writer});
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Matrix readMatrix(Path dir) throws IOException {
        SparseMatrix matrix = new SparseMatrix(new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE});
        FileSystem fs = dir.getFileSystem(this.getConf());
        for (FileStatus seqFile : fs.globStatus(new Path(dir, "part-*"))) {
            Path path = seqFile.getPath();
            SequenceFile.Reader reader = null;
            try {
                reader = new SequenceFile.Reader(fs, path, this.getConf());
                IntWritable key = new IntWritable();
                VectorWritable value = new VectorWritable();
                while (reader.next((Writable)key, (Writable)value)) {
                    int row = key.get();
                    Iterator elementsIterator = value.get().iterateNonZero();
                    while (elementsIterator.hasNext()) {
                        Vector.Element element = (Vector.Element)elementsIterator.next();
                        matrix.set(row, element.index(), element.get());
                    }
                }
            }
            catch (Throwable throwable) {
                IOUtils.quietClose((Closeable[])new Closeable[]{reader});
                throw throwable;
            }
            IOUtils.quietClose((Closeable[])new Closeable[]{reader});
        }
        return matrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Preference> readProbePreferences(Path dir) throws IOException {
        LinkedList<Preference> preferences = new LinkedList<Preference>();
        FileSystem fs = dir.getFileSystem(this.getConf());
        for (FileStatus seqFile : fs.globStatus(new Path(dir, "part-*"))) {
            Path path = seqFile.getPath();
            FSDataInputStream in = null;
            try {
                String line;
                in = fs.open(path);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, Charset.forName("UTF-8")));
                while ((line = reader.readLine()) != null) {
                    String[] tokens = TasteHadoopUtils.splitPrefTokens((CharSequence)line);
                    long userID = Long.parseLong(tokens[0]);
                    long itemID = Long.parseLong(tokens[1]);
                    float value = Float.parseFloat(tokens[2]);
                    preferences.add((Preference)new GenericPreference(userID, itemID, value));
                }
            }
            catch (Throwable throwable) {
                IOUtils.quietClose((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.quietClose((Closeable[])new Closeable[]{in});
        }
        return preferences;
    }
}

