/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.cdbw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.OnlineGaussianAccumulator;
import org.apache.mahout.clustering.evaluation.RepresentativePointsMapper;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDbwEvaluator {
    private static final Logger log = LoggerFactory.getLogger(CDbwEvaluator.class);
    private final Map<Integer, List<VectorWritable>> representativePoints;
    private final Map<Integer, Double> stDevs = new HashMap<Integer, Double>();
    private final List<Cluster> clusters;
    private final DistanceMeasure measure;
    private boolean pruned;

    public CDbwEvaluator(Map<Integer, List<VectorWritable>> representativePoints, List<Cluster> clusters, DistanceMeasure measure) {
        this.representativePoints = representativePoints;
        this.clusters = clusters;
        this.measure = measure;
        for (Integer cId : representativePoints.keySet()) {
            this.computeStd(cId);
        }
    }

    public CDbwEvaluator(Configuration conf, Path clustersIn) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        this.measure = ccl.loadClass(conf.get("org.apache.mahout.clustering.measure")).asSubclass(DistanceMeasure.class).newInstance();
        this.representativePoints = RepresentativePointsMapper.getRepresentativePoints(conf);
        this.clusters = CDbwEvaluator.loadClusters(conf, clustersIn);
        for (Integer cId : this.representativePoints.keySet()) {
            this.computeStd(cId);
        }
    }

    private static List<Cluster> loadClusters(Configuration conf, Path clustersIn) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (Cluster value : new SequenceFileDirValueIterable(clustersIn, PathType.LIST, PathFilters.logsCRCFilter(), conf)) {
            clusters.add(value);
        }
        return clusters;
    }

    private void computeStd(int cI) {
        List<VectorWritable> repPts = this.representativePoints.get(cI);
        OnlineGaussianAccumulator accumulator = new OnlineGaussianAccumulator();
        for (VectorWritable vw : repPts) {
            accumulator.observe(vw.get(), 1.0);
        }
        accumulator.compute();
        double d = accumulator.getAverageStd();
        this.stDevs.put(cI, d);
    }

    private boolean invalidCluster(Cluster clusterI) {
        List<VectorWritable> repPts = this.representativePoints.get(clusterI.getId());
        if (repPts.size() < 2) {
            return true;
        }
        for (VectorWritable vw : repPts) {
            Vector vector = vw.get();
            if (vector.equals(clusterI.getCenter())) continue;
            return false;
        }
        return true;
    }

    private void pruneInvalidClusters() {
        if (this.pruned) {
            return;
        }
        Iterator<Cluster> it = this.clusters.iterator();
        while (it.hasNext()) {
            Cluster cluster = it.next();
            if (!this.invalidCluster(cluster)) continue;
            log.info("Pruning cluster Id={}", (Object)cluster.getId());
            it.remove();
            this.representativePoints.remove(cluster.getId());
        }
        this.pruned = true;
    }

    double interDensity(Vector uIJ, int cI, int cJ) {
        List<VectorWritable> repI = this.representativePoints.get(cI);
        List<VectorWritable> repJ = this.representativePoints.get(cJ);
        double sum = 0.0;
        Double stdevI = this.stDevs.get(cI);
        Double stdevJ = this.stDevs.get(cJ);
        double avgStd = (stdevI + stdevJ) / 2.0;
        for (VectorWritable vwI : repI) {
            if (!(this.measure.distance(uIJ, vwI.get()) <= avgStd)) continue;
            sum += 1.0;
        }
        for (VectorWritable vwJ : repJ) {
            if (!(this.measure.distance(uIJ, vwJ.get()) <= avgStd)) continue;
            sum += 1.0;
        }
        int nI = repI.size();
        int nJ = repJ.size();
        return sum / (double)(nI + nJ);
    }

    public double getCDbw() {
        this.pruneInvalidClusters();
        return this.intraClusterDensity() * this.separation();
    }

    public double intraClusterDensity() {
        this.pruneInvalidClusters();
        double stdev = 0.0;
        for (Integer cI : this.representativePoints.keySet()) {
            stdev += this.stDevs.get(cI).doubleValue();
        }
        int c = this.representativePoints.size();
        stdev /= (double)c;
        double sumI = 0.0;
        for (Cluster cluster : this.clusters) {
            Integer cI = cluster.getId();
            List<VectorWritable> repPtsI = this.representativePoints.get(cI);
            int r = repPtsI.size();
            double sumJ = 0.0;
            for (VectorWritable pt : repPtsI) {
                Vector repJ = pt.get();
                double densityIJ = this.measure.distance(cluster.getCenter(), repJ) <= stdev ? 1.0 : 0.0;
                sumJ += densityIJ / stdev;
            }
            sumI += sumJ / (double)r;
        }
        return sumI / (double)c;
    }

    public double separation() {
        this.pruneInvalidClusters();
        double minDistanceSum = 0.0;
        for (int i = 0; i < this.clusters.size(); ++i) {
            Integer cI = this.clusters.get(i).getId();
            List<VectorWritable> closRepI = this.representativePoints.get(cI);
            for (int j = 0; j < this.clusters.size(); ++j) {
                if (i == j) continue;
                Integer cJ = this.clusters.get(j).getId();
                List<VectorWritable> closRepJ = this.representativePoints.get(cJ);
                double minDistance = Double.MAX_VALUE;
                for (VectorWritable aRepI : closRepI) {
                    for (VectorWritable aRepJ : closRepJ) {
                        double distance = this.measure.distance(aRepI.get(), aRepJ.get());
                        if (!(distance < minDistance)) continue;
                        minDistance = distance;
                    }
                }
                minDistanceSum += minDistance;
            }
        }
        return minDistanceSum / (1.0 + this.interClusterDensity());
    }

    public double interClusterDensity() {
        this.pruneInvalidClusters();
        double sum = 0.0;
        for (int i = 0; i < this.clusters.size(); ++i) {
            Integer cI = this.clusters.get(i).getId();
            List<VectorWritable> repI = this.representativePoints.get(cI);
            for (int j = 1; j < this.clusters.size(); ++j) {
                Integer cJ = this.clusters.get(j).getId();
                if (i == j) continue;
                List<VectorWritable> repJ = this.representativePoints.get(cJ);
                double minDistance = Double.MAX_VALUE;
                Vector uIJ = null;
                for (VectorWritable aRepI : repI) {
                    for (VectorWritable aRepJ : repJ) {
                        Vector closRepJ;
                        Vector closRepI = aRepI.get();
                        double distance = this.measure.distance(closRepI, closRepJ = aRepJ.get());
                        if (!(distance < minDistance)) continue;
                        minDistance = distance;
                        uIJ = closRepI.plus(closRepJ).divide(2.0);
                    }
                }
                double stDevI = this.stDevs.get(cI);
                double stDevJ = this.stDevs.get(cJ);
                double interDensity = this.interDensity(uIJ, cI, cJ);
                double stdSum = stDevI + stDevJ;
                double density = 0.0;
                if (stdSum > 0.0) {
                    density = minDistance * interDensity / stdSum;
                }
                log.debug("minDistance[{},{}]={}", new Object[]{cI, cJ, minDistance});
                log.debug("stDev[{}]={}", (Object)cI, (Object)stDevI);
                log.debug("stDev[{}]={}", (Object)cJ, (Object)stDevJ);
                log.debug("interDensity[{},{}]={}", new Object[]{cI, cJ, interDensity});
                log.debug("density[{},{}]={}", new Object[]{cI, cJ, density});
                sum += density;
            }
        }
        log.debug("interClusterDensity={}", (Object)sum);
        return sum;
    }
}

