/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.benchmark;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.CommandLineUtil;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.TimingStatistics;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.distance.CosineDistanceMeasure;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.common.distance.SquaredEuclideanDistanceMeasure;
import org.apache.mahout.common.distance.TanimotoDistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorBenchmarks {
    private static final Logger log = LoggerFactory.getLogger(VectorBenchmarks.class);
    private static final Pattern TAB_PATTERN = Pattern.compile("\t");
    private final Vector[][] vectors;
    private final Vector[] clusters;
    private final SparseMatrix clusterDistances;
    private final List<Vector> randomVectors = new ArrayList<Vector>();
    private final List<int[]> randomVectorIndices = new ArrayList<int[]>();
    private final List<double[]> randomVectorValues = new ArrayList<double[]>();
    private final int cardinality;
    private final int sparsity;
    private final int numVectors;
    private final int loop;
    private final int opsPerUnit;
    private final Map<String, Integer> implType = new HashMap<String, Integer>();
    private final Map<String, List<String[]>> statsMap = new HashMap<String, List<String[]>>();
    private final int numClusters;

    public VectorBenchmarks(int cardinality, int sparsity, int numVectors, int numClusters, int loop, int opsPerUnit) {
        Random r = RandomUtils.getRandom();
        this.cardinality = cardinality;
        this.sparsity = sparsity;
        this.numVectors = numVectors;
        this.numClusters = numClusters;
        this.loop = loop;
        this.opsPerUnit = opsPerUnit;
        for (int i = 0; i < numVectors; ++i) {
            SequentialAccessSparseVector v = new SequentialAccessSparseVector(cardinality, sparsity);
            BitSet featureSpace = new BitSet(cardinality);
            int[] indexes = new int[sparsity];
            double[] values = new double[sparsity];
            int j = 0;
            while (j < sparsity) {
                double value = r.nextGaussian();
                int index = r.nextInt(cardinality);
                if (featureSpace.get(index)) continue;
                featureSpace.set(index);
                indexes[j] = index;
                values[j++] = value;
                v.set(index, value);
            }
            this.randomVectorIndices.add(indexes);
            this.randomVectorValues.add(values);
            this.randomVectors.add((Vector)v);
        }
        this.vectors = new Vector[3][numVectors];
        this.clusters = new Vector[numClusters];
        this.clusterDistances = new SparseMatrix(numClusters, numClusters);
    }

    private void printStats(TimingStatistics stats, String benchmarkName, String implName, String content) {
        this.printStats(stats, benchmarkName, implName, content, 1);
    }

    private void printStats(TimingStatistics stats, String benchmarkName, String implName) {
        this.printStats(stats, benchmarkName, implName, "", 1);
    }

    private void printStats(TimingStatistics stats, String benchmarkName, String implName, String content, int multiplier) {
        float speed = (float)(multiplier * this.loop * this.numVectors * this.sparsity) * 1000.0f * 12.0f / (float)stats.getSumTime();
        float opsPerSec = (float)(this.loop * this.numVectors) * 1.0E9f / (float)stats.getSumTime();
        log.info("{} {} \n{} {} \nSpeed: {} UnitsProcessed/sec {} MBytes/sec                                   ", new Object[]{benchmarkName, implName, content, stats.toString(), Float.valueOf(opsPerSec), Float.valueOf(speed)});
        String info = stats.toString().replaceAll("\n", "\t") + "\tSpeed = " + opsPerSec + " /sec\tRate = " + speed + " MB/s";
        if (!this.implType.containsKey(implName)) {
            this.implType.put(implName, this.implType.size());
        }
        int implId = this.implType.get(implName);
        if (!this.statsMap.containsKey(benchmarkName)) {
            this.statsMap.put(benchmarkName, new ArrayList());
        }
        List<String[]> implStats = this.statsMap.get(benchmarkName);
        while (implStats.size() < implId + 1) {
            implStats.add(new String[0]);
        }
        implStats.set(implId, TAB_PATTERN.split(info));
    }

    public void createBenchmark() {
        TimingStatistics.Call call;
        int i;
        int l;
        TimingStatistics stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                this.vectors[0][i] = new DenseVector(this.randomVectors.get(i));
                call.end();
            }
        }
        this.printStats(stats, "Create (copy)", "DenseVector");
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                this.vectors[1][i] = new RandomAccessSparseVector(this.randomVectors.get(i));
                call.end();
            }
        }
        this.printStats(stats, "Create (copy)", "RandSparseVector");
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                this.vectors[2][i] = new SequentialAccessSparseVector(this.randomVectors.get(i));
                call.end();
            }
        }
        this.printStats(stats, "Create (copy)", "SeqSparseVector");
    }

    private void buildVectorIncrementally(TimingStatistics stats, int randomIndex, Vector v, boolean useSetQuick) {
        int[] indexes = this.randomVectorIndices.get(randomIndex);
        double[] values = this.randomVectorValues.get(randomIndex);
        ArrayList<Integer> randomOrder = new ArrayList<Integer>();
        for (int i = 0; i < indexes.length; ++i) {
            randomOrder.add(i);
        }
        Collections.shuffle(randomOrder);
        int[] permutation = new int[randomOrder.size()];
        for (int i = 0; i < randomOrder.size(); ++i) {
            permutation[i] = (Integer)randomOrder.get(i);
        }
        TimingStatistics.Call call = stats.newCall();
        if (useSetQuick) {
            for (int i : permutation) {
                v.setQuick(indexes[i], values[i]);
            }
        } else {
            for (int i : permutation) {
                v.set(indexes[i], values[i]);
            }
        }
        call.end();
    }

    public void incrementalCreateBenchmark() {
        int i;
        int l;
        TimingStatistics stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                this.vectors[0][i] = new DenseVector(this.cardinality);
                this.buildVectorIncrementally(stats, i, this.vectors[0][i], false);
            }
        }
        this.printStats(stats, "Create (incrementally)", "DenseVector");
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                this.vectors[1][i] = new RandomAccessSparseVector(this.cardinality);
                this.buildVectorIncrementally(stats, i, this.vectors[1][i], false);
            }
        }
        this.printStats(stats, "Create (incrementally)", "RandSparseVector");
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numClusters; ++i) {
                this.clusters[i] = new RandomAccessSparseVector(this.cardinality);
                this.buildVectorIncrementally(stats, i, this.clusters[i], false);
            }
        }
        this.printStats(stats, "Create (incrementally)", "Clusters");
    }

    public void cloneBenchmark() {
        TimingStatistics.Call call;
        int i;
        int l;
        TimingStatistics stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                this.vectors[0][i] = this.vectors[0][i].clone();
                call.end();
            }
        }
        this.printStats(stats, "Clone", "DenseVector");
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                this.vectors[1][i] = this.vectors[1][i].clone();
                call.end();
            }
        }
        this.printStats(stats, "Clone", "RandSparseVector");
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                this.vectors[2][i] = this.vectors[2][i].clone();
                call.end();
            }
        }
        this.printStats(stats, "Clone", "SeqSparseVector");
    }

    public void serializeBenchmark() throws IOException {
        TimingStatistics.Call call;
        int i;
        int l;
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, new Path("/tmp/dense-vector"), IntWritable.class, VectorWritable.class);
        IntWritable one = new IntWritable(0);
        VectorWritable vec = new VectorWritable();
        TimingStatistics stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                vec.set(this.vectors[0][i]);
                writer.append((Writable)one, (Writable)vec);
                call.end();
            }
        }
        writer.close();
        this.printStats(stats, "Serialize", "DenseVector");
        writer = new SequenceFile.Writer(fs, conf, new Path("/tmp/randsparse-vector"), IntWritable.class, VectorWritable.class);
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                vec.set(this.vectors[1][i]);
                writer.append((Writable)one, (Writable)vec);
                call.end();
            }
        }
        writer.close();
        this.printStats(stats, "Serialize", "RandSparseVector");
        writer = new SequenceFile.Writer(fs, conf, new Path("/tmp/seqsparse-vector"), IntWritable.class, VectorWritable.class);
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                vec.set(this.vectors[2][i]);
                writer.append((Writable)one, (Writable)vec);
                call.end();
            }
        }
        writer.close();
        this.printStats(stats, "Serialize", "SeqSparseVector");
    }

    public void deserializeBenchmark() throws IOException {
        this.doDeserializeBenchmark("DenseVector", "/tmp/dense-vector");
        this.doDeserializeBenchmark("RandSparseVector", "/tmp/randsparse-vector");
        this.doDeserializeBenchmark("SeqSparseVector", "/tmp/seqsparse-vector");
    }

    private void doDeserializeBenchmark(String name, String pathString) throws IOException {
        TimingStatistics stats = new TimingStatistics();
        TimingStatistics.Call call = stats.newCall();
        SequenceFileValueIterator iterator = new SequenceFileValueIterator(new Path(pathString), true, new Configuration());
        while (iterator.hasNext()) {
            iterator.next();
            call.end();
            call = stats.newCall();
        }
        this.printStats(stats, "Deserialize", name);
    }

    public void dotBenchmark() {
        TimingStatistics.Call call;
        int i;
        int l;
        double result = 0.0;
        TimingStatistics stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                result += this.vectors[0][i].dot(this.vectors[0][(i + 1) % this.numVectors]);
                call.end();
            }
        }
        this.printStats(stats, "DotProduct", "DenseVector", "sum = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                result += this.vectors[1][i].dot(this.vectors[1][(i + 1) % this.numVectors]);
                call.end();
            }
        }
        this.printStats(stats, "DotProduct", "RandSparseVector", "sum = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                result += this.vectors[2][i].dot(this.vectors[2][(i + 1) % this.numVectors]);
                call.end();
            }
        }
        this.printStats(stats, "DotProduct", "SeqSparseVector", "sum = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                result += this.vectors[0][i].dot(this.vectors[1][(i + 1) % this.numVectors]);
                call.end();
            }
        }
        this.printStats(stats, "DotProduct", "Dense.fn(Rand)", "sum = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                result += this.vectors[0][i].dot(this.vectors[2][(i + 1) % this.numVectors]);
                call.end();
            }
        }
        this.printStats(stats, "DotProduct", "Dense.fn(Seq)", "sum = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                result += this.vectors[1][i].dot(this.vectors[0][(i + 1) % this.numVectors]);
                call.end();
            }
        }
        this.printStats(stats, "DotProduct", "Rand.fn(Dense)", "sum = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                result += this.vectors[1][i].dot(this.vectors[2][(i + 1) % this.numVectors]);
                call.end();
            }
        }
        this.printStats(stats, "DotProduct", "Rand.fn(Seq)", "sum = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                result += this.vectors[2][i].dot(this.vectors[0][(i + 1) % this.numVectors]);
                call.end();
            }
        }
        this.printStats(stats, "DotProduct", "Seq.fn(Dense)", "sum = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                result += this.vectors[2][i].dot(this.vectors[1][(i + 1) % this.numVectors]);
                call.end();
            }
        }
        this.printStats(stats, "DotProduct", "Seq.fn(Rand)", "sum = " + result + ' ');
    }

    public void closestCentroidBenchmark(DistanceMeasure measure) {
        for (int i = 0; i < this.numClusters; ++i) {
            for (int j = 0; j < this.numClusters; ++j) {
                double distance = Double.POSITIVE_INFINITY;
                if (i != j) {
                    distance = measure.distance(this.clusters[i], this.clusters[j]);
                }
                this.clusterDistances.setQuick(i, j, distance);
            }
        }
        long distanceCalculations = 0L;
        TimingStatistics stats = new TimingStatistics();
        for (int l = 0; l < this.loop; ++l) {
            TimingStatistics.Call call = stats.newCall();
            for (int i = 0; i < this.numVectors; ++i) {
                Vector vector = this.vectors[1][i];
                double minDistance = Double.MAX_VALUE;
                for (int k = 0; k < this.numClusters; ++k) {
                    double distance = measure.distance(vector, this.clusters[k]);
                    ++distanceCalculations;
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                }
            }
            call.end();
        }
        this.printStats(stats, measure.getClass().getName(), "Closest center without Elkan's trick", "distanceCalculations = " + distanceCalculations);
        distanceCalculations = 0L;
        stats = new TimingStatistics();
        Random rand = RandomUtils.getRandom();
        for (int l = 0; l < this.loop; ++l) {
            TimingStatistics.Call call = stats.newCall();
            for (int i = 0; i < this.numVectors; ++i) {
                Vector vector = this.vectors[1][i];
                int closestCentroid = rand.nextInt(this.numClusters);
                double dist = measure.distance(vector, this.clusters[closestCentroid]);
                ++distanceCalculations;
                for (int k = 0; k < this.numClusters; ++k) {
                    double centroidDist;
                    if (closestCentroid == k || !((centroidDist = this.clusterDistances.getQuick(k, closestCentroid)) < 2.0 * dist)) continue;
                    dist = measure.distance(vector, this.clusters[k]);
                    closestCentroid = k;
                    ++distanceCalculations;
                }
            }
            call.end();
        }
        this.printStats(stats, measure.getClass().getName(), "Closest center with Elkan's trick", "distanceCalculations = " + distanceCalculations);
    }

    public void distanceMeasureBenchmark(DistanceMeasure measure) {
        double distance;
        int u;
        double minDistance;
        TimingStatistics.Call call;
        int i;
        int l;
        double result = 0.0;
        TimingStatistics stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                minDistance = Double.MAX_VALUE;
                for (u = 0; u < this.opsPerUnit; ++u) {
                    distance = measure.distance(this.vectors[0][i], this.vectors[0][u]);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                }
                result += minDistance;
                call.end();
            }
        }
        this.printStats(stats, measure.getClass().getName(), "DenseVector", "minDistance = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                minDistance = Double.MAX_VALUE;
                for (u = 0; u < this.opsPerUnit; ++u) {
                    distance = measure.distance(this.vectors[1][i], this.vectors[1][u]);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                }
                result += minDistance;
                call.end();
            }
        }
        this.printStats(stats, measure.getClass().getName(), "RandSparseVector", "minDistance = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                minDistance = Double.MAX_VALUE;
                for (u = 0; u < this.opsPerUnit; ++u) {
                    distance = measure.distance(this.vectors[2][i], this.vectors[2][u]);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                }
                result += minDistance;
                call.end();
            }
        }
        this.printStats(stats, measure.getClass().getName(), "SeqSparseVector", "minDistance = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                minDistance = Double.MAX_VALUE;
                for (u = 0; u < this.opsPerUnit; ++u) {
                    distance = measure.distance(this.vectors[0][i], this.vectors[1][u]);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                }
                result += minDistance;
                call.end();
            }
        }
        this.printStats(stats, measure.getClass().getName(), "Dense.fn(Rand)", "minDistance = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                minDistance = Double.MAX_VALUE;
                for (u = 0; u < this.opsPerUnit; ++u) {
                    distance = measure.distance(this.vectors[0][i], this.vectors[2][u]);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                }
                result += minDistance;
                call.end();
            }
        }
        this.printStats(stats, measure.getClass().getName(), "Dense.fn(Seq)", "minDistance = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                minDistance = Double.MAX_VALUE;
                for (u = 0; u < this.opsPerUnit; ++u) {
                    distance = measure.distance(this.vectors[1][i], this.vectors[0][u]);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                }
                result += minDistance;
                call.end();
            }
        }
        this.printStats(stats, measure.getClass().getName(), "Rand.fn(Dense)", "minDistance = " + result + ' ');
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                minDistance = Double.MAX_VALUE;
                for (u = 0; u < this.opsPerUnit; ++u) {
                    distance = measure.distance(this.vectors[1][i], this.vectors[2][u]);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                }
                result += minDistance;
                call.end();
            }
        }
        this.printStats(stats, measure.getClass().getName(), "Rand.fn(Seq)", "minDistance = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                minDistance = Double.MAX_VALUE;
                for (u = 0; u < this.opsPerUnit; ++u) {
                    distance = measure.distance(this.vectors[2][i], this.vectors[0][u]);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                }
                result += minDistance;
                call.end();
            }
        }
        this.printStats(stats, measure.getClass().getName(), "Seq.fn(Dense)", "minDistance = " + result + ' ');
        result = 0.0;
        stats = new TimingStatistics();
        for (l = 0; l < this.loop; ++l) {
            for (i = 0; i < this.numVectors; ++i) {
                call = stats.newCall();
                minDistance = Double.MAX_VALUE;
                for (u = 0; u < this.opsPerUnit; ++u) {
                    distance = measure.distance(this.vectors[2][i], this.vectors[1][u]);
                    if (!(distance < minDistance)) continue;
                    minDistance = distance;
                }
                result += minDistance;
                call.end();
            }
        }
        this.printStats(stats, measure.getClass().getName(), "Seq.fn(Rand)", "minDistance = " + result + ' ');
    }

    public static void main(String[] args) throws IOException {
        DefaultOptionBuilder obuilder = new DefaultOptionBuilder();
        ArgumentBuilder abuilder = new ArgumentBuilder();
        GroupBuilder gbuilder = new GroupBuilder();
        DefaultOption vectorSizeOpt = obuilder.withLongName("vectorSize").withRequired(false).withArgument(abuilder.withName("vs").withMinimum(1).withMaximum(1).create()).withDescription("Cardinality of the vector. Default 1000").withShortName("vs").create();
        DefaultOption vectorSparsityOpt = obuilder.withLongName("sparsity").withRequired(false).withArgument(abuilder.withName("sp").withMinimum(1).withMaximum(1).create()).withDescription("Sparsity of the vector. Default 1000").withShortName("sp").create();
        DefaultOption numVectorsOpt = obuilder.withLongName("numVectors").withRequired(false).withArgument(abuilder.withName("nv").withMinimum(1).withMaximum(1).create()).withDescription("Number of Vectors to create. Default: 100").withShortName("nv").create();
        DefaultOption numClustersOpt = obuilder.withLongName("numClusters").withRequired(false).withArgument(abuilder.withName("vs").withMinimum(1).withMaximum(1).create()).withDescription("Number of Vectors to create. Default: 10").withShortName("vs").create();
        DefaultOption loopOpt = obuilder.withLongName("loop").withRequired(false).withArgument(abuilder.withName("loop").withMinimum(1).withMaximum(1).create()).withDescription("Number of times to loop. Default: 200").withShortName("l").create();
        DefaultOption numOpsOpt = obuilder.withLongName("numOps").withRequired(false).withArgument(abuilder.withName("numOps").withMinimum(1).withMaximum(1).create()).withDescription("Number of operations to do per timer. E.g In distance measure, the distance is calculated numOps times and the total time is measured. Default: 10").withShortName("no").create();
        Option helpOpt = DefaultOptionCreator.helpOption();
        Group group = gbuilder.withName("Options").withOption((Option)vectorSizeOpt).withOption((Option)vectorSparsityOpt).withOption((Option)numVectorsOpt).withOption((Option)loopOpt).withOption((Option)numOpsOpt).withOption(helpOpt).create();
        try {
            Parser parser = new Parser();
            parser.setGroup(group);
            CommandLine cmdLine = parser.parse(args);
            if (cmdLine.hasOption(helpOpt)) {
                CommandLineUtil.printHelp((Group)group);
                return;
            }
            int cardinality = 1000;
            if (cmdLine.hasOption((Option)vectorSizeOpt)) {
                cardinality = Integer.parseInt((String)cmdLine.getValue((Option)vectorSizeOpt));
            }
            int numClusters = 25;
            if (cmdLine.hasOption((Option)numClustersOpt)) {
                numClusters = Integer.parseInt((String)cmdLine.getValue((Option)numClustersOpt));
            }
            int sparsity = 1000;
            if (cmdLine.hasOption((Option)vectorSparsityOpt)) {
                sparsity = Integer.parseInt((String)cmdLine.getValue((Option)vectorSparsityOpt));
            }
            int numVectors = 100;
            if (cmdLine.hasOption((Option)numVectorsOpt)) {
                numVectors = Integer.parseInt((String)cmdLine.getValue((Option)numVectorsOpt));
            }
            int loop = 200;
            if (cmdLine.hasOption((Option)loopOpt)) {
                loop = Integer.parseInt((String)cmdLine.getValue((Option)loopOpt));
            }
            int numOps = 10;
            if (cmdLine.hasOption((Option)numOpsOpt)) {
                numOps = Integer.parseInt((String)cmdLine.getValue((Option)numOpsOpt));
            }
            VectorBenchmarks mark = new VectorBenchmarks(cardinality, sparsity, numVectors, numClusters, loop, numOps);
            mark.createBenchmark();
            mark.incrementalCreateBenchmark();
            mark.cloneBenchmark();
            mark.dotBenchmark();
            mark.serializeBenchmark();
            mark.deserializeBenchmark();
            mark.distanceMeasureBenchmark((DistanceMeasure)new CosineDistanceMeasure());
            mark.distanceMeasureBenchmark((DistanceMeasure)new SquaredEuclideanDistanceMeasure());
            mark.distanceMeasureBenchmark((DistanceMeasure)new EuclideanDistanceMeasure());
            mark.distanceMeasureBenchmark((DistanceMeasure)new ManhattanDistanceMeasure());
            mark.distanceMeasureBenchmark((DistanceMeasure)new TanimotoDistanceMeasure());
            mark.closestCentroidBenchmark((DistanceMeasure)new CosineDistanceMeasure());
            mark.closestCentroidBenchmark((DistanceMeasure)new SquaredEuclideanDistanceMeasure());
            mark.closestCentroidBenchmark((DistanceMeasure)new EuclideanDistanceMeasure());
            mark.closestCentroidBenchmark((DistanceMeasure)new ManhattanDistanceMeasure());
            mark.closestCentroidBenchmark((DistanceMeasure)new TanimotoDistanceMeasure());
            log.info("\n{}", (Object)mark);
        }
        catch (OptionException e) {
            CommandLineUtil.printHelp((Group)group);
        }
    }

    public String toString() {
        int pad = 24;
        StringBuilder sb = new StringBuilder(1000);
        sb.append(StringUtils.rightPad((String)"BenchMarks", (int)pad));
        block0: for (int i = 0; i < this.implType.size(); ++i) {
            for (Map.Entry<String, Integer> e : this.implType.entrySet()) {
                if (e.getValue() != i) continue;
                sb.append(StringUtils.rightPad((String)e.getKey(), (int)pad).substring(0, pad));
                continue block0;
            }
        }
        sb.append('\n');
        ArrayList<String> keys = new ArrayList<String>(this.statsMap.keySet());
        Collections.sort(keys);
        for (String benchmarkName : keys) {
            List<String[]> implTokenizedStats = this.statsMap.get(benchmarkName);
            int maxStats = 0;
            for (String[] stat : implTokenizedStats) {
                maxStats = Math.max(maxStats, stat.length);
            }
            for (int i = 0; i < maxStats; ++i) {
                boolean printedName = false;
                for (String[] stats : implTokenizedStats) {
                    if (i == 0 && !printedName) {
                        sb.append(StringUtils.rightPad((String)benchmarkName, (int)pad));
                        printedName = true;
                    } else if (!printedName) {
                        printedName = true;
                        sb.append(StringUtils.rightPad((String)"", (int)pad));
                    }
                    if (stats.length > i) {
                        sb.append(StringUtils.rightPad((String)stats[i], (int)pad));
                        continue;
                    }
                    sb.append(StringUtils.rightPad((String)"", (int)pad));
                }
                sb.append('\n');
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

