/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing.evolutionmonitor;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import org.uncommons.watchmaker.framework.EvolutionObserver;
import org.uncommons.watchmaker.framework.PopulationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusBar
extends Box
implements EvolutionObserver<Object> {
    private final JLabel generationsLabel = new JLabel("N/A", 4);
    private final JLabel timeLabel = new JLabel("N/A", 4);
    private final JLabel populationLabel = new JLabel("N/A", 4);
    private final JLabel elitismLabel = new JLabel("N/A", 4);

    public StatusBar() {
        super(0);
        this.add(new JLabel("Population Size: "));
        this.add(this.populationLabel);
        this.add(StatusBar.createHorizontalStrut(20));
        this.add(new JLabel("Elitism: "));
        this.add(this.elitismLabel);
        this.add(StatusBar.createHorizontalStrut(20));
        this.add(new JLabel("Generations: "));
        this.add(this.generationsLabel);
        this.add(StatusBar.createHorizontalStrut(20));
        this.add(new JLabel("Elapsed Time: "));
        this.add(this.timeLabel);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.populationLabel.setName("Population");
        this.elitismLabel.setName("Elitism");
        this.generationsLabel.setName("Generations");
        this.timeLabel.setName("Time");
    }

    @Override
    public void populationUpdate(PopulationData<?> populationData) {
        this.populationLabel.setText(String.valueOf(populationData.getPopulationSize()));
        this.elitismLabel.setText(String.valueOf(populationData.getEliteCount()));
        this.generationsLabel.setText(String.valueOf(populationData.getGenerationNumber() + 1));
        this.timeLabel.setText(this.formatTime(populationData.getElapsedTime()));
    }

    private String formatTime(long time) {
        long seconds = time / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        StringBuilder buffer = new StringBuilder();
        if (hours < 10L) {
            buffer.append('0');
        }
        buffer.append(hours);
        buffer.append(':');
        if (minutes < 10L) {
            buffer.append('0');
        }
        buffer.append(minutes);
        buffer.append(':');
        if (seconds < 10L) {
            buffer.append('0');
        }
        buffer.append(seconds);
        return buffer.toString();
    }
}

