/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing.evolutionmonitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.uncommons.watchmaker.framework.EvolutionObserver;
import org.uncommons.watchmaker.framework.PopulationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PopulationFitnessView
extends JPanel
implements EvolutionObserver<Object> {
    private static final int SHOW_FIXED_GENERATIONS = 200;
    private final XYSeries bestSeries = new XYSeries((Comparable)((Object)"Fittest Individual"));
    private final XYSeries meanSeries = new XYSeries((Comparable)((Object)"Population Mean Fitness"));
    private final XYSeriesCollection dataSet = new XYSeriesCollection();
    private final ValueAxis domainAxis;
    private final ValueAxis rangeAxis;
    private final JRadioButton allDataButton = new JRadioButton("All Data", false);
    private final JCheckBox invertCheckBox = new JCheckBox("Invert Range Axis", false);

    PopulationFitnessView() {
        super(new BorderLayout());
        this.dataSet.addSeries(this.bestSeries);
        this.dataSet.addSeries(this.meanSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Population Fitness", (String)"Generations", (String)"Fitness", (XYDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.domainAxis = chart.getXYPlot().getDomainAxis();
        this.rangeAxis = chart.getXYPlot().getRangeAxis();
        this.domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.domainAxis.setLowerMargin(0.0);
        this.domainAxis.setUpperMargin(0.05);
        this.domainAxis.setRangeWithMargins(0.0, 200.0);
        this.rangeAxis.setAutoRange(true);
        ChartPanel chartPanel = new ChartPanel(chart, 680, 420, 300, 200, 1024, 768, true, false, true, true, false, true);
        this.add((Component)chartPanel, "Center");
        this.add((Component)this.createControls(), "South");
    }

    private JComponent createControls() {
        JPanel controls = new JPanel(new FlowLayout(2));
        this.allDataButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                PopulationFitnessView.this.updateDomainAxisRange();
            }
        });
        JRadioButton recentDataButton = new JRadioButton("Last 200 Generations", true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.allDataButton);
        buttonGroup.add(recentDataButton);
        controls.add(this.allDataButton);
        controls.add(recentDataButton);
        JCheckBox meanCheckBox = new JCheckBox("Show Mean", true);
        meanCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    PopulationFitnessView.this.dataSet.addSeries(PopulationFitnessView.this.meanSeries);
                } else {
                    PopulationFitnessView.this.dataSet.removeSeries(PopulationFitnessView.this.meanSeries);
                }
            }
        });
        controls.add(meanCheckBox);
        this.invertCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PopulationFitnessView.this.rangeAxis.setInverted(PopulationFitnessView.this.invertCheckBox.isSelected());
            }
        });
        controls.add(this.invertCheckBox);
        return controls;
    }

    private void updateDomainAxisRange() {
        int count = this.dataSet.getSeries(0).getItemCount();
        if (count < 200) {
            this.domainAxis.setRangeWithMargins(0.0, 200.0);
        } else if (this.allDataButton.isSelected()) {
            this.domainAxis.setRangeWithMargins(0.0, (double)Math.max(200, count));
        } else {
            this.domainAxis.setRangeWithMargins((double)(count - 200), (double)count);
        }
    }

    @Override
    public void populationUpdate(final PopulationData<?> populationData) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (populationData.getGenerationNumber() == 0) {
                    if (!populationData.isNaturalFitness()) {
                        PopulationFitnessView.this.invertCheckBox.setSelected(true);
                    }
                    PopulationFitnessView.this.meanSeries.clear();
                    PopulationFitnessView.this.bestSeries.clear();
                }
                PopulationFitnessView.this.meanSeries.add((double)populationData.getGenerationNumber(), populationData.getMeanFitness());
                double best = populationData.getBestCandidateFitness();
                PopulationFitnessView.this.bestSeries.add((double)populationData.getGenerationNumber(), best);
                PopulationFitnessView.this.updateDomainAxisRange();
            }
        });
    }
}

