/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing.evolutionmonitor;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

class JVMView
extends JPanel {
    private static final int MEGABYTE = 0x100000;
    private final TimeSeries memoryUsageSeries = new TimeSeries((Comparable)((Object)"Memory Usage"));
    private final TimeSeries heapSizeSeries = new TimeSeries((Comparable)((Object)"Heap Size"));
    private final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();

    JVMView() {
        super(new BorderLayout());
        double maxMemory = (double)this.memoryBean.getHeapMemoryUsage().getMax() / 1048576.0;
        ChartPanel heapPanel = new ChartPanel(this.createHeapChart(maxMemory), false, true, true, false, true);
        heapPanel.setMouseZoomable(false);
        this.add((Component)heapPanel, "Center");
        this.add((Component)this.createControls(), "South");
        Timer timer = new Timer(5000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JVMView.this.addMemoryDataPoint();
            }
        });
        this.addMemoryDataPoint();
        timer.start();
    }

    private JFreeChart createHeapChart(double maxMemory) {
        TimeSeriesCollection dataSet = new TimeSeriesCollection();
        dataSet.addSeries(this.memoryUsageSeries);
        dataSet.addSeries(this.heapSizeSeries);
        JFreeChart chart = ChartFactory.createXYAreaChart((String)"JVM Heap", (String)"Time", (String)"Megabytes", (XYDataset)dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        DateAxis timeAxis = new DateAxis("Time");
        timeAxis.setLowerMargin(0.0);
        timeAxis.setUpperMargin(0.0);
        chart.getXYPlot().setDomainAxis((ValueAxis)timeAxis);
        chart.getXYPlot().getRangeAxis().setLowerBound(0.0);
        chart.getXYPlot().getRangeAxis().setUpperBound(maxMemory * 1.1);
        ValueMarker marker = new ValueMarker(maxMemory, (Paint)Color.BLACK, (Stroke)new BasicStroke(1.0f));
        marker.setLabel("Maximum Permitted Heap Size (adjust with -Xmx)");
        marker.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
        marker.setLabelAnchor(RectangleAnchor.RIGHT);
        chart.getXYPlot().addRangeMarker((Marker)marker);
        chart.getXYPlot().getRenderer().setSeriesPaint(0, (Paint)Color.RED);
        chart.getXYPlot().getRenderer().setSeriesPaint(1, (Paint)new Color(0, 128, 0, 128));
        return chart;
    }

    private JComponent createControls() {
        JPanel controls = new JPanel(new FlowLayout(2));
        JButton gcButton = new JButton("Request GC");
        gcButton.setToolTipText("Perform garbage collection (the JVM may ignore this request).");
        gcButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                JVMView.this.memoryBean.gc();
            }
        });
        controls.add(gcButton);
        return controls;
    }

    private void addMemoryDataPoint() {
        MemoryUsage heapUsage = this.memoryBean.getHeapMemoryUsage();
        double usedMegabytes = (double)heapUsage.getUsed() / 1048576.0;
        Second second = new Second();
        this.memoryUsageSeries.add((RegularTimePeriod)second, usedMegabytes);
        this.heapSizeSeries.add((RegularTimePeriod)second, (double)heapUsage.getCommitted() / 1048576.0);
    }
}

