/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing.evolutionmonitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.StandardChartTheme;
import org.uncommons.watchmaker.framework.EvolutionObserver;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.interactive.Renderer;
import org.uncommons.watchmaker.swing.ObjectSwingRenderer;
import org.uncommons.watchmaker.swing.evolutionmonitor.FittestCandidateView;
import org.uncommons.watchmaker.swing.evolutionmonitor.JVMView;
import org.uncommons.watchmaker.swing.evolutionmonitor.PopulationFitnessView;
import org.uncommons.watchmaker.swing.evolutionmonitor.StatusBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvolutionMonitor<T>
implements EvolutionObserver<T> {
    private final List<EvolutionObserver<? super T>> views = new LinkedList<EvolutionObserver<? super T>>();
    private JComponent monitorComponent;
    private Window window = null;

    public EvolutionMonitor() {
        this(new ObjectSwingRenderer());
    }

    public EvolutionMonitor(final Renderer<? super T, JComponent> renderer) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.init(renderer);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        EvolutionMonitor.this.init(renderer);
                    }
                });
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new InstantiationError(ex.getMessage());
            }
            catch (InvocationTargetException ex) {
                throw new InstantiationError(ex.getMessage());
            }
        }
    }

    private void init(Renderer<? super T, JComponent> renderer) {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        JTabbedPane tabs = new JTabbedPane();
        this.monitorComponent = new JPanel(new BorderLayout());
        this.monitorComponent.add((Component)tabs, "Center");
        FittestCandidateView<? super T> candidateView = new FittestCandidateView<T>(renderer);
        tabs.add("Fittest Individual", candidateView);
        this.views.add(candidateView);
        PopulationFitnessView fitnessView = new PopulationFitnessView();
        tabs.add("Population Fitness", fitnessView);
        this.views.add(fitnessView);
        JVMView jvmView = new JVMView();
        tabs.add("JVM Memory", jvmView);
        StatusBar statusBar = new StatusBar();
        this.monitorComponent.add((Component)statusBar, "South");
        this.views.add(statusBar);
    }

    @Override
    public void populationUpdate(PopulationData<? extends T> populationData) {
        for (EvolutionObserver<? extends T> evolutionObserver : this.views) {
            evolutionObserver.populationUpdate(populationData);
        }
    }

    public JComponent getGUIComponent() {
        return this.monitorComponent;
    }

    public void showInFrame(final String title, final boolean exitOnClose) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame(title);
                frame.setDefaultCloseOperation(exitOnClose ? 3 : 2);
                EvolutionMonitor.this.showWindow(frame);
            }
        });
    }

    public void showInDialog(final JFrame owner, final String title, final boolean modal) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialog dialog = new JDialog(owner, title, modal);
                dialog.setDefaultCloseOperation(2);
                EvolutionMonitor.this.showWindow(dialog);
            }
        });
    }

    private void showWindow(Window newWindow) {
        if (this.window != null) {
            this.window.remove(this.getGUIComponent());
            this.window.setVisible(false);
            this.window.dispose();
            this.window = null;
        }
        newWindow.add((Component)this.getGUIComponent(), "Center");
        newWindow.pack();
        newWindow.setVisible(true);
        this.window = newWindow;
    }
}

