/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.JComboBox;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.framework.EvaluatedCandidate;
import org.uncommons.watchmaker.framework.SelectionStrategy;
import org.uncommons.watchmaker.framework.selection.RankSelection;
import org.uncommons.watchmaker.framework.selection.RouletteWheelSelection;
import org.uncommons.watchmaker.framework.selection.StochasticUniversalSampling;
import org.uncommons.watchmaker.framework.selection.TournamentSelection;
import org.uncommons.watchmaker.framework.selection.TruncationSelection;
import org.uncommons.watchmaker.swing.EvolutionControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionStrategyControl<T>
implements EvolutionControl {
    private final JComboBox control;
    private final ProxySelectionStrategy selectionStrategy;

    public SelectionStrategyControl(List<SelectionStrategy<? super T>> options) {
        this.control = new JComboBox<SelectionStrategy<? super T>>(new Vector<SelectionStrategy<? super T>>(options));
        this.selectionStrategy = new ProxySelectionStrategy(options.get(0));
        this.control.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 1) {
                    SelectionStrategy delegate = (SelectionStrategy)SelectionStrategyControl.this.control.getSelectedItem();
                    SelectionStrategyControl.this.selectionStrategy.setDelegate(delegate);
                }
            }
        });
    }

    public static <T> List<SelectionStrategy<? super T>> createDefaultOptions(Probability tournamentProbability, double truncationRatio) {
        LinkedList<SelectionStrategy<T>> options = new LinkedList<SelectionStrategy<T>>();
        options.add(new RankSelection());
        options.add(new RouletteWheelSelection());
        options.add(new StochasticUniversalSampling());
        options.add(new TournamentSelection(tournamentProbability));
        options.add(new TruncationSelection(truncationRatio));
        return options;
    }

    @Override
    public JComboBox getControl() {
        return this.control;
    }

    @Override
    public void reset() {
        this.control.setSelectedIndex(0);
    }

    @Override
    public void setDescription(String description) {
        this.control.setToolTipText(description);
    }

    public SelectionStrategy<T> getSelectionStrategy() {
        return this.selectionStrategy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProxySelectionStrategy
    implements SelectionStrategy<T> {
        private volatile SelectionStrategy<? super T> delegate;

        ProxySelectionStrategy(SelectionStrategy<? super T> delegate) {
            this.delegate = delegate;
        }

        public void setDelegate(SelectionStrategy<? super T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public <S extends T> List<S> select(List<EvaluatedCandidate<S>> population, boolean naturalFitnessScores, int selectionSize, Random rng) {
            return this.delegate.select(population, naturalFitnessScores, selectionSize, rng);
        }
    }
}

