/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.uncommons.maths.Maths;
import org.uncommons.maths.number.AdjustableNumberGenerator;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.watchmaker.swing.EvolutionControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProbabilityParameterControl
implements EvolutionControl {
    private final Probability defaultValue;
    private final int range;
    private final JComponent control;
    private final JSlider probabilitySlider;
    private final JLabel valueLabel = new JLabel();
    private final AdjustableNumberGenerator<Probability> numberGenerator;
    private final DecimalFormat format;

    public ProbabilityParameterControl(Probability defaultValue) {
        this(Probability.ZERO, Probability.ONE, 2, defaultValue);
    }

    public ProbabilityParameterControl(Probability minimum, Probability maximum, int decimalPlaces, Probability initialValue) {
        if (initialValue.compareTo(minimum) < 0 || initialValue.compareTo(maximum) > 0) {
            throw new IllegalArgumentException("Initial value must respect minimum and maximum.");
        }
        if (decimalPlaces < 1) {
            throw new IllegalArgumentException("Number of decimal places must be >= 1.");
        }
        this.format = this.createFormat(decimalPlaces);
        this.defaultValue = initialValue;
        this.numberGenerator = new AdjustableNumberGenerator<Probability>(this.defaultValue);
        this.range = (int)Maths.raiseToPower(10, decimalPlaces);
        this.probabilitySlider = this.createSlider(initialValue, minimum, maximum);
        this.probabilitySlider.setName("Slider");
        this.control = new JPanel(new BorderLayout());
        this.control.add((Component)this.probabilitySlider, "Center");
        this.valueLabel.setText(this.format.format(this.defaultValue));
        this.control.add((Component)this.valueLabel, "West");
    }

    private DecimalFormat createFormat(int decimalPlaces) {
        StringBuilder formatString = new StringBuilder("0.");
        for (int i = 0; i < decimalPlaces; ++i) {
            formatString.append('0');
        }
        return new DecimalFormat(formatString.toString());
    }

    private JSlider createSlider(Probability initialValue, Probability minimum, Probability maximum) {
        int value = (int)Math.round((double)this.range * initialValue.doubleValue());
        int min = (int)Math.round((double)this.range * minimum.doubleValue());
        int max = (int)Math.round((double)this.range * maximum.doubleValue());
        final JSlider slider = new JSlider(min, max, value);
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Probability probability = new Probability((double)slider.getValue() / (double)ProbabilityParameterControl.this.range);
                ProbabilityParameterControl.this.numberGenerator.setValue(probability);
                ProbabilityParameterControl.this.valueLabel.setText(ProbabilityParameterControl.this.format.format(probability));
            }
        });
        slider.setMajorTickSpacing(10);
        slider.setMinorTickSpacing(5);
        slider.setPaintTicks(true);
        return slider;
    }

    @Override
    public JComponent getControl() {
        return this.control;
    }

    @Override
    public void reset() {
        int value = (int)Math.round((double)this.range * this.defaultValue.doubleValue());
        this.probabilitySlider.setValue(value);
        this.valueLabel.setText(this.format.format(this.defaultValue));
        this.numberGenerator.setValue(this.defaultValue);
    }

    public NumberGenerator<Probability> getNumberGenerator() {
        return this.numberGenerator;
    }

    @Override
    public void setDescription(String description) {
        this.probabilitySlider.setToolTipText(description);
        this.valueLabel.setToolTipText(description);
    }
}

