/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Map;
import org.jruby.RubyModule;
import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllocateBindingInstr
extends Instr {
    IRMethod scope;

    public AllocateBindingInstr(IRExecutionScope scope) {
        super(Operation.ALLOC_BINDING);
        this.scope = scope.getClosestMethodAncestor();
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{MetaObject.create(this.scope)};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new AllocateBindingInstr(ii.callerCFG.getScope());
    }

    @Override
    public String toString() {
        return "\t" + (Object)((Object)this.operation) + "(" + this.scope + ")";
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        RubyModule implementationClass = this.scope.getStaticScope().getModule();
        if (implementationClass == null) {
            implementationClass = interp.getRuntime().getObject();
        }
        interp.allocateSharedBindingScope(this.scope);
        return null;
    }
}

