/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.joni.Regex;

public abstract class SearchAlgorithm {
    public static final SearchAlgorithm NONE = new SearchAlgorithm(){

        public final String getName() {
            return "NONE";
        }

        public final int search(Regex regex, byte[] text, int textP, int textEnd, int textRange) {
            return textP;
        }

        public final int searchBackward(Regex regex, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            return textP;
        }
    };
    public static final SearchAlgorithm SLOW = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT";
        }

        public final int search(Regex regex, byte[] text, int textP, int textEnd, int textRange) {
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end2 = textEnd;
            if ((end2 -= targetEnd - targetP - 1) > textRange) {
                end2 = textRange;
            }
            for (int s2 = textP; s2 < end2; s2 += enc.length(text, s2, textEnd)) {
                int t;
                if (text[s2] != target[targetP]) continue;
                int p2 = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p2++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            s2 = (s2 -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            while (s2 >= textP) {
                if (text[s2] == target[targetP]) {
                    int t;
                    int p2 = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p2++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                s2 = enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    public static final SearchAlgorithm SLOW_SB = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_SB";
        }

        public final int search(Regex regex, byte[] text, int textP, int textEnd, int textRange) {
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end2 = textEnd;
            if ((end2 -= targetEnd - targetP - 1) > textRange) {
                end2 = textRange;
            }
            for (int s2 = textP; s2 < end2; ++s2) {
                int t;
                if (text[s2] != target[targetP]) continue;
                int p2 = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p2++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (text[s2] == target[targetP]) {
                    int t;
                    int p2 = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p2++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                --s2;
            }
            return -1;
        }
    };
    public static final SearchAlgorithm SLOW_IC_SB = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_IC_SB";
        }

        public final int search(Regex regex, byte[] text, int textP, int textEnd, int textRange) {
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end2 = textEnd;
            if ((end2 -= targetEnd - targetP - 1) > textRange) {
                end2 = textRange;
            }
            for (int s2 = textP; s2 < end2; ++s2) {
                int t;
                if (target[targetP] != toLowerTable[text[s2] & 0xFF]) continue;
                int p2 = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p2++] & 0xFF]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (target[targetP] == toLowerTable[text[s2] & 0xFF]) {
                    int t;
                    int p2 = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p2++] & 0xFF]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                --s2;
            }
            return -1;
        }
    };
    public static final SearchAlgorithm BM = new SearchAlgorithm(){
        private static final int BM_BACKWARD_SEARCH_LENGTH_THRESHOLD = 100;

        public final String getName() {
            return "EXACT_BM";
        }

        public final int search(Regex regex, byte[] text, int textP, int textEnd, int textRange) {
            int s2;
            byte[] target = regex.exact;
            int targetEnd = regex.exactEnd;
            int targetP = regex.exactP;
            int end2 = textRange + (targetEnd - targetP) - 1;
            if (end2 > textEnd) {
                end2 = textEnd;
            }
            int tail = targetEnd - 1;
            if (regex.intMap == null) {
                for (s2 = textP + (targetEnd - targetP) - 1; s2 < end2; s2 += regex.map[text[s2] & 0xFF]) {
                    int t;
                    int p2 = s2;
                    for (t = tail; t >= targetP && text[p2] == target[t]; --t) {
                        --p2;
                    }
                    if (t >= targetP) continue;
                    return p2 + 1;
                }
            } else {
                while (s2 < end2) {
                    int t;
                    int p3 = s2;
                    for (t = tail; t >= targetP && text[p3] == target[t]; --t) {
                        --p3;
                    }
                    if (t < targetP) {
                        return p3 + 1;
                    }
                    s2 += regex.intMap[text[s2] & 0xFF];
                }
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            int s2;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            if (regex.intMapBackward == null) {
                if (s_ - range_ < 100) {
                    return SLOW.searchBackward(regex, text, textP, adjustText, textEnd, textStart, s_, range_);
                }
                this.setBmBackwardSkip(regex, target, targetP, targetEnd);
            }
            s2 = textStart < (s2 = textEnd - (targetEnd - targetP)) ? textStart : enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            while (s2 >= textP) {
                int t;
                int p2 = s2;
                for (t = targetP; t < targetEnd && text[p2] == target[t]; ++t) {
                    ++p2;
                }
                if (t == targetEnd) {
                    return s2;
                }
                s2 -= regex.intMapBackward[text[s2] & 0xFF];
                s2 = enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }

        private void setBmBackwardSkip(Regex regex, byte[] bytes2, int p2, int end2) {
            int i2;
            int[] skip2;
            if (regex.intMapBackward == null) {
                skip2 = new int[256];
                regex.intMapBackward = skip2;
            } else {
                skip2 = regex.intMapBackward;
            }
            int len = end2 - p2;
            for (i2 = 0; i2 < 256; ++i2) {
                skip2[i2] = len;
            }
            for (i2 = len - 1; i2 > 0; --i2) {
                skip2[bytes2[i2] & 0xFF] = i2;
            }
        }
    };
    public static final SearchAlgorithm BM_NOT_REV = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_BM_NOT_REV";
        }

        public final int search(Regex regex, byte[] text, int textP, int textEnd, int textRange) {
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int end2 = textRange;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int targetP = regex.exactP;
            int tlen1 = tail - targetP;
            if (end2 + tlen1 > textEnd) {
                end2 = textEnd - tlen1;
            }
            int s2 = textP;
            if (regex.intMap == null) {
                while (s2 < end2) {
                    int t;
                    int se;
                    int p2 = se = s2 + tlen1;
                    for (t = tail; t >= targetP && text[p2] == target[t]; --t) {
                        --p2;
                    }
                    if (t < targetP) {
                        return s2;
                    }
                    byte skip2 = regex.map[text[se] & 0xFF];
                    t = s2;
                    while ((s2 += enc.length(text, s2, textEnd)) - t < skip2 && s2 < end2) {
                    }
                }
            } else {
                while (s2 < end2) {
                    int t;
                    int se;
                    int p3 = se = s2 + tlen1;
                    for (t = tail; t >= targetP && text[p3] == target[t]; --t) {
                        --p3;
                    }
                    if (t < targetP) {
                        return s2;
                    }
                    int skip3 = regex.intMap[text[se] & 0xFF];
                    t = s2;
                    while ((s2 += enc.length(text, s2, textEnd)) - t < skip3 && s2 < end2) {
                    }
                }
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            return BM.searchBackward(regex, text, textP, adjustText, textEnd, textStart, s_, range_);
        }
    };
    public static final SearchAlgorithm MAP = new SearchAlgorithm(){

        public final String getName() {
            return "MAP";
        }

        public final int search(Regex regex, byte[] text, int textP, int textEnd, int textRange) {
            Encoding enc = regex.enc;
            byte[] map = regex.map;
            for (int s2 = textP; s2 < textRange; s2 += enc.length(text, s2, textEnd)) {
                if (map[text[s2] & 0xFF] == 0) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Encoding enc = regex.enc;
            byte[] map = regex.map;
            int s2 = textStart;
            if (s2 >= textEnd) {
                s2 = textEnd - 1;
            }
            while (s2 >= textP) {
                if (map[text[s2] & 0xFF] != 0) {
                    return s2;
                }
                s2 = enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    public static final SearchAlgorithm MAP_SB = new SearchAlgorithm(){

        public final String getName() {
            return "MAP_SB";
        }

        public final int search(Regex regex, byte[] text, int textP, int textEnd, int textRange) {
            byte[] map = regex.map;
            for (int s2 = textP; s2 < textRange; ++s2) {
                if (map[text[s2] & 0xFF] == 0) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            byte[] map = regex.map;
            int s2 = textStart;
            if (s2 >= textEnd) {
                s2 = textEnd - 1;
            }
            while (s2 >= textP) {
                if (map[text[s2] & 0xFF] != 0) {
                    return s2;
                }
                --s2;
            }
            return -1;
        }
    };

    public abstract String getName();

    public abstract int search(Regex var1, byte[] var2, int var3, int var4, int var5);

    public abstract int searchBackward(Regex var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static final class SLOW_IC
    extends SearchAlgorithm {
        private final byte[] buf = new byte[18];
        private final IntHolder holder = new IntHolder();
        private final int caseFoldFlag;
        private final Encoding enc;

        public SLOW_IC(Regex regex) {
            this.caseFoldFlag = regex.caseFoldFlag;
            this.enc = regex.enc;
        }

        public final String getName() {
            return "EXACT_IC";
        }

        public final int search(Regex regex, byte[] text, int textP, int textEnd, int textRange) {
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end2 = textEnd;
            if ((end2 -= targetEnd - targetP - 1) > textRange) {
                end2 = textRange;
            }
            for (int s2 = textP; s2 < end2; s2 += this.enc.length(text, s2, textEnd)) {
                if (!this.lowerCaseMatch(target, targetP, targetEnd, text, s2, textEnd)) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            s2 = (s2 -= targetEnd - targetP) > textStart ? textStart : this.enc.leftAdjustCharHead(text, adjustText, s2, textEnd);
            while (s2 >= textP) {
                if (this.lowerCaseMatch(target, targetP, targetEnd, text, s2, textEnd)) {
                    return s2;
                }
                s2 = this.enc.prevCharHead(text, adjustText, s2, textEnd);
            }
            return -1;
        }

        private boolean lowerCaseMatch(byte[] t, int tP, int tEnd, byte[] bytes2, int p2, int end2) {
            this.holder.value = p2;
            while (tP < tEnd) {
                int lowlen = this.enc.mbcCaseFold(this.caseFoldFlag, bytes2, this.holder, end2, this.buf);
                if (lowlen == 1) {
                    if (t[tP++] == this.buf[0]) continue;
                    return false;
                }
                int q = 0;
                while (lowlen > 0) {
                    if (t[tP++] != this.buf[q++]) {
                        return false;
                    }
                    --lowlen;
                }
            }
            return true;
        }
    }
}

