
package eu.europa.data.europass.model.credentials_;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;


/**
 * &lt;p&gt;Java class for TextContentTypeCodeEnumType.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * &lt;pre&gt;
 * &amp;lt;simpleType name="TextContentTypeCodeEnumType"&amp;gt;
 *   &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}token"&amp;gt;
 *     &amp;lt;enumeration value="text/html"/&amp;gt;
 *     &amp;lt;enumeration value="text/plain"/&amp;gt;
 *   &amp;lt;/restriction&amp;gt;
 * &amp;lt;/simpleType&amp;gt;
 * &lt;/pre&gt;
 * 
 */
@XmlType(name = "TextContentTypeCodeEnumType")
@XmlEnum
@CodingStyleguideUnaware
public enum TextContentTypeCodeEnumType {

    @XmlEnumValue("text/html")
    TEXT_HTML("text/html"),
    @XmlEnumValue("text/plain")
    TEXT_PLAIN("text/plain");
    private final String value;

    TextContentTypeCodeEnumType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TextContentTypeCodeEnumType fromValue(String v) {
        for (TextContentTypeCodeEnumType c: TextContentTypeCodeEnumType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
