
package eu.europa.data.europass.model.credentials_;

import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * Indicator of *how well* the student was graded when compared to other students. The three values don't need to be very exact (one decimal place should be more than enough), but they SHOULD sum up to 100.
 * 
 * &lt;p&gt;Java class for ShortenedGrading complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="ShortenedGrading"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="percentageLower" type="{http://www.w3.org/2001/XMLSchema}decimal"/&amp;gt;
 *         &amp;lt;element name="percentageEqual" type="{http://www.w3.org/2001/XMLSchema}decimal"/&amp;gt;
 *         &amp;lt;element name="percentageHigher" type="{http://www.w3.org/2001/XMLSchema}decimal"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ShortenedGrading", propOrder = {
    "percentageLower",
    "percentageEqual",
    "percentageHigher"
})
@CodingStyleguideUnaware
public class ShortenedGrading implements IExplicitlyCloneable
{

    @XmlElement(required = true)
    private BigDecimal percentageLower;
    @XmlElement(required = true)
    private BigDecimal percentageEqual;
    @XmlElement(required = true)
    private BigDecimal percentageHigher;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ShortenedGrading() {
    }

    /**
     * Gets the value of the percentageLower property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    @Nullable
    public BigDecimal getPercentageLower() {
        return percentageLower;
    }

    /**
     * Sets the value of the percentageLower property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPercentageLower(
        @Nullable
        BigDecimal value) {
        this.percentageLower = value;
    }

    /**
     * Gets the value of the percentageEqual property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    @Nullable
    public BigDecimal getPercentageEqual() {
        return percentageEqual;
    }

    /**
     * Sets the value of the percentageEqual property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPercentageEqual(
        @Nullable
        BigDecimal value) {
        this.percentageEqual = value;
    }

    /**
     * Gets the value of the percentageHigher property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    @Nullable
    public BigDecimal getPercentageHigher() {
        return percentageHigher;
    }

    /**
     * Sets the value of the percentageHigher property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setPercentageHigher(
        @Nullable
        BigDecimal value) {
        this.percentageHigher = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ShortenedGrading rhs = ((ShortenedGrading) o);
        if (!EqualsHelper.equals(percentageEqual, rhs.percentageEqual)) {
            return false;
        }
        if (!EqualsHelper.equals(percentageHigher, rhs.percentageHigher)) {
            return false;
        }
        if (!EqualsHelper.equals(percentageLower, rhs.percentageLower)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(percentageEqual).append(percentageHigher).append(percentageLower).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("percentageEqual", percentageEqual).append("percentageHigher", percentageHigher).append("percentageLower", percentageLower).getToString();
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        ShortenedGrading ret) {
        ret.percentageEqual = percentageEqual;
        ret.percentageHigher = percentageHigher;
        ret.percentageLower = percentageLower;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ShortenedGrading clone() {
        ShortenedGrading ret = new ShortenedGrading();
        cloneTo(ret);
        return ret;
    }

}
