
package eu.europa.data.europass.model.credentials_;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * Description of a single score or score range within a histogram of results.
 * 
 * &lt;p&gt;Java class for ResultCategory complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="ResultCategory"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="label" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *         &amp;lt;element name="score" type="{http://data.europa.eu/europass/model/credentials#}TextScoreType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="minScore" type="{http://data.europa.eu/europass/model/credentials#}TextScoreType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="maxScore" type="{http://data.europa.eu/europass/model/credentials#}TextScoreType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="count" type="{http://www.w3.org/2001/XMLSchema}positiveInteger"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ResultCategory", propOrder = {
    "label",
    "score",
    "minScore",
    "maxScore",
    "count"
})
@CodingStyleguideUnaware
public class ResultCategory implements IExplicitlyCloneable
{

    @XmlElement(required = true)
    private List<LanguageStringType> label;
    private TextScoreType score;
    private TextScoreType minScore;
    private TextScoreType maxScore;
    @XmlElement(required = true)
    @XmlSchemaType(name = "positiveInteger")
    private BigInteger count;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ResultCategory() {
    }

    /**
     * Gets the value of the label property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the label property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getLabel().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageStringType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LanguageStringType> getLabel() {
        if (label == null) {
            label = new ArrayList<LanguageStringType>();
        }
        return this.label;
    }

    /**
     * Gets the value of the score property.
     * 
     * @return
     *     possible object is
     *     {@link TextScoreType }
     *     
     */
    @Nullable
    public TextScoreType getScore() {
        return score;
    }

    /**
     * Sets the value of the score property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextScoreType }
     *     
     */
    public void setScore(
        @Nullable
        TextScoreType value) {
        this.score = value;
    }

    /**
     * Gets the value of the minScore property.
     * 
     * @return
     *     possible object is
     *     {@link TextScoreType }
     *     
     */
    @Nullable
    public TextScoreType getMinScore() {
        return minScore;
    }

    /**
     * Sets the value of the minScore property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextScoreType }
     *     
     */
    public void setMinScore(
        @Nullable
        TextScoreType value) {
        this.minScore = value;
    }

    /**
     * Gets the value of the maxScore property.
     * 
     * @return
     *     possible object is
     *     {@link TextScoreType }
     *     
     */
    @Nullable
    public TextScoreType getMaxScore() {
        return maxScore;
    }

    /**
     * Sets the value of the maxScore property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextScoreType }
     *     
     */
    public void setMaxScore(
        @Nullable
        TextScoreType value) {
        this.maxScore = value;
    }

    /**
     * Gets the value of the count property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Nullable
    public BigInteger getCount() {
        return count;
    }

    /**
     * Sets the value of the count property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setCount(
        @Nullable
        BigInteger value) {
        this.count = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ResultCategory rhs = ((ResultCategory) o);
        if (!EqualsHelper.equals(count, rhs.count)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(label, rhs.label)) {
            return false;
        }
        if (!EqualsHelper.equals(maxScore, rhs.maxScore)) {
            return false;
        }
        if (!EqualsHelper.equals(minScore, rhs.minScore)) {
            return false;
        }
        if (!EqualsHelper.equals(score, rhs.score)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(count).append(label).append(maxScore).append(minScore).append(score).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("count", count).append("label", label).append("maxScore", maxScore).append("minScore", minScore).append("score", score).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setLabel(
        @Nullable
        final List<LanguageStringType> aList) {
        label = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasLabelEntries() {
        return (!getLabel().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoLabelEntries() {
        return getLabel().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getLabelCount() {
        return getLabel().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LanguageStringType getLabelAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLabel().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addLabel(
        @Nonnull
        final LanguageStringType elem) {
        getLabel().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        ResultCategory ret) {
        ret.count = count;
        if (label == null) {
            ret.label = null;
        } else {
            List<LanguageStringType> retLabel = new ArrayList<LanguageStringType>();
            for (LanguageStringType aItem: getLabel()) {
                retLabel.add(((aItem == null)?null:aItem.clone()));
            }
            ret.label = retLabel;
        }
        ret.maxScore = ((maxScore == null)?null:maxScore.clone());
        ret.minScore = ((minScore == null)?null:minScore.clone());
        ret.score = ((score == null)?null:score.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ResultCategory clone() {
        ResultCategory ret = new ResultCategory();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type TextScoreType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public TextScoreType setScore(
        @Nullable
        final String valueParam) {
        TextScoreType aObj = getScore();
        if (aObj == null) {
            aObj = new TextScoreType(valueParam);
            setScore(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type TextScoreType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public TextScoreType setMinScore(
        @Nullable
        final String valueParam) {
        TextScoreType aObj = getMinScore();
        if (aObj == null) {
            aObj = new TextScoreType(valueParam);
            setMinScore(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type TextScoreType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public TextScoreType setMaxScore(
        @Nullable
        final String valueParam) {
        TextScoreType aObj = getMaxScore();
        if (aObj == null) {
            aObj = new TextScoreType(valueParam);
            setMaxScore(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TextScoreType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextScoreType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getScoreValue() {
        TextScoreType aObj = getScore();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextScoreType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextScoreType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getMinScoreValue() {
        TextScoreType aObj = getMinScore();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TextScoreType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextScoreType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getMaxScoreValue() {
        TextScoreType aObj = getMaxScore();
        return (aObj == null)?null:aObj.getValue();
    }

}
