
package eu.europa.data.europass.model.credentials_;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.Duration;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * The details of a qualification that can or has been awarded such as the (expected) learning outcomes. This can be a copy or a specialization of an existing qualification standard. A qualification can be part of a national qualification framework (NQF Qualification) which can be specified by the NQF level. 
 * 
 * &lt;p&gt;Java class for QualificationType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="QualificationType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;group ref="{http://data.europa.eu/europass/model/credentials#}LearningSpecificationElements"/&amp;gt;
 *         &amp;lt;element name="isPartialQualification" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="eqfLevel" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;complexContent&amp;gt;
 *               &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
 *                 &amp;lt;sequence&amp;gt;
 *                   &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *                   &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *                   &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *                 &amp;lt;/sequence&amp;gt;
 *                 &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}EQFLevelEnumType" /&amp;gt;
 *                 &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *                 &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *                 &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
 *                 &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
 *               &amp;lt;/restriction&amp;gt;
 *             &amp;lt;/complexContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="nqfLevel" maxOccurs="unbounded" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;complexContent&amp;gt;
 *               &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
 *                 &amp;lt;sequence&amp;gt;
 *                   &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *                   &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *                   &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *                 &amp;lt;/sequence&amp;gt;
 *                 &amp;lt;attribute name="uri" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" /&amp;gt;
 *                 &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *                 &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *                 &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
 *                 &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}QualificationFrameworkEnumType" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
 *               &amp;lt;/restriction&amp;gt;
 *             &amp;lt;/complexContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="hasAccreditation" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="qualificationCode" maxOccurs="unbounded" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;complexContent&amp;gt;
 *               &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
 *                 &amp;lt;sequence&amp;gt;
 *                   &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *                   &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *                   &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *                 &amp;lt;/sequence&amp;gt;
 *                 &amp;lt;attribute name="uri" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" /&amp;gt;
 *                 &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *                 &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *                 &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
 *                 &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
 *               &amp;lt;/restriction&amp;gt;
 *             &amp;lt;/complexContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="hasPart" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="specializationOf" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *       &amp;lt;attribute name="id" use="required" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "QualificationType", propOrder = {
    "identifier",
    "type",
    "title",
    "altLabel",
    "definition",
    "description",
    "additionalNote",
    "homepage",
    "supplementaryDoc",
    "hasISCEDFCode",
    "hasEducationSubject",
    "volumeOfLearning",
    "hasECTSCreditPoints",
    "hasCreditPoints",
    "hasEducationLevel",
    "language",
    "mode",
    "learningSettingType",
    "duration",
    "targetGroup",
    "entryRequirementsNote",
    "learningOutcomes",
    "learningActivitySpecification",
    "assessmentSpecification",
    "entitlementSpecification",
    "awardingOpportunities",
    "isPartialQualification",
    "eqfLevel",
    "nqfLevel",
    "hasAccreditation",
    "qualificationCode",
    "hasPart",
    "specializationOf"
})
@CodingStyleguideUnaware
public class QualificationType implements IExplicitlyCloneable
{

    private List<IdentifierType> identifier;
    private List<QualificationType.Type> type;
    private List<LanguageStringType> title;
    private List<LanguageStringType> altLabel;
    private List<NoteType> definition;
    private List<NoteType> description;
    private List<NoteType> additionalNote;
    private List<DocumentType> homepage;
    private List<DocumentType> supplementaryDoc;
    @XmlElement(name = "hasISCED-FCode")
    private List<QualificationType.HasISCEDFCode> hasISCEDFCode;
    private List<QualificationType.HasEducationSubject> hasEducationSubject;
    private Duration volumeOfLearning;
    private ECTSCreditPointsType hasECTSCreditPoints;
    private List<CreditPointsType> hasCreditPoints;
    private List<QualificationType.HasEducationLevel> hasEducationLevel;
    private List<QualificationType.Language> language;
    private List<QualificationType.Mode> mode;
    private QualificationType.LearningSettingType learningSettingType;
    private Duration duration;
    private List<QualificationType.TargetGroup> targetGroup;
    private List<NoteType> entryRequirementsNote;
    private QualificationType.LearningOutcomes learningOutcomes;
    private IdReferenceType learningActivitySpecification;
    private IdReferenceType assessmentSpecification;
    private List<IdReferenceType> entitlementSpecification;
    private QualificationType.AwardingOpportunities awardingOpportunities;
    private Boolean isPartialQualification;
    private QualificationType.EqfLevel eqfLevel;
    private List<QualificationType.NqfLevel> nqfLevel;
    private List<IdReferenceType> hasAccreditation;
    private List<QualificationType.QualificationCode> qualificationCode;
    private List<IdReferenceType> hasPart;
    private IdReferenceType specializationOf;
    @XmlAttribute(name = "id", required = true)
    private String id;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public QualificationType() {
    }

    /**
     * Gets the value of the identifier property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the identifier property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getIdentifier().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdentifierType> getIdentifier() {
        if (identifier == null) {
            identifier = new ArrayList<IdentifierType>();
        }
        return this.identifier;
    }

    /**
     * Gets the value of the type property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the type property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getType().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link QualificationType.Type }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<QualificationType.Type> getType() {
        if (type == null) {
            type = new ArrayList<QualificationType.Type>();
        }
        return this.type;
    }

    /**
     * Gets the value of the title property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the title property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getTitle().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageStringType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LanguageStringType> getTitle() {
        if (title == null) {
            title = new ArrayList<LanguageStringType>();
        }
        return this.title;
    }

    /**
     * Gets the value of the altLabel property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the altLabel property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getAltLabel().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageStringType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LanguageStringType> getAltLabel() {
        if (altLabel == null) {
            altLabel = new ArrayList<LanguageStringType>();
        }
        return this.altLabel;
    }

    /**
     * Gets the value of the definition property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the definition property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getDefinition().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getDefinition() {
        if (definition == null) {
            definition = new ArrayList<NoteType>();
        }
        return this.definition;
    }

    /**
     * Gets the value of the description property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the description property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getDescription().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getDescription() {
        if (description == null) {
            description = new ArrayList<NoteType>();
        }
        return this.description;
    }

    /**
     * Gets the value of the additionalNote property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the additionalNote property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getAdditionalNote().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getAdditionalNote() {
        if (additionalNote == null) {
            additionalNote = new ArrayList<NoteType>();
        }
        return this.additionalNote;
    }

    /**
     * Gets the value of the homepage property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the homepage property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHomepage().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentType> getHomepage() {
        if (homepage == null) {
            homepage = new ArrayList<DocumentType>();
        }
        return this.homepage;
    }

    /**
     * Gets the value of the supplementaryDoc property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the supplementaryDoc property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getSupplementaryDoc().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentType> getSupplementaryDoc() {
        if (supplementaryDoc == null) {
            supplementaryDoc = new ArrayList<DocumentType>();
        }
        return this.supplementaryDoc;
    }

    /**
     * Gets the value of the hasISCEDFCode property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasISCEDFCode property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasISCEDFCode().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link QualificationType.HasISCEDFCode }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<QualificationType.HasISCEDFCode> getHasISCEDFCode() {
        if (hasISCEDFCode == null) {
            hasISCEDFCode = new ArrayList<QualificationType.HasISCEDFCode>();
        }
        return this.hasISCEDFCode;
    }

    /**
     * Gets the value of the hasEducationSubject property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasEducationSubject property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasEducationSubject().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link QualificationType.HasEducationSubject }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<QualificationType.HasEducationSubject> getHasEducationSubject() {
        if (hasEducationSubject == null) {
            hasEducationSubject = new ArrayList<QualificationType.HasEducationSubject>();
        }
        return this.hasEducationSubject;
    }

    /**
     * Gets the value of the volumeOfLearning property.
     * 
     * @return
     *     possible object is
     *     {@link Duration }
     *     
     */
    @Nullable
    public Duration getVolumeOfLearning() {
        return volumeOfLearning;
    }

    /**
     * Sets the value of the volumeOfLearning property.
     * 
     * @param value
     *     allowed object is
     *     {@link Duration }
     *     
     */
    public void setVolumeOfLearning(
        @Nullable
        Duration value) {
        this.volumeOfLearning = value;
    }

    /**
     * Gets the value of the hasECTSCreditPoints property.
     * 
     * @return
     *     possible object is
     *     {@link ECTSCreditPointsType }
     *     
     */
    @Nullable
    public ECTSCreditPointsType getHasECTSCreditPoints() {
        return hasECTSCreditPoints;
    }

    /**
     * Sets the value of the hasECTSCreditPoints property.
     * 
     * @param value
     *     allowed object is
     *     {@link ECTSCreditPointsType }
     *     
     */
    public void setHasECTSCreditPoints(
        @Nullable
        ECTSCreditPointsType value) {
        this.hasECTSCreditPoints = value;
    }

    /**
     * Gets the value of the hasCreditPoints property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasCreditPoints property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasCreditPoints().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link CreditPointsType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CreditPointsType> getHasCreditPoints() {
        if (hasCreditPoints == null) {
            hasCreditPoints = new ArrayList<CreditPointsType>();
        }
        return this.hasCreditPoints;
    }

    /**
     * Gets the value of the hasEducationLevel property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasEducationLevel property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasEducationLevel().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link QualificationType.HasEducationLevel }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<QualificationType.HasEducationLevel> getHasEducationLevel() {
        if (hasEducationLevel == null) {
            hasEducationLevel = new ArrayList<QualificationType.HasEducationLevel>();
        }
        return this.hasEducationLevel;
    }

    /**
     * Gets the value of the language property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the language property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getLanguage().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link QualificationType.Language }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<QualificationType.Language> getLanguage() {
        if (language == null) {
            language = new ArrayList<QualificationType.Language>();
        }
        return this.language;
    }

    /**
     * Gets the value of the mode property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the mode property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getMode().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link QualificationType.Mode }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<QualificationType.Mode> getMode() {
        if (mode == null) {
            mode = new ArrayList<QualificationType.Mode>();
        }
        return this.mode;
    }

    /**
     * Gets the value of the learningSettingType property.
     * 
     * @return
     *     possible object is
     *     {@link QualificationType.LearningSettingType }
     *     
     */
    @Nullable
    public QualificationType.LearningSettingType getLearningSettingType() {
        return learningSettingType;
    }

    /**
     * Sets the value of the learningSettingType property.
     * 
     * @param value
     *     allowed object is
     *     {@link QualificationType.LearningSettingType }
     *     
     */
    public void setLearningSettingType(
        @Nullable
        QualificationType.LearningSettingType value) {
        this.learningSettingType = value;
    }

    /**
     * Gets the value of the duration property.
     * 
     * @return
     *     possible object is
     *     {@link Duration }
     *     
     */
    @Nullable
    public Duration getDuration() {
        return duration;
    }

    /**
     * Sets the value of the duration property.
     * 
     * @param value
     *     allowed object is
     *     {@link Duration }
     *     
     */
    public void setDuration(
        @Nullable
        Duration value) {
        this.duration = value;
    }

    /**
     * Gets the value of the targetGroup property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the targetGroup property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getTargetGroup().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link QualificationType.TargetGroup }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<QualificationType.TargetGroup> getTargetGroup() {
        if (targetGroup == null) {
            targetGroup = new ArrayList<QualificationType.TargetGroup>();
        }
        return this.targetGroup;
    }

    /**
     * Gets the value of the entryRequirementsNote property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the entryRequirementsNote property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getEntryRequirementsNote().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getEntryRequirementsNote() {
        if (entryRequirementsNote == null) {
            entryRequirementsNote = new ArrayList<NoteType>();
        }
        return this.entryRequirementsNote;
    }

    /**
     * Gets the value of the learningOutcomes property.
     * 
     * @return
     *     possible object is
     *     {@link QualificationType.LearningOutcomes }
     *     
     */
    @Nullable
    public QualificationType.LearningOutcomes getLearningOutcomes() {
        return learningOutcomes;
    }

    /**
     * Sets the value of the learningOutcomes property.
     * 
     * @param value
     *     allowed object is
     *     {@link QualificationType.LearningOutcomes }
     *     
     */
    public void setLearningOutcomes(
        @Nullable
        QualificationType.LearningOutcomes value) {
        this.learningOutcomes = value;
    }

    /**
     * Gets the value of the learningActivitySpecification property.
     * 
     * @return
     *     possible object is
     *     {@link IdReferenceType }
     *     
     */
    @Nullable
    public IdReferenceType getLearningActivitySpecification() {
        return learningActivitySpecification;
    }

    /**
     * Sets the value of the learningActivitySpecification property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdReferenceType }
     *     
     */
    public void setLearningActivitySpecification(
        @Nullable
        IdReferenceType value) {
        this.learningActivitySpecification = value;
    }

    /**
     * Gets the value of the assessmentSpecification property.
     * 
     * @return
     *     possible object is
     *     {@link IdReferenceType }
     *     
     */
    @Nullable
    public IdReferenceType getAssessmentSpecification() {
        return assessmentSpecification;
    }

    /**
     * Sets the value of the assessmentSpecification property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdReferenceType }
     *     
     */
    public void setAssessmentSpecification(
        @Nullable
        IdReferenceType value) {
        this.assessmentSpecification = value;
    }

    /**
     * Gets the value of the entitlementSpecification property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the entitlementSpecification property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getEntitlementSpecification().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdReferenceType> getEntitlementSpecification() {
        if (entitlementSpecification == null) {
            entitlementSpecification = new ArrayList<IdReferenceType>();
        }
        return this.entitlementSpecification;
    }

    /**
     * Gets the value of the awardingOpportunities property.
     * 
     * @return
     *     possible object is
     *     {@link QualificationType.AwardingOpportunities }
     *     
     */
    @Nullable
    public QualificationType.AwardingOpportunities getAwardingOpportunities() {
        return awardingOpportunities;
    }

    /**
     * Sets the value of the awardingOpportunities property.
     * 
     * @param value
     *     allowed object is
     *     {@link QualificationType.AwardingOpportunities }
     *     
     */
    public void setAwardingOpportunities(
        @Nullable
        QualificationType.AwardingOpportunities value) {
        this.awardingOpportunities = value;
    }

    /**
     * Gets the value of the isPartialQualification property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isIsPartialQualification() {
        return isPartialQualification;
    }

    /**
     * Sets the value of the isPartialQualification property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setIsPartialQualification(
        @Nullable
        Boolean value) {
        this.isPartialQualification = value;
    }

    /**
     * Gets the value of the eqfLevel property.
     * 
     * @return
     *     possible object is
     *     {@link QualificationType.EqfLevel }
     *     
     */
    @Nullable
    public QualificationType.EqfLevel getEqfLevel() {
        return eqfLevel;
    }

    /**
     * Sets the value of the eqfLevel property.
     * 
     * @param value
     *     allowed object is
     *     {@link QualificationType.EqfLevel }
     *     
     */
    public void setEqfLevel(
        @Nullable
        QualificationType.EqfLevel value) {
        this.eqfLevel = value;
    }

    /**
     * Gets the value of the nqfLevel property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the nqfLevel property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getNqfLevel().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link QualificationType.NqfLevel }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<QualificationType.NqfLevel> getNqfLevel() {
        if (nqfLevel == null) {
            nqfLevel = new ArrayList<QualificationType.NqfLevel>();
        }
        return this.nqfLevel;
    }

    /**
     * Gets the value of the hasAccreditation property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasAccreditation property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasAccreditation().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdReferenceType> getHasAccreditation() {
        if (hasAccreditation == null) {
            hasAccreditation = new ArrayList<IdReferenceType>();
        }
        return this.hasAccreditation;
    }

    /**
     * Gets the value of the qualificationCode property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the qualificationCode property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getQualificationCode().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link QualificationType.QualificationCode }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<QualificationType.QualificationCode> getQualificationCode() {
        if (qualificationCode == null) {
            qualificationCode = new ArrayList<QualificationType.QualificationCode>();
        }
        return this.qualificationCode;
    }

    /**
     * Gets the value of the hasPart property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasPart property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasPart().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdReferenceType> getHasPart() {
        if (hasPart == null) {
            hasPart = new ArrayList<IdReferenceType>();
        }
        return this.hasPart;
    }

    /**
     * Gets the value of the specializationOf property.
     * 
     * @return
     *     possible object is
     *     {@link IdReferenceType }
     *     
     */
    @Nullable
    public IdReferenceType getSpecializationOf() {
        return specializationOf;
    }

    /**
     * Sets the value of the specializationOf property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdReferenceType }
     *     
     */
    public void setSpecializationOf(
        @Nullable
        IdReferenceType value) {
        this.specializationOf = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(
        @Nullable
        String value) {
        this.id = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final QualificationType rhs = ((QualificationType) o);
        if (!EqualsHelper.equalsCollection(additionalNote, rhs.additionalNote)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(altLabel, rhs.altLabel)) {
            return false;
        }
        if (!EqualsHelper.equals(assessmentSpecification, rhs.assessmentSpecification)) {
            return false;
        }
        if (!EqualsHelper.equals(awardingOpportunities, rhs.awardingOpportunities)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(definition, rhs.definition)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(duration, rhs.duration)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(entitlementSpecification, rhs.entitlementSpecification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(entryRequirementsNote, rhs.entryRequirementsNote)) {
            return false;
        }
        if (!EqualsHelper.equals(eqfLevel, rhs.eqfLevel)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasAccreditation, rhs.hasAccreditation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasCreditPoints, rhs.hasCreditPoints)) {
            return false;
        }
        if (!EqualsHelper.equals(hasECTSCreditPoints, rhs.hasECTSCreditPoints)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasEducationLevel, rhs.hasEducationLevel)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasEducationSubject, rhs.hasEducationSubject)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasISCEDFCode, rhs.hasISCEDFCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasPart, rhs.hasPart)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(homepage, rhs.homepage)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(identifier, rhs.identifier)) {
            return false;
        }
        if (!EqualsHelper.equals(isPartialQualification, rhs.isPartialQualification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(language, rhs.language)) {
            return false;
        }
        if (!EqualsHelper.equals(learningActivitySpecification, rhs.learningActivitySpecification)) {
            return false;
        }
        if (!EqualsHelper.equals(learningOutcomes, rhs.learningOutcomes)) {
            return false;
        }
        if (!EqualsHelper.equals(learningSettingType, rhs.learningSettingType)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(mode, rhs.mode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(nqfLevel, rhs.nqfLevel)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(qualificationCode, rhs.qualificationCode)) {
            return false;
        }
        if (!EqualsHelper.equals(specializationOf, rhs.specializationOf)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(supplementaryDoc, rhs.supplementaryDoc)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(targetGroup, rhs.targetGroup)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(title, rhs.title)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(type, rhs.type)) {
            return false;
        }
        if (!EqualsHelper.equals(volumeOfLearning, rhs.volumeOfLearning)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalNote).append(altLabel).append(assessmentSpecification).append(awardingOpportunities).append(definition).append(description).append(duration).append(entitlementSpecification).append(entryRequirementsNote).append(eqfLevel).append(hasAccreditation).append(hasCreditPoints).append(hasECTSCreditPoints).append(hasEducationLevel).append(hasEducationSubject).append(hasISCEDFCode).append(hasPart).append(homepage).append(id).append(identifier).append(isPartialQualification).append(language).append(learningActivitySpecification).append(learningOutcomes).append(learningSettingType).append(mode).append(nqfLevel).append(qualificationCode).append(specializationOf).append(supplementaryDoc).append(targetGroup).append(title).append(type).append(volumeOfLearning).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalNote", additionalNote).append("altLabel", altLabel).append("assessmentSpecification", assessmentSpecification).append("awardingOpportunities", awardingOpportunities).append("definition", definition).append("description", description).append("duration", duration).append("entitlementSpecification", entitlementSpecification).append("entryRequirementsNote", entryRequirementsNote).append("eqfLevel", eqfLevel).append("hasAccreditation", hasAccreditation).append("hasCreditPoints", hasCreditPoints).append("hasECTSCreditPoints", hasECTSCreditPoints).append("hasEducationLevel", hasEducationLevel).append("hasEducationSubject", hasEducationSubject).append("hasISCEDFCode", hasISCEDFCode).append("hasPart", hasPart).append("homepage", homepage).append("id", id).append("identifier", identifier).append("isPartialQualification", isPartialQualification).append("language", language).append("learningActivitySpecification", learningActivitySpecification).append("learningOutcomes", learningOutcomes).append("learningSettingType", learningSettingType).append("mode", mode).append("nqfLevel", nqfLevel).append("qualificationCode", qualificationCode).append("specializationOf", specializationOf).append("supplementaryDoc", supplementaryDoc).append("targetGroup", targetGroup).append("title", title).append("type", type).append("volumeOfLearning", volumeOfLearning).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setIdentifier(
        @Nullable
        final List<IdentifierType> aList) {
        identifier = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setType(
        @Nullable
        final List<QualificationType.Type> aList) {
        type = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTitle(
        @Nullable
        final List<LanguageStringType> aList) {
        title = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setAltLabel(
        @Nullable
        final List<LanguageStringType> aList) {
        altLabel = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDefinition(
        @Nullable
        final List<NoteType> aList) {
        definition = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDescription(
        @Nullable
        final List<NoteType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setAdditionalNote(
        @Nullable
        final List<NoteType> aList) {
        additionalNote = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHomepage(
        @Nullable
        final List<DocumentType> aList) {
        homepage = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setSupplementaryDoc(
        @Nullable
        final List<DocumentType> aList) {
        supplementaryDoc = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasISCEDFCode(
        @Nullable
        final List<QualificationType.HasISCEDFCode> aList) {
        hasISCEDFCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasEducationSubject(
        @Nullable
        final List<QualificationType.HasEducationSubject> aList) {
        hasEducationSubject = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasCreditPoints(
        @Nullable
        final List<CreditPointsType> aList) {
        hasCreditPoints = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasEducationLevel(
        @Nullable
        final List<QualificationType.HasEducationLevel> aList) {
        hasEducationLevel = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setLanguage(
        @Nullable
        final List<QualificationType.Language> aList) {
        language = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setMode(
        @Nullable
        final List<QualificationType.Mode> aList) {
        mode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTargetGroup(
        @Nullable
        final List<QualificationType.TargetGroup> aList) {
        targetGroup = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setEntryRequirementsNote(
        @Nullable
        final List<NoteType> aList) {
        entryRequirementsNote = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setEntitlementSpecification(
        @Nullable
        final List<IdReferenceType> aList) {
        entitlementSpecification = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setNqfLevel(
        @Nullable
        final List<QualificationType.NqfLevel> aList) {
        nqfLevel = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasAccreditation(
        @Nullable
        final List<IdReferenceType> aList) {
        hasAccreditation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setQualificationCode(
        @Nullable
        final List<QualificationType.QualificationCode> aList) {
        qualificationCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasPart(
        @Nullable
        final List<IdReferenceType> aList) {
        hasPart = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasIdentifierEntries() {
        return (!getIdentifier().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoIdentifierEntries() {
        return getIdentifier().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getIdentifierCount() {
        return getIdentifier().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdentifierType getIdentifierAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIdentifier().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addIdentifier(
        @Nonnull
        final IdentifierType elem) {
        getIdentifier().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTypeEntries() {
        return (!getType().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTypeEntries() {
        return getType().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTypeCount() {
        return getType().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public QualificationType.Type getTypeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getType().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addType(
        @Nonnull
        final QualificationType.Type elem) {
        getType().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTitleEntries() {
        return (!getTitle().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTitleEntries() {
        return getTitle().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTitleCount() {
        return getTitle().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LanguageStringType getTitleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTitle().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addTitle(
        @Nonnull
        final LanguageStringType elem) {
        getTitle().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasAltLabelEntries() {
        return (!getAltLabel().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoAltLabelEntries() {
        return getAltLabel().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getAltLabelCount() {
        return getAltLabel().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LanguageStringType getAltLabelAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAltLabel().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addAltLabel(
        @Nonnull
        final LanguageStringType elem) {
        getAltLabel().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasDefinitionEntries() {
        return (!getDefinition().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoDefinitionEntries() {
        return getDefinition().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getDefinitionCount() {
        return getDefinition().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getDefinitionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDefinition().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addDefinition(
        @Nonnull
        final NoteType elem) {
        getDefinition().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addDescription(
        @Nonnull
        final NoteType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasAdditionalNoteEntries() {
        return (!getAdditionalNote().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoAdditionalNoteEntries() {
        return getAdditionalNote().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getAdditionalNoteCount() {
        return getAdditionalNote().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getAdditionalNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalNote().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addAdditionalNote(
        @Nonnull
        final NoteType elem) {
        getAdditionalNote().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHomepageEntries() {
        return (!getHomepage().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHomepageEntries() {
        return getHomepage().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHomepageCount() {
        return getHomepage().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentType getHomepageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHomepage().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHomepage(
        @Nonnull
        final DocumentType elem) {
        getHomepage().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasSupplementaryDocEntries() {
        return (!getSupplementaryDoc().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoSupplementaryDocEntries() {
        return getSupplementaryDoc().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getSupplementaryDocCount() {
        return getSupplementaryDoc().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentType getSupplementaryDocAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSupplementaryDoc().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addSupplementaryDoc(
        @Nonnull
        final DocumentType elem) {
        getSupplementaryDoc().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasISCEDFCodeEntries() {
        return (!getHasISCEDFCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasISCEDFCodeEntries() {
        return getHasISCEDFCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasISCEDFCodeCount() {
        return getHasISCEDFCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public QualificationType.HasISCEDFCode getHasISCEDFCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasISCEDFCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasISCEDFCode(
        @Nonnull
        final QualificationType.HasISCEDFCode elem) {
        getHasISCEDFCode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasEducationSubjectEntries() {
        return (!getHasEducationSubject().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasEducationSubjectEntries() {
        return getHasEducationSubject().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasEducationSubjectCount() {
        return getHasEducationSubject().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public QualificationType.HasEducationSubject getHasEducationSubjectAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasEducationSubject().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasEducationSubject(
        @Nonnull
        final QualificationType.HasEducationSubject elem) {
        getHasEducationSubject().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasCreditPointsEntries() {
        return (!getHasCreditPoints().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasCreditPointsEntries() {
        return getHasCreditPoints().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasCreditPointsCount() {
        return getHasCreditPoints().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CreditPointsType getHasCreditPointsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasCreditPoints().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasCreditPoints(
        @Nonnull
        final CreditPointsType elem) {
        getHasCreditPoints().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasEducationLevelEntries() {
        return (!getHasEducationLevel().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasEducationLevelEntries() {
        return getHasEducationLevel().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasEducationLevelCount() {
        return getHasEducationLevel().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public QualificationType.HasEducationLevel getHasEducationLevelAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasEducationLevel().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasEducationLevel(
        @Nonnull
        final QualificationType.HasEducationLevel elem) {
        getHasEducationLevel().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasLanguageEntries() {
        return (!getLanguage().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoLanguageEntries() {
        return getLanguage().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getLanguageCount() {
        return getLanguage().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public QualificationType.Language getLanguageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLanguage().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addLanguage(
        @Nonnull
        final QualificationType.Language elem) {
        getLanguage().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasModeEntries() {
        return (!getMode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoModeEntries() {
        return getMode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getModeCount() {
        return getMode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public QualificationType.Mode getModeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addMode(
        @Nonnull
        final QualificationType.Mode elem) {
        getMode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTargetGroupEntries() {
        return (!getTargetGroup().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTargetGroupEntries() {
        return getTargetGroup().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTargetGroupCount() {
        return getTargetGroup().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public QualificationType.TargetGroup getTargetGroupAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTargetGroup().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addTargetGroup(
        @Nonnull
        final QualificationType.TargetGroup elem) {
        getTargetGroup().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasEntryRequirementsNoteEntries() {
        return (!getEntryRequirementsNote().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoEntryRequirementsNoteEntries() {
        return getEntryRequirementsNote().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getEntryRequirementsNoteCount() {
        return getEntryRequirementsNote().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getEntryRequirementsNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEntryRequirementsNote().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addEntryRequirementsNote(
        @Nonnull
        final NoteType elem) {
        getEntryRequirementsNote().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasEntitlementSpecificationEntries() {
        return (!getEntitlementSpecification().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoEntitlementSpecificationEntries() {
        return getEntitlementSpecification().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getEntitlementSpecificationCount() {
        return getEntitlementSpecification().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdReferenceType getEntitlementSpecificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEntitlementSpecification().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addEntitlementSpecification(
        @Nonnull
        final IdReferenceType elem) {
        getEntitlementSpecification().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNqfLevelEntries() {
        return (!getNqfLevel().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoNqfLevelEntries() {
        return getNqfLevel().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getNqfLevelCount() {
        return getNqfLevel().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public QualificationType.NqfLevel getNqfLevelAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNqfLevel().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addNqfLevel(
        @Nonnull
        final QualificationType.NqfLevel elem) {
        getNqfLevel().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasAccreditationEntries() {
        return (!getHasAccreditation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasAccreditationEntries() {
        return getHasAccreditation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasAccreditationCount() {
        return getHasAccreditation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdReferenceType getHasAccreditationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasAccreditation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasAccreditation(
        @Nonnull
        final IdReferenceType elem) {
        getHasAccreditation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasQualificationCodeEntries() {
        return (!getQualificationCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoQualificationCodeEntries() {
        return getQualificationCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getQualificationCodeCount() {
        return getQualificationCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public QualificationType.QualificationCode getQualificationCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getQualificationCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addQualificationCode(
        @Nonnull
        final QualificationType.QualificationCode elem) {
        getQualificationCode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasPartEntries() {
        return (!getHasPart().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasPartEntries() {
        return getHasPart().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasPartCount() {
        return getHasPart().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdReferenceType getHasPartAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasPart().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasPart(
        @Nonnull
        final IdReferenceType elem) {
        getHasPart().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        QualificationType ret) {
        if (additionalNote == null) {
            ret.additionalNote = null;
        } else {
            List<NoteType> retAdditionalNote = new ArrayList<NoteType>();
            for (NoteType aItem: getAdditionalNote()) {
                retAdditionalNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalNote = retAdditionalNote;
        }
        if (altLabel == null) {
            ret.altLabel = null;
        } else {
            List<LanguageStringType> retAltLabel = new ArrayList<LanguageStringType>();
            for (LanguageStringType aItem: getAltLabel()) {
                retAltLabel.add(((aItem == null)?null:aItem.clone()));
            }
            ret.altLabel = retAltLabel;
        }
        ret.assessmentSpecification = ((assessmentSpecification == null)?null:assessmentSpecification.clone());
        ret.awardingOpportunities = ((awardingOpportunities == null)?null:awardingOpportunities.clone());
        if (definition == null) {
            ret.definition = null;
        } else {
            List<NoteType> retDefinition = new ArrayList<NoteType>();
            for (NoteType aItem: getDefinition()) {
                retDefinition.add(((aItem == null)?null:aItem.clone()));
            }
            ret.definition = retDefinition;
        }
        if (description == null) {
            ret.description = null;
        } else {
            List<NoteType> retDescription = new ArrayList<NoteType>();
            for (NoteType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.duration = duration;
        if (entitlementSpecification == null) {
            ret.entitlementSpecification = null;
        } else {
            List<IdReferenceType> retEntitlementSpecification = new ArrayList<IdReferenceType>();
            for (IdReferenceType aItem: getEntitlementSpecification()) {
                retEntitlementSpecification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.entitlementSpecification = retEntitlementSpecification;
        }
        if (entryRequirementsNote == null) {
            ret.entryRequirementsNote = null;
        } else {
            List<NoteType> retEntryRequirementsNote = new ArrayList<NoteType>();
            for (NoteType aItem: getEntryRequirementsNote()) {
                retEntryRequirementsNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.entryRequirementsNote = retEntryRequirementsNote;
        }
        ret.eqfLevel = ((eqfLevel == null)?null:eqfLevel.clone());
        if (hasAccreditation == null) {
            ret.hasAccreditation = null;
        } else {
            List<IdReferenceType> retHasAccreditation = new ArrayList<IdReferenceType>();
            for (IdReferenceType aItem: getHasAccreditation()) {
                retHasAccreditation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasAccreditation = retHasAccreditation;
        }
        if (hasCreditPoints == null) {
            ret.hasCreditPoints = null;
        } else {
            List<CreditPointsType> retHasCreditPoints = new ArrayList<CreditPointsType>();
            for (CreditPointsType aItem: getHasCreditPoints()) {
                retHasCreditPoints.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasCreditPoints = retHasCreditPoints;
        }
        ret.hasECTSCreditPoints = ((hasECTSCreditPoints == null)?null:hasECTSCreditPoints.clone());
        if (hasEducationLevel == null) {
            ret.hasEducationLevel = null;
        } else {
            List<QualificationType.HasEducationLevel> retHasEducationLevel = new ArrayList<QualificationType.HasEducationLevel>();
            for (QualificationType.HasEducationLevel aItem: getHasEducationLevel()) {
                retHasEducationLevel.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasEducationLevel = retHasEducationLevel;
        }
        if (hasEducationSubject == null) {
            ret.hasEducationSubject = null;
        } else {
            List<QualificationType.HasEducationSubject> retHasEducationSubject = new ArrayList<QualificationType.HasEducationSubject>();
            for (QualificationType.HasEducationSubject aItem: getHasEducationSubject()) {
                retHasEducationSubject.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasEducationSubject = retHasEducationSubject;
        }
        if (hasISCEDFCode == null) {
            ret.hasISCEDFCode = null;
        } else {
            List<QualificationType.HasISCEDFCode> retHasISCEDFCode = new ArrayList<QualificationType.HasISCEDFCode>();
            for (QualificationType.HasISCEDFCode aItem: getHasISCEDFCode()) {
                retHasISCEDFCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasISCEDFCode = retHasISCEDFCode;
        }
        if (hasPart == null) {
            ret.hasPart = null;
        } else {
            List<IdReferenceType> retHasPart = new ArrayList<IdReferenceType>();
            for (IdReferenceType aItem: getHasPart()) {
                retHasPart.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasPart = retHasPart;
        }
        if (homepage == null) {
            ret.homepage = null;
        } else {
            List<DocumentType> retHomepage = new ArrayList<DocumentType>();
            for (DocumentType aItem: getHomepage()) {
                retHomepage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.homepage = retHomepage;
        }
        ret.id = id;
        if (identifier == null) {
            ret.identifier = null;
        } else {
            List<IdentifierType> retIdentifier = new ArrayList<IdentifierType>();
            for (IdentifierType aItem: getIdentifier()) {
                retIdentifier.add(((aItem == null)?null:aItem.clone()));
            }
            ret.identifier = retIdentifier;
        }
        ret.isPartialQualification = isPartialQualification;
        if (language == null) {
            ret.language = null;
        } else {
            List<QualificationType.Language> retLanguage = new ArrayList<QualificationType.Language>();
            for (QualificationType.Language aItem: getLanguage()) {
                retLanguage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.language = retLanguage;
        }
        ret.learningActivitySpecification = ((learningActivitySpecification == null)?null:learningActivitySpecification.clone());
        ret.learningOutcomes = ((learningOutcomes == null)?null:learningOutcomes.clone());
        ret.learningSettingType = ((learningSettingType == null)?null:learningSettingType.clone());
        if (mode == null) {
            ret.mode = null;
        } else {
            List<QualificationType.Mode> retMode = new ArrayList<QualificationType.Mode>();
            for (QualificationType.Mode aItem: getMode()) {
                retMode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.mode = retMode;
        }
        if (nqfLevel == null) {
            ret.nqfLevel = null;
        } else {
            List<QualificationType.NqfLevel> retNqfLevel = new ArrayList<QualificationType.NqfLevel>();
            for (QualificationType.NqfLevel aItem: getNqfLevel()) {
                retNqfLevel.add(((aItem == null)?null:aItem.clone()));
            }
            ret.nqfLevel = retNqfLevel;
        }
        if (qualificationCode == null) {
            ret.qualificationCode = null;
        } else {
            List<QualificationType.QualificationCode> retQualificationCode = new ArrayList<QualificationType.QualificationCode>();
            for (QualificationType.QualificationCode aItem: getQualificationCode()) {
                retQualificationCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.qualificationCode = retQualificationCode;
        }
        ret.specializationOf = ((specializationOf == null)?null:specializationOf.clone());
        if (supplementaryDoc == null) {
            ret.supplementaryDoc = null;
        } else {
            List<DocumentType> retSupplementaryDoc = new ArrayList<DocumentType>();
            for (DocumentType aItem: getSupplementaryDoc()) {
                retSupplementaryDoc.add(((aItem == null)?null:aItem.clone()));
            }
            ret.supplementaryDoc = retSupplementaryDoc;
        }
        if (targetGroup == null) {
            ret.targetGroup = null;
        } else {
            List<QualificationType.TargetGroup> retTargetGroup = new ArrayList<QualificationType.TargetGroup>();
            for (QualificationType.TargetGroup aItem: getTargetGroup()) {
                retTargetGroup.add(((aItem == null)?null:aItem.clone()));
            }
            ret.targetGroup = retTargetGroup;
        }
        if (title == null) {
            ret.title = null;
        } else {
            List<LanguageStringType> retTitle = new ArrayList<LanguageStringType>();
            for (LanguageStringType aItem: getTitle()) {
                retTitle.add(((aItem == null)?null:aItem.clone()));
            }
            ret.title = retTitle;
        }
        if (type == null) {
            ret.type = null;
        } else {
            List<QualificationType.Type> retType = new ArrayList<QualificationType.Type>();
            for (QualificationType.Type aItem: getType()) {
                retType.add(((aItem == null)?null:aItem.clone()));
            }
            ret.type = retType;
        }
        ret.volumeOfLearning = volumeOfLearning;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public QualificationType clone() {
        QualificationType ret = new QualificationType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type ECTSCreditPointsType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public ECTSCreditPointsType setHasECTSCreditPoints(
        @Nullable
        final BigDecimal valueParam) {
        ECTSCreditPointsType aObj = getHasECTSCreditPoints();
        if (aObj == null) {
            aObj = new ECTSCreditPointsType(valueParam);
            setHasECTSCreditPoints(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained ECTSCreditPointsType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ECTSCreditPointsType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getHasECTSCreditPointsValue() {
        ECTSCreditPointsType aObj = getHasECTSCreditPoints();
        return (aObj == null)?null:aObj.getValue();
    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="awardingOpportunity" type="{http://data.europa.eu/europass/model/credentials#}AwardingOpportunityType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "awardingOpportunity"
    })
    @CodingStyleguideUnaware
    public static class AwardingOpportunities implements IExplicitlyCloneable
    {

        private List<AwardingOpportunityType> awardingOpportunity;

        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public AwardingOpportunities() {
        }

        /**
         * Gets the value of the awardingOpportunity property.
         * 
         * &lt;p&gt;
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the awardingOpportunity property.
         * 
         * &lt;p&gt;
         * For example, to add a new item, do as follows:
         * &lt;pre&gt;
         *    getAwardingOpportunity().add(newItem);
         * &lt;/pre&gt;
         * 
         * 
         * &lt;p&gt;
         * Objects of the following type(s) are allowed in the list
         * {@link AwardingOpportunityType }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<AwardingOpportunityType> getAwardingOpportunity() {
            if (awardingOpportunity == null) {
                awardingOpportunity = new ArrayList<AwardingOpportunityType>();
            }
            return this.awardingOpportunity;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final QualificationType.AwardingOpportunities rhs = ((QualificationType.AwardingOpportunities) o);
            if (!EqualsHelper.equalsCollection(awardingOpportunity, rhs.awardingOpportunity)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(awardingOpportunity).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("awardingOpportunity", awardingOpportunity).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
         */
        public void setAwardingOpportunity(
            @Nullable
            final List<AwardingOpportunityType> aList) {
            awardingOpportunity = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
         */
        public boolean hasAwardingOpportunityEntries() {
            return (!getAwardingOpportunity().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
         */
        public boolean hasNoAwardingOpportunityEntries() {
            return getAwardingOpportunity().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &amp;ge; 0.
         */
        @Nonnegative
        public int getAwardingOpportunityCount() {
            return getAwardingOpportunity().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public AwardingOpportunityType getAwardingOpportunityAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getAwardingOpportunity().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void addAwardingOpportunity(
            @Nonnull
            final AwardingOpportunityType elem) {
            getAwardingOpportunity().add(elem);
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.AwardingOpportunities ret) {
            if (awardingOpportunity == null) {
                ret.awardingOpportunity = null;
            } else {
                List<AwardingOpportunityType> retAwardingOpportunity = new ArrayList<AwardingOpportunityType>();
                for (AwardingOpportunityType aItem: getAwardingOpportunity()) {
                    retAwardingOpportunity.add(((aItem == null)?null:aItem.clone()));
                }
                ret.awardingOpportunity = retAwardingOpportunity;
            }
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.AwardingOpportunities clone() {
            QualificationType.AwardingOpportunities ret = new QualificationType.AwardingOpportunities();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}EQFLevelEnumType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class EqfLevel
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public EqfLevel() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.EqfLevel ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.EqfLevel clone() {
            QualificationType.EqfLevel ret = new QualificationType.EqfLevel();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class HasEducationLevel
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public HasEducationLevel() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.HasEducationLevel ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.HasEducationLevel clone() {
            QualificationType.HasEducationLevel ret = new QualificationType.HasEducationLevel();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class HasEducationSubject
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public HasEducationSubject() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.HasEducationSubject ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.HasEducationSubject clone() {
            QualificationType.HasEducationSubject ret = new QualificationType.HasEducationSubject();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}IscedFOetCodeEnumType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class HasISCEDFCode
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public HasISCEDFCode() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.HasISCEDFCode ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.HasISCEDFCode clone() {
            QualificationType.HasISCEDFCode ret = new QualificationType.HasISCEDFCode();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}LanguageEnumType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class Language
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public Language() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.Language ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.Language clone() {
            QualificationType.Language ret = new QualificationType.Language();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="learningOutcome" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "learningOutcome"
    })
    @CodingStyleguideUnaware
    public static class LearningOutcomes implements IExplicitlyCloneable
    {

        private List<IdReferenceType> learningOutcome;

        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public LearningOutcomes() {
        }

        /**
         * Gets the value of the learningOutcome property.
         * 
         * &lt;p&gt;
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the learningOutcome property.
         * 
         * &lt;p&gt;
         * For example, to add a new item, do as follows:
         * &lt;pre&gt;
         *    getLearningOutcome().add(newItem);
         * &lt;/pre&gt;
         * 
         * 
         * &lt;p&gt;
         * Objects of the following type(s) are allowed in the list
         * {@link IdReferenceType }
         * 
         * 
         */
        @Nonnull
        @ReturnsMutableObject("JAXB implementation style")
        public List<IdReferenceType> getLearningOutcome() {
            if (learningOutcome == null) {
                learningOutcome = new ArrayList<IdReferenceType>();
            }
            return this.learningOutcome;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final QualificationType.LearningOutcomes rhs = ((QualificationType.LearningOutcomes) o);
            if (!EqualsHelper.equalsCollection(learningOutcome, rhs.learningOutcome)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(learningOutcome).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("learningOutcome", learningOutcome).getToString();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param aList
         *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
         */
        public void setLearningOutcome(
            @Nullable
            final List<IdReferenceType> aList) {
            learningOutcome = aList;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
         */
        public boolean hasLearningOutcomeEntries() {
            return (!getLearningOutcome().isEmpty());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
         */
        public boolean hasNoLearningOutcomeEntries() {
            return getLearningOutcome().isEmpty();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @return
         *     The number of contained elements. Always &amp;ge; 0.
         */
        @Nonnegative
        public int getLearningOutcomeCount() {
            return getLearningOutcome().size();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param index
         *     The index to retrieve
         * @return
         *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
         * @throws IndexOutOfBoundsException
         *     if the index is invalid!
         */
        @Nullable
        public IdReferenceType getLearningOutcomeAtIndex(
            @Nonnegative
            final int index)
            throws IndexOutOfBoundsException
        {
            return getLearningOutcome().get(index);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-list-extension
         * 
         * @param elem
         *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void addLearningOutcome(
            @Nonnull
            final IdReferenceType elem) {
            getLearningOutcome().add(elem);
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.LearningOutcomes ret) {
            if (learningOutcome == null) {
                ret.learningOutcome = null;
            } else {
                List<IdReferenceType> retLearningOutcome = new ArrayList<IdReferenceType>();
                for (IdReferenceType aItem: getLearningOutcome()) {
                    retLearningOutcome.add(((aItem == null)?null:aItem.clone()));
                }
                ret.learningOutcome = retLearningOutcome;
            }
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.LearningOutcomes clone() {
            QualificationType.LearningOutcomes ret = new QualificationType.LearningOutcomes();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}LearningSettingTypeEnumType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class LearningSettingType
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public LearningSettingType() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.LearningSettingType ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.LearningSettingType clone() {
            QualificationType.LearningSettingType ret = new QualificationType.LearningSettingType();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}LearningModeTypeEnumType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class Mode
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public Mode() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.Mode ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.Mode clone() {
            QualificationType.Mode ret = new QualificationType.Mode();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}QualificationFrameworkEnumType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class NqfLevel
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public NqfLevel() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.NqfLevel ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.NqfLevel clone() {
            QualificationType.NqfLevel ret = new QualificationType.NqfLevel();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class QualificationCode
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public QualificationCode() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.QualificationCode ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.QualificationCode clone() {
            QualificationType.QualificationCode ret = new QualificationType.QualificationCode();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}TargetGroupCodeEnumType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class TargetGroup
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public TargetGroup() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.TargetGroup ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.TargetGroup clone() {
            QualificationType.TargetGroup ret = new QualificationType.TargetGroup();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}LearningOpportunityTypeEnumType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class Type
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public Type() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            QualificationType.Type ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public QualificationType.Type clone() {
            QualificationType.Type ret = new QualificationType.Type();
            cloneTo(ret);
            return ret;
        }

    }

}
