
package eu.europa.data.europass.model.credentials_;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;


/**
 * An awarded qualification. A formal outcome of an assessment and validation process which is obtained when a competent authority determines that an individual has achieved learning outcomes to given standards. The QualificationAwardType is a more specialized type of the LearningAwardType.
 * 
 * &lt;p&gt;Java class for QualificationAwardType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="QualificationAwardType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;extension base="{http://data.europa.eu/europass/model/credentials#}AchievementType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="specifiedBy" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType"/&amp;gt;
 *         &amp;lt;element name="associatedLearningOpportunity" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/extension&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "QualificationAwardType", propOrder = {
    "specifiedBy",
    "associatedLearningOpportunity"
})
@CodingStyleguideUnaware
public class QualificationAwardType
    extends AchievementType
{

    @XmlElement(required = true)
    private IdReferenceType specifiedBy;
    private IdReferenceType associatedLearningOpportunity;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public QualificationAwardType() {
    }

    /**
     * Gets the value of the specifiedBy property.
     * 
     * @return
     *     possible object is
     *     {@link IdReferenceType }
     *     
     */
    @Nullable
    public IdReferenceType getSpecifiedBy() {
        return specifiedBy;
    }

    /**
     * Sets the value of the specifiedBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdReferenceType }
     *     
     */
    public void setSpecifiedBy(
        @Nullable
        IdReferenceType value) {
        this.specifiedBy = value;
    }

    /**
     * Gets the value of the associatedLearningOpportunity property.
     * 
     * @return
     *     possible object is
     *     {@link IdReferenceType }
     *     
     */
    @Nullable
    public IdReferenceType getAssociatedLearningOpportunity() {
        return associatedLearningOpportunity;
    }

    /**
     * Sets the value of the associatedLearningOpportunity property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdReferenceType }
     *     
     */
    public void setAssociatedLearningOpportunity(
        @Nullable
        IdReferenceType value) {
        this.associatedLearningOpportunity = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final QualificationAwardType rhs = ((QualificationAwardType) o);
        if (!EqualsHelper.equals(associatedLearningOpportunity, rhs.associatedLearningOpportunity)) {
            return false;
        }
        if (!EqualsHelper.equals(specifiedBy, rhs.specifiedBy)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(associatedLearningOpportunity).append(specifiedBy).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("associatedLearningOpportunity", associatedLearningOpportunity).append("specifiedBy", specifiedBy).getToString();
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        QualificationAwardType ret) {
        super.cloneTo(ret);
        ret.associatedLearningOpportunity = ((associatedLearningOpportunity == null)?null:associatedLearningOpportunity.clone());
        ret.specifiedBy = ((specifiedBy == null)?null:specifiedBy.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public QualificationAwardType clone() {
        QualificationAwardType ret = new QualificationAwardType();
        cloneTo(ret);
        return ret;
    }

}
