
package eu.europa.data.europass.model.credentials_;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;


/**
 * &lt;p&gt;Java class for PersonType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="PersonType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;extension base="{http://data.europa.eu/europass/model/credentials#}AgentType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="nationalId" type="{http://data.europa.eu/europass/model/credentials#}LegalIdentifierType"/&amp;gt;
 *         &amp;lt;element name="identifier" type="{http://data.europa.eu/europass/model/credentials#}IdentifierType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="fullName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="givenNames" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType"/&amp;gt;
 *         &amp;lt;element name="familyName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType"/&amp;gt;
 *         &amp;lt;element name="dateOfBirth" type="{http://www.w3.org/2001/XMLSchema}date"/&amp;gt;
 *         &amp;lt;element name="placeOfBirth" type="{http://data.europa.eu/europass/model/credentials#}LocationType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="gender" type="{http://data.europa.eu/europass/model/credentials#}PersonGenderCodeType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="citizenshipCountry" type="{http://data.europa.eu/europass/model/credentials#}PersonCountryCodeType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/extension&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PersonType", propOrder = {
    "nationalId",
    "personIdentifier",
    "fullName",
    "givenNames",
    "familyName",
    "dateOfBirth",
    "placeOfBirth",
    "gender",
    "citizenshipCountry"
})
@XmlSeeAlso({
    CredentialSubjectType.class
})
@CodingStyleguideUnaware
public class PersonType
    extends AgentType
{

    @XmlElement(required = true)
    private LegalIdentifierType nationalId;
    @XmlElement(name = "identifier")
    private List<IdentifierType> personIdentifier;
    private LanguageStringType fullName;
    @XmlElement(required = true)
    private LanguageStringType givenNames;
    @XmlElement(required = true)
    private LanguageStringType familyName;
    @XmlElement(required = true)
    @XmlSchemaType(name = "date")
    private XMLGregorianCalendar dateOfBirth;
    private LocationType placeOfBirth;
    private PersonGenderCodeType gender;
    private List<PersonCountryCodeType> citizenshipCountry;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public PersonType() {
    }

    /**
     * Gets the value of the nationalId property.
     * 
     * @return
     *     possible object is
     *     {@link LegalIdentifierType }
     *     
     */
    @Nullable
    public LegalIdentifierType getNationalId() {
        return nationalId;
    }

    /**
     * Sets the value of the nationalId property.
     * 
     * @param value
     *     allowed object is
     *     {@link LegalIdentifierType }
     *     
     */
    public void setNationalId(
        @Nullable
        LegalIdentifierType value) {
        this.nationalId = value;
    }

    /**
     * Gets the value of the personIdentifier property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the personIdentifier property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getPersonIdentifier().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdentifierType> getPersonIdentifier() {
        if (personIdentifier == null) {
            personIdentifier = new ArrayList<IdentifierType>();
        }
        return this.personIdentifier;
    }

    /**
     * Gets the value of the fullName property.
     * 
     * @return
     *     possible object is
     *     {@link LanguageStringType }
     *     
     */
    @Nullable
    public LanguageStringType getFullName() {
        return fullName;
    }

    /**
     * Sets the value of the fullName property.
     * 
     * @param value
     *     allowed object is
     *     {@link LanguageStringType }
     *     
     */
    public void setFullName(
        @Nullable
        LanguageStringType value) {
        this.fullName = value;
    }

    /**
     * Gets the value of the givenNames property.
     * 
     * @return
     *     possible object is
     *     {@link LanguageStringType }
     *     
     */
    @Nullable
    public LanguageStringType getGivenNames() {
        return givenNames;
    }

    /**
     * Sets the value of the givenNames property.
     * 
     * @param value
     *     allowed object is
     *     {@link LanguageStringType }
     *     
     */
    public void setGivenNames(
        @Nullable
        LanguageStringType value) {
        this.givenNames = value;
    }

    /**
     * Gets the value of the familyName property.
     * 
     * @return
     *     possible object is
     *     {@link LanguageStringType }
     *     
     */
    @Nullable
    public LanguageStringType getFamilyName() {
        return familyName;
    }

    /**
     * Sets the value of the familyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link LanguageStringType }
     *     
     */
    public void setFamilyName(
        @Nullable
        LanguageStringType value) {
        this.familyName = value;
    }

    /**
     * Gets the value of the dateOfBirth property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getDateOfBirth() {
        return dateOfBirth;
    }

    /**
     * Sets the value of the dateOfBirth property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setDateOfBirth(
        @Nullable
        XMLGregorianCalendar value) {
        this.dateOfBirth = value;
    }

    /**
     * Gets the value of the placeOfBirth property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getPlaceOfBirth() {
        return placeOfBirth;
    }

    /**
     * Sets the value of the placeOfBirth property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setPlaceOfBirth(
        @Nullable
        LocationType value) {
        this.placeOfBirth = value;
    }

    /**
     * Gets the value of the gender property.
     * 
     * @return
     *     possible object is
     *     {@link PersonGenderCodeType }
     *     
     */
    @Nullable
    public PersonGenderCodeType getGender() {
        return gender;
    }

    /**
     * Sets the value of the gender property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonGenderCodeType }
     *     
     */
    public void setGender(
        @Nullable
        PersonGenderCodeType value) {
        this.gender = value;
    }

    /**
     * Gets the value of the citizenshipCountry property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the citizenshipCountry property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getCitizenshipCountry().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link PersonCountryCodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonCountryCodeType> getCitizenshipCountry() {
        if (citizenshipCountry == null) {
            citizenshipCountry = new ArrayList<PersonCountryCodeType>();
        }
        return this.citizenshipCountry;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final PersonType rhs = ((PersonType) o);
        if (!EqualsHelper.equalsCollection(citizenshipCountry, rhs.citizenshipCountry)) {
            return false;
        }
        if (!EqualsHelper.equals(dateOfBirth, rhs.dateOfBirth)) {
            return false;
        }
        if (!EqualsHelper.equals(familyName, rhs.familyName)) {
            return false;
        }
        if (!EqualsHelper.equals(fullName, rhs.fullName)) {
            return false;
        }
        if (!EqualsHelper.equals(gender, rhs.gender)) {
            return false;
        }
        if (!EqualsHelper.equals(givenNames, rhs.givenNames)) {
            return false;
        }
        if (!EqualsHelper.equals(nationalId, rhs.nationalId)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personIdentifier, rhs.personIdentifier)) {
            return false;
        }
        if (!EqualsHelper.equals(placeOfBirth, rhs.placeOfBirth)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(citizenshipCountry).append(dateOfBirth).append(familyName).append(fullName).append(gender).append(givenNames).append(nationalId).append(personIdentifier).append(placeOfBirth).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("citizenshipCountry", citizenshipCountry).append("dateOfBirth", dateOfBirth).append("familyName", familyName).append("fullName", fullName).append("gender", gender).append("givenNames", givenNames).append("nationalId", nationalId).append("personIdentifier", personIdentifier).append("placeOfBirth", placeOfBirth).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setPersonIdentifier(
        @Nullable
        final List<IdentifierType> aList) {
        personIdentifier = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setCitizenshipCountry(
        @Nullable
        final List<PersonCountryCodeType> aList) {
        citizenshipCountry = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasPersonIdentifierEntries() {
        return (!getPersonIdentifier().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoPersonIdentifierEntries() {
        return getPersonIdentifier().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getPersonIdentifierCount() {
        return getPersonIdentifier().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdentifierType getPersonIdentifierAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonIdentifier().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addPersonIdentifier(
        @Nonnull
        final IdentifierType elem) {
        getPersonIdentifier().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasCitizenshipCountryEntries() {
        return (!getCitizenshipCountry().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoCitizenshipCountryEntries() {
        return getCitizenshipCountry().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getCitizenshipCountryCount() {
        return getCitizenshipCountry().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonCountryCodeType getCitizenshipCountryAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCitizenshipCountry().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addCitizenshipCountry(
        @Nonnull
        final PersonCountryCodeType elem) {
        getCitizenshipCountry().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        PersonType ret) {
        super.cloneTo(ret);
        if (citizenshipCountry == null) {
            ret.citizenshipCountry = null;
        } else {
            List<PersonCountryCodeType> retCitizenshipCountry = new ArrayList<PersonCountryCodeType>();
            for (PersonCountryCodeType aItem: getCitizenshipCountry()) {
                retCitizenshipCountry.add(((aItem == null)?null:aItem.clone()));
            }
            ret.citizenshipCountry = retCitizenshipCountry;
        }
        ret.dateOfBirth = ((dateOfBirth == null)?null:((XMLGregorianCalendar) dateOfBirth.clone()));
        ret.familyName = ((familyName == null)?null:familyName.clone());
        ret.fullName = ((fullName == null)?null:fullName.clone());
        ret.gender = ((gender == null)?null:gender.clone());
        ret.givenNames = ((givenNames == null)?null:givenNames.clone());
        ret.nationalId = ((nationalId == null)?null:nationalId.clone());
        if (personIdentifier == null) {
            ret.personIdentifier = null;
        } else {
            List<IdentifierType> retPersonIdentifier = new ArrayList<IdentifierType>();
            for (IdentifierType aItem: getPersonIdentifier()) {
                retPersonIdentifier.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personIdentifier = retPersonIdentifier;
        }
        ret.placeOfBirth = ((placeOfBirth == null)?null:placeOfBirth.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PersonType clone() {
        PersonType ret = new PersonType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type LegalIdentifierType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public LegalIdentifierType setNationalId(
        @Nullable
        final String valueParam) {
        LegalIdentifierType aObj = getNationalId();
        if (aObj == null) {
            aObj = new LegalIdentifierType(valueParam);
            setNationalId(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained LegalIdentifierType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LegalIdentifierType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getNationalIdValue() {
        LegalIdentifierType aObj = getNationalId();
        return (aObj == null)?null:aObj.getValue();
    }

}
