
package eu.europa.data.europass.model.credentials_;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * A formatted and annotated text fragment.
 * 
 * &lt;p&gt;Java class for NoteType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="NoteType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="text" type="{http://data.europa.eu/europass/model/credentials#}TextType"/&amp;gt;
 *         &amp;lt;element name="subject" maxOccurs="unbounded" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;simpleContent&amp;gt;
 *               &amp;lt;extension base="&amp;lt;http://www.w3.org/2001/XMLSchema&amp;gt;string"&amp;gt;
 *                 &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}SubjectTypeCodeEnumType" /&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/simpleContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "NoteType", propOrder = {
    "text",
    "subject"
})
@CodingStyleguideUnaware
public class NoteType implements IExplicitlyCloneable
{

    @XmlElement(required = true)
    private TextType text;
    private List<NoteType.Subject> subject;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public NoteType() {
    }

    /**
     * Gets the value of the text property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getText() {
        return text;
    }

    /**
     * Sets the value of the text property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setText(
        @Nullable
        TextType value) {
        this.text = value;
    }

    /**
     * Gets the value of the subject property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the subject property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getSubject().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType.Subject }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType.Subject> getSubject() {
        if (subject == null) {
            subject = new ArrayList<NoteType.Subject>();
        }
        return this.subject;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final NoteType rhs = ((NoteType) o);
        if (!EqualsHelper.equalsCollection(subject, rhs.subject)) {
            return false;
        }
        if (!EqualsHelper.equals(text, rhs.text)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(subject).append(text).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("subject", subject).append("text", text).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setSubject(
        @Nullable
        final List<NoteType.Subject> aList) {
        subject = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasSubjectEntries() {
        return (!getSubject().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoSubjectEntries() {
        return getSubject().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getSubjectCount() {
        return getSubject().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType.Subject getSubjectAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSubject().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addSubject(
        @Nonnull
        final NoteType.Subject elem) {
        getSubject().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        NoteType ret) {
        if (subject == null) {
            ret.subject = null;
        } else {
            List<NoteType.Subject> retSubject = new ArrayList<NoteType.Subject>();
            for (NoteType.Subject aItem: getSubject()) {
                retSubject.add(((aItem == null)?null:aItem.clone()));
            }
            ret.subject = retSubject;
        }
        ret.text = ((text == null)?null:text.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public NoteType clone() {
        NoteType ret = new NoteType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type TextType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public TextType setText(
        @Nullable
        final String valueParam) {
        TextType aObj = getText();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setText(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TextType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getTextValue() {
        TextType aObj = getText();
        return (aObj == null)?null:aObj.getValue();
    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;simpleContent&amp;gt;
     *     &amp;lt;extension base="&amp;lt;http://www.w3.org/2001/XMLSchema&amp;gt;string"&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}SubjectTypeCodeEnumType" /&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/simpleContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "value"
    })
    @CodingStyleguideUnaware
    public static class Subject implements IExplicitlyCloneable
    {

        @XmlValue
        private String value;
        @XmlAttribute(name = "uri")
        private String uri;

        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public Subject() {
        }

        /**
         * Constructor for value of type String&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         * @param valueParam
         *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
         */
        public Subject(
            @Nullable
            final String valueParam) {
            setValue(valueParam);
        }

        /**
         * Gets the value of the value property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getValue() {
            return value;
        }

        /**
         * Sets the value of the value property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setValue(
            @Nullable
            String value) {
            this.value = value;
        }

        /**
         * Gets the value of the uri property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        @Nullable
        public String getUri() {
            return uri;
        }

        /**
         * Sets the value of the uri property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setUri(
            @Nullable
            String value) {
            this.uri = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if ((o == null)||(!getClass().equals(o.getClass()))) {
                return false;
            }
            final NoteType.Subject rhs = ((NoteType.Subject) o);
            if (!EqualsHelper.equals(uri, rhs.uri)) {
                return false;
            }
            if (!EqualsHelper.equals(value, rhs.value)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return new HashCodeGenerator(this).append(uri).append(value).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return new ToStringGenerator(this).append("uri", uri).append("value", value).getToString();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            NoteType.Subject ret) {
            ret.uri = uri;
            ret.value = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public NoteType.Subject clone() {
            NoteType.Subject ret = new NoteType.Subject();
            cloneTo(ret);
            return ret;
        }

    }

}
