
package eu.europa.data.europass.model.credentials_;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.Duration;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * A specification of learning. A specification or package of learning that is expressed in 1 or more learning outcomes. It is used to specify what a person did learn OR what a person can learn (e.g. by a given learning opportunity).
 * 
 * &lt;p&gt;Java class for LearningSpecificationType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="LearningSpecificationType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;group ref="{http://data.europa.eu/europass/model/credentials#}LearningSpecificationElements"/&amp;gt;
 *         &amp;lt;element name="hasPart" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="specializationOf" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *       &amp;lt;attribute name="id" use="required" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LearningSpecificationType", propOrder = {
    "identifier",
    "type",
    "title",
    "altLabel",
    "definition",
    "description",
    "additionalNote",
    "homepage",
    "supplementaryDoc",
    "hasISCEDFCode",
    "hasEducationSubject",
    "volumeOfLearning",
    "hasECTSCreditPoints",
    "hasCreditPoints",
    "hasEducationLevel",
    "language",
    "mode",
    "learningSettingType",
    "duration",
    "targetGroup",
    "entryRequirementsNote",
    "learningOutcomes",
    "learningActivitySpecification",
    "assessmentSpecification",
    "entitlementSpecification",
    "awardingOpportunities",
    "hasPart",
    "specializationOf"
})
@CodingStyleguideUnaware
public class LearningSpecificationType implements IExplicitlyCloneable
{

    private List<IdentifierType> identifier;
    private List<eu.europa.data.europass.model.credentials_.QualificationType.Type> type;
    private List<LanguageStringType> title;
    private List<LanguageStringType> altLabel;
    private List<NoteType> definition;
    private List<NoteType> description;
    private List<NoteType> additionalNote;
    private List<DocumentType> homepage;
    private List<DocumentType> supplementaryDoc;
    @XmlElement(name = "hasISCED-FCode")
    private List<eu.europa.data.europass.model.credentials_.QualificationType.HasISCEDFCode> hasISCEDFCode;
    private List<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationSubject> hasEducationSubject;
    private Duration volumeOfLearning;
    private ECTSCreditPointsType hasECTSCreditPoints;
    private List<CreditPointsType> hasCreditPoints;
    private List<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationLevel> hasEducationLevel;
    private List<eu.europa.data.europass.model.credentials_.QualificationType.Language> language;
    private List<eu.europa.data.europass.model.credentials_.QualificationType.Mode> mode;
    private eu.europa.data.europass.model.credentials_.QualificationType.LearningSettingType learningSettingType;
    private Duration duration;
    private List<eu.europa.data.europass.model.credentials_.QualificationType.TargetGroup> targetGroup;
    private List<NoteType> entryRequirementsNote;
    private eu.europa.data.europass.model.credentials_.QualificationType.LearningOutcomes learningOutcomes;
    private IdReferenceType learningActivitySpecification;
    private IdReferenceType assessmentSpecification;
    private List<IdReferenceType> entitlementSpecification;
    private eu.europa.data.europass.model.credentials_.QualificationType.AwardingOpportunities awardingOpportunities;
    private List<IdReferenceType> hasPart;
    private List<IdReferenceType> specializationOf;
    @XmlAttribute(name = "id", required = true)
    private String id;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public LearningSpecificationType() {
    }

    /**
     * Gets the value of the identifier property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the identifier property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getIdentifier().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdentifierType> getIdentifier() {
        if (identifier == null) {
            identifier = new ArrayList<IdentifierType>();
        }
        return this.identifier;
    }

    /**
     * Gets the value of the type property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the type property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getType().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link eu.europa.data.europass.model.credentials_.QualificationType.Type }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<eu.europa.data.europass.model.credentials_.QualificationType.Type> getType() {
        if (type == null) {
            type = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.Type>();
        }
        return this.type;
    }

    /**
     * Gets the value of the title property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the title property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getTitle().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageStringType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LanguageStringType> getTitle() {
        if (title == null) {
            title = new ArrayList<LanguageStringType>();
        }
        return this.title;
    }

    /**
     * Gets the value of the altLabel property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the altLabel property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getAltLabel().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageStringType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LanguageStringType> getAltLabel() {
        if (altLabel == null) {
            altLabel = new ArrayList<LanguageStringType>();
        }
        return this.altLabel;
    }

    /**
     * Gets the value of the definition property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the definition property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getDefinition().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getDefinition() {
        if (definition == null) {
            definition = new ArrayList<NoteType>();
        }
        return this.definition;
    }

    /**
     * Gets the value of the description property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the description property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getDescription().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getDescription() {
        if (description == null) {
            description = new ArrayList<NoteType>();
        }
        return this.description;
    }

    /**
     * Gets the value of the additionalNote property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the additionalNote property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getAdditionalNote().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getAdditionalNote() {
        if (additionalNote == null) {
            additionalNote = new ArrayList<NoteType>();
        }
        return this.additionalNote;
    }

    /**
     * Gets the value of the homepage property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the homepage property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHomepage().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentType> getHomepage() {
        if (homepage == null) {
            homepage = new ArrayList<DocumentType>();
        }
        return this.homepage;
    }

    /**
     * Gets the value of the supplementaryDoc property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the supplementaryDoc property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getSupplementaryDoc().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentType> getSupplementaryDoc() {
        if (supplementaryDoc == null) {
            supplementaryDoc = new ArrayList<DocumentType>();
        }
        return this.supplementaryDoc;
    }

    /**
     * Gets the value of the hasISCEDFCode property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasISCEDFCode property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasISCEDFCode().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link eu.europa.data.europass.model.credentials_.QualificationType.HasISCEDFCode }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<eu.europa.data.europass.model.credentials_.QualificationType.HasISCEDFCode> getHasISCEDFCode() {
        if (hasISCEDFCode == null) {
            hasISCEDFCode = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.HasISCEDFCode>();
        }
        return this.hasISCEDFCode;
    }

    /**
     * Gets the value of the hasEducationSubject property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasEducationSubject property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasEducationSubject().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link eu.europa.data.europass.model.credentials_.QualificationType.HasEducationSubject }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationSubject> getHasEducationSubject() {
        if (hasEducationSubject == null) {
            hasEducationSubject = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationSubject>();
        }
        return this.hasEducationSubject;
    }

    /**
     * Gets the value of the volumeOfLearning property.
     * 
     * @return
     *     possible object is
     *     {@link Duration }
     *     
     */
    @Nullable
    public Duration getVolumeOfLearning() {
        return volumeOfLearning;
    }

    /**
     * Sets the value of the volumeOfLearning property.
     * 
     * @param value
     *     allowed object is
     *     {@link Duration }
     *     
     */
    public void setVolumeOfLearning(
        @Nullable
        Duration value) {
        this.volumeOfLearning = value;
    }

    /**
     * Gets the value of the hasECTSCreditPoints property.
     * 
     * @return
     *     possible object is
     *     {@link ECTSCreditPointsType }
     *     
     */
    @Nullable
    public ECTSCreditPointsType getHasECTSCreditPoints() {
        return hasECTSCreditPoints;
    }

    /**
     * Sets the value of the hasECTSCreditPoints property.
     * 
     * @param value
     *     allowed object is
     *     {@link ECTSCreditPointsType }
     *     
     */
    public void setHasECTSCreditPoints(
        @Nullable
        ECTSCreditPointsType value) {
        this.hasECTSCreditPoints = value;
    }

    /**
     * Gets the value of the hasCreditPoints property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasCreditPoints property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasCreditPoints().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link CreditPointsType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CreditPointsType> getHasCreditPoints() {
        if (hasCreditPoints == null) {
            hasCreditPoints = new ArrayList<CreditPointsType>();
        }
        return this.hasCreditPoints;
    }

    /**
     * Gets the value of the hasEducationLevel property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasEducationLevel property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasEducationLevel().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link eu.europa.data.europass.model.credentials_.QualificationType.HasEducationLevel }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationLevel> getHasEducationLevel() {
        if (hasEducationLevel == null) {
            hasEducationLevel = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationLevel>();
        }
        return this.hasEducationLevel;
    }

    /**
     * Gets the value of the language property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the language property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getLanguage().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link eu.europa.data.europass.model.credentials_.QualificationType.Language }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<eu.europa.data.europass.model.credentials_.QualificationType.Language> getLanguage() {
        if (language == null) {
            language = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.Language>();
        }
        return this.language;
    }

    /**
     * Gets the value of the mode property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the mode property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getMode().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link eu.europa.data.europass.model.credentials_.QualificationType.Mode }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<eu.europa.data.europass.model.credentials_.QualificationType.Mode> getMode() {
        if (mode == null) {
            mode = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.Mode>();
        }
        return this.mode;
    }

    /**
     * Gets the value of the learningSettingType property.
     * 
     * @return
     *     possible object is
     *     {@link eu.europa.data.europass.model.credentials_.QualificationType.LearningSettingType }
     *     
     */
    @Nullable
    public eu.europa.data.europass.model.credentials_.QualificationType.LearningSettingType getLearningSettingType() {
        return learningSettingType;
    }

    /**
     * Sets the value of the learningSettingType property.
     * 
     * @param value
     *     allowed object is
     *     {@link eu.europa.data.europass.model.credentials_.QualificationType.LearningSettingType }
     *     
     */
    public void setLearningSettingType(
        @Nullable
        eu.europa.data.europass.model.credentials_.QualificationType.LearningSettingType value) {
        this.learningSettingType = value;
    }

    /**
     * Gets the value of the duration property.
     * 
     * @return
     *     possible object is
     *     {@link Duration }
     *     
     */
    @Nullable
    public Duration getDuration() {
        return duration;
    }

    /**
     * Sets the value of the duration property.
     * 
     * @param value
     *     allowed object is
     *     {@link Duration }
     *     
     */
    public void setDuration(
        @Nullable
        Duration value) {
        this.duration = value;
    }

    /**
     * Gets the value of the targetGroup property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the targetGroup property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getTargetGroup().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link eu.europa.data.europass.model.credentials_.QualificationType.TargetGroup }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<eu.europa.data.europass.model.credentials_.QualificationType.TargetGroup> getTargetGroup() {
        if (targetGroup == null) {
            targetGroup = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.TargetGroup>();
        }
        return this.targetGroup;
    }

    /**
     * Gets the value of the entryRequirementsNote property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the entryRequirementsNote property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getEntryRequirementsNote().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getEntryRequirementsNote() {
        if (entryRequirementsNote == null) {
            entryRequirementsNote = new ArrayList<NoteType>();
        }
        return this.entryRequirementsNote;
    }

    /**
     * Gets the value of the learningOutcomes property.
     * 
     * @return
     *     possible object is
     *     {@link eu.europa.data.europass.model.credentials_.QualificationType.LearningOutcomes }
     *     
     */
    @Nullable
    public eu.europa.data.europass.model.credentials_.QualificationType.LearningOutcomes getLearningOutcomes() {
        return learningOutcomes;
    }

    /**
     * Sets the value of the learningOutcomes property.
     * 
     * @param value
     *     allowed object is
     *     {@link eu.europa.data.europass.model.credentials_.QualificationType.LearningOutcomes }
     *     
     */
    public void setLearningOutcomes(
        @Nullable
        eu.europa.data.europass.model.credentials_.QualificationType.LearningOutcomes value) {
        this.learningOutcomes = value;
    }

    /**
     * Gets the value of the learningActivitySpecification property.
     * 
     * @return
     *     possible object is
     *     {@link IdReferenceType }
     *     
     */
    @Nullable
    public IdReferenceType getLearningActivitySpecification() {
        return learningActivitySpecification;
    }

    /**
     * Sets the value of the learningActivitySpecification property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdReferenceType }
     *     
     */
    public void setLearningActivitySpecification(
        @Nullable
        IdReferenceType value) {
        this.learningActivitySpecification = value;
    }

    /**
     * Gets the value of the assessmentSpecification property.
     * 
     * @return
     *     possible object is
     *     {@link IdReferenceType }
     *     
     */
    @Nullable
    public IdReferenceType getAssessmentSpecification() {
        return assessmentSpecification;
    }

    /**
     * Sets the value of the assessmentSpecification property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdReferenceType }
     *     
     */
    public void setAssessmentSpecification(
        @Nullable
        IdReferenceType value) {
        this.assessmentSpecification = value;
    }

    /**
     * Gets the value of the entitlementSpecification property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the entitlementSpecification property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getEntitlementSpecification().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdReferenceType> getEntitlementSpecification() {
        if (entitlementSpecification == null) {
            entitlementSpecification = new ArrayList<IdReferenceType>();
        }
        return this.entitlementSpecification;
    }

    /**
     * Gets the value of the awardingOpportunities property.
     * 
     * @return
     *     possible object is
     *     {@link eu.europa.data.europass.model.credentials_.QualificationType.AwardingOpportunities }
     *     
     */
    @Nullable
    public eu.europa.data.europass.model.credentials_.QualificationType.AwardingOpportunities getAwardingOpportunities() {
        return awardingOpportunities;
    }

    /**
     * Sets the value of the awardingOpportunities property.
     * 
     * @param value
     *     allowed object is
     *     {@link eu.europa.data.europass.model.credentials_.QualificationType.AwardingOpportunities }
     *     
     */
    public void setAwardingOpportunities(
        @Nullable
        eu.europa.data.europass.model.credentials_.QualificationType.AwardingOpportunities value) {
        this.awardingOpportunities = value;
    }

    /**
     * Gets the value of the hasPart property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasPart property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasPart().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdReferenceType> getHasPart() {
        if (hasPart == null) {
            hasPart = new ArrayList<IdReferenceType>();
        }
        return this.hasPart;
    }

    /**
     * Gets the value of the specializationOf property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the specializationOf property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getSpecializationOf().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdReferenceType> getSpecializationOf() {
        if (specializationOf == null) {
            specializationOf = new ArrayList<IdReferenceType>();
        }
        return this.specializationOf;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(
        @Nullable
        String value) {
        this.id = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LearningSpecificationType rhs = ((LearningSpecificationType) o);
        if (!EqualsHelper.equalsCollection(additionalNote, rhs.additionalNote)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(altLabel, rhs.altLabel)) {
            return false;
        }
        if (!EqualsHelper.equals(assessmentSpecification, rhs.assessmentSpecification)) {
            return false;
        }
        if (!EqualsHelper.equals(awardingOpportunities, rhs.awardingOpportunities)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(definition, rhs.definition)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(duration, rhs.duration)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(entitlementSpecification, rhs.entitlementSpecification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(entryRequirementsNote, rhs.entryRequirementsNote)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasCreditPoints, rhs.hasCreditPoints)) {
            return false;
        }
        if (!EqualsHelper.equals(hasECTSCreditPoints, rhs.hasECTSCreditPoints)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasEducationLevel, rhs.hasEducationLevel)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasEducationSubject, rhs.hasEducationSubject)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasISCEDFCode, rhs.hasISCEDFCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasPart, rhs.hasPart)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(homepage, rhs.homepage)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(identifier, rhs.identifier)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(language, rhs.language)) {
            return false;
        }
        if (!EqualsHelper.equals(learningActivitySpecification, rhs.learningActivitySpecification)) {
            return false;
        }
        if (!EqualsHelper.equals(learningOutcomes, rhs.learningOutcomes)) {
            return false;
        }
        if (!EqualsHelper.equals(learningSettingType, rhs.learningSettingType)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(mode, rhs.mode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specializationOf, rhs.specializationOf)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(supplementaryDoc, rhs.supplementaryDoc)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(targetGroup, rhs.targetGroup)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(title, rhs.title)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(type, rhs.type)) {
            return false;
        }
        if (!EqualsHelper.equals(volumeOfLearning, rhs.volumeOfLearning)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalNote).append(altLabel).append(assessmentSpecification).append(awardingOpportunities).append(definition).append(description).append(duration).append(entitlementSpecification).append(entryRequirementsNote).append(hasCreditPoints).append(hasECTSCreditPoints).append(hasEducationLevel).append(hasEducationSubject).append(hasISCEDFCode).append(hasPart).append(homepage).append(id).append(identifier).append(language).append(learningActivitySpecification).append(learningOutcomes).append(learningSettingType).append(mode).append(specializationOf).append(supplementaryDoc).append(targetGroup).append(title).append(type).append(volumeOfLearning).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalNote", additionalNote).append("altLabel", altLabel).append("assessmentSpecification", assessmentSpecification).append("awardingOpportunities", awardingOpportunities).append("definition", definition).append("description", description).append("duration", duration).append("entitlementSpecification", entitlementSpecification).append("entryRequirementsNote", entryRequirementsNote).append("hasCreditPoints", hasCreditPoints).append("hasECTSCreditPoints", hasECTSCreditPoints).append("hasEducationLevel", hasEducationLevel).append("hasEducationSubject", hasEducationSubject).append("hasISCEDFCode", hasISCEDFCode).append("hasPart", hasPart).append("homepage", homepage).append("id", id).append("identifier", identifier).append("language", language).append("learningActivitySpecification", learningActivitySpecification).append("learningOutcomes", learningOutcomes).append("learningSettingType", learningSettingType).append("mode", mode).append("specializationOf", specializationOf).append("supplementaryDoc", supplementaryDoc).append("targetGroup", targetGroup).append("title", title).append("type", type).append("volumeOfLearning", volumeOfLearning).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setIdentifier(
        @Nullable
        final List<IdentifierType> aList) {
        identifier = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setType(
        @Nullable
        final List<eu.europa.data.europass.model.credentials_.QualificationType.Type> aList) {
        type = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTitle(
        @Nullable
        final List<LanguageStringType> aList) {
        title = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setAltLabel(
        @Nullable
        final List<LanguageStringType> aList) {
        altLabel = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDefinition(
        @Nullable
        final List<NoteType> aList) {
        definition = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDescription(
        @Nullable
        final List<NoteType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setAdditionalNote(
        @Nullable
        final List<NoteType> aList) {
        additionalNote = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHomepage(
        @Nullable
        final List<DocumentType> aList) {
        homepage = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setSupplementaryDoc(
        @Nullable
        final List<DocumentType> aList) {
        supplementaryDoc = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasISCEDFCode(
        @Nullable
        final List<eu.europa.data.europass.model.credentials_.QualificationType.HasISCEDFCode> aList) {
        hasISCEDFCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasEducationSubject(
        @Nullable
        final List<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationSubject> aList) {
        hasEducationSubject = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasCreditPoints(
        @Nullable
        final List<CreditPointsType> aList) {
        hasCreditPoints = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasEducationLevel(
        @Nullable
        final List<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationLevel> aList) {
        hasEducationLevel = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setLanguage(
        @Nullable
        final List<eu.europa.data.europass.model.credentials_.QualificationType.Language> aList) {
        language = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setMode(
        @Nullable
        final List<eu.europa.data.europass.model.credentials_.QualificationType.Mode> aList) {
        mode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTargetGroup(
        @Nullable
        final List<eu.europa.data.europass.model.credentials_.QualificationType.TargetGroup> aList) {
        targetGroup = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setEntryRequirementsNote(
        @Nullable
        final List<NoteType> aList) {
        entryRequirementsNote = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setEntitlementSpecification(
        @Nullable
        final List<IdReferenceType> aList) {
        entitlementSpecification = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasPart(
        @Nullable
        final List<IdReferenceType> aList) {
        hasPart = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setSpecializationOf(
        @Nullable
        final List<IdReferenceType> aList) {
        specializationOf = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasIdentifierEntries() {
        return (!getIdentifier().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoIdentifierEntries() {
        return getIdentifier().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getIdentifierCount() {
        return getIdentifier().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdentifierType getIdentifierAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIdentifier().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addIdentifier(
        @Nonnull
        final IdentifierType elem) {
        getIdentifier().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTypeEntries() {
        return (!getType().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTypeEntries() {
        return getType().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTypeCount() {
        return getType().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public eu.europa.data.europass.model.credentials_.QualificationType.Type getTypeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getType().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addType(
        @Nonnull
        final eu.europa.data.europass.model.credentials_.QualificationType.Type elem) {
        getType().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTitleEntries() {
        return (!getTitle().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTitleEntries() {
        return getTitle().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTitleCount() {
        return getTitle().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LanguageStringType getTitleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTitle().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addTitle(
        @Nonnull
        final LanguageStringType elem) {
        getTitle().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasAltLabelEntries() {
        return (!getAltLabel().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoAltLabelEntries() {
        return getAltLabel().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getAltLabelCount() {
        return getAltLabel().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LanguageStringType getAltLabelAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAltLabel().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addAltLabel(
        @Nonnull
        final LanguageStringType elem) {
        getAltLabel().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasDefinitionEntries() {
        return (!getDefinition().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoDefinitionEntries() {
        return getDefinition().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getDefinitionCount() {
        return getDefinition().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getDefinitionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDefinition().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addDefinition(
        @Nonnull
        final NoteType elem) {
        getDefinition().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addDescription(
        @Nonnull
        final NoteType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasAdditionalNoteEntries() {
        return (!getAdditionalNote().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoAdditionalNoteEntries() {
        return getAdditionalNote().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getAdditionalNoteCount() {
        return getAdditionalNote().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getAdditionalNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalNote().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addAdditionalNote(
        @Nonnull
        final NoteType elem) {
        getAdditionalNote().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHomepageEntries() {
        return (!getHomepage().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHomepageEntries() {
        return getHomepage().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHomepageCount() {
        return getHomepage().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentType getHomepageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHomepage().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHomepage(
        @Nonnull
        final DocumentType elem) {
        getHomepage().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasSupplementaryDocEntries() {
        return (!getSupplementaryDoc().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoSupplementaryDocEntries() {
        return getSupplementaryDoc().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getSupplementaryDocCount() {
        return getSupplementaryDoc().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentType getSupplementaryDocAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSupplementaryDoc().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addSupplementaryDoc(
        @Nonnull
        final DocumentType elem) {
        getSupplementaryDoc().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasISCEDFCodeEntries() {
        return (!getHasISCEDFCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasISCEDFCodeEntries() {
        return getHasISCEDFCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasISCEDFCodeCount() {
        return getHasISCEDFCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public eu.europa.data.europass.model.credentials_.QualificationType.HasISCEDFCode getHasISCEDFCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasISCEDFCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasISCEDFCode(
        @Nonnull
        final eu.europa.data.europass.model.credentials_.QualificationType.HasISCEDFCode elem) {
        getHasISCEDFCode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasEducationSubjectEntries() {
        return (!getHasEducationSubject().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasEducationSubjectEntries() {
        return getHasEducationSubject().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasEducationSubjectCount() {
        return getHasEducationSubject().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public eu.europa.data.europass.model.credentials_.QualificationType.HasEducationSubject getHasEducationSubjectAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasEducationSubject().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasEducationSubject(
        @Nonnull
        final eu.europa.data.europass.model.credentials_.QualificationType.HasEducationSubject elem) {
        getHasEducationSubject().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasCreditPointsEntries() {
        return (!getHasCreditPoints().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasCreditPointsEntries() {
        return getHasCreditPoints().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasCreditPointsCount() {
        return getHasCreditPoints().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CreditPointsType getHasCreditPointsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasCreditPoints().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasCreditPoints(
        @Nonnull
        final CreditPointsType elem) {
        getHasCreditPoints().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasEducationLevelEntries() {
        return (!getHasEducationLevel().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasEducationLevelEntries() {
        return getHasEducationLevel().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasEducationLevelCount() {
        return getHasEducationLevel().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public eu.europa.data.europass.model.credentials_.QualificationType.HasEducationLevel getHasEducationLevelAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasEducationLevel().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasEducationLevel(
        @Nonnull
        final eu.europa.data.europass.model.credentials_.QualificationType.HasEducationLevel elem) {
        getHasEducationLevel().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasLanguageEntries() {
        return (!getLanguage().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoLanguageEntries() {
        return getLanguage().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getLanguageCount() {
        return getLanguage().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public eu.europa.data.europass.model.credentials_.QualificationType.Language getLanguageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLanguage().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addLanguage(
        @Nonnull
        final eu.europa.data.europass.model.credentials_.QualificationType.Language elem) {
        getLanguage().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasModeEntries() {
        return (!getMode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoModeEntries() {
        return getMode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getModeCount() {
        return getMode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public eu.europa.data.europass.model.credentials_.QualificationType.Mode getModeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addMode(
        @Nonnull
        final eu.europa.data.europass.model.credentials_.QualificationType.Mode elem) {
        getMode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTargetGroupEntries() {
        return (!getTargetGroup().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTargetGroupEntries() {
        return getTargetGroup().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTargetGroupCount() {
        return getTargetGroup().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public eu.europa.data.europass.model.credentials_.QualificationType.TargetGroup getTargetGroupAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTargetGroup().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addTargetGroup(
        @Nonnull
        final eu.europa.data.europass.model.credentials_.QualificationType.TargetGroup elem) {
        getTargetGroup().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasEntryRequirementsNoteEntries() {
        return (!getEntryRequirementsNote().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoEntryRequirementsNoteEntries() {
        return getEntryRequirementsNote().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getEntryRequirementsNoteCount() {
        return getEntryRequirementsNote().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getEntryRequirementsNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEntryRequirementsNote().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addEntryRequirementsNote(
        @Nonnull
        final NoteType elem) {
        getEntryRequirementsNote().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasEntitlementSpecificationEntries() {
        return (!getEntitlementSpecification().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoEntitlementSpecificationEntries() {
        return getEntitlementSpecification().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getEntitlementSpecificationCount() {
        return getEntitlementSpecification().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdReferenceType getEntitlementSpecificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEntitlementSpecification().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addEntitlementSpecification(
        @Nonnull
        final IdReferenceType elem) {
        getEntitlementSpecification().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasPartEntries() {
        return (!getHasPart().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasPartEntries() {
        return getHasPart().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasPartCount() {
        return getHasPart().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdReferenceType getHasPartAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasPart().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasPart(
        @Nonnull
        final IdReferenceType elem) {
        getHasPart().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasSpecializationOfEntries() {
        return (!getSpecializationOf().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoSpecializationOfEntries() {
        return getSpecializationOf().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getSpecializationOfCount() {
        return getSpecializationOf().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdReferenceType getSpecializationOfAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecializationOf().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addSpecializationOf(
        @Nonnull
        final IdReferenceType elem) {
        getSpecializationOf().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        LearningSpecificationType ret) {
        if (additionalNote == null) {
            ret.additionalNote = null;
        } else {
            List<NoteType> retAdditionalNote = new ArrayList<NoteType>();
            for (NoteType aItem: getAdditionalNote()) {
                retAdditionalNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalNote = retAdditionalNote;
        }
        if (altLabel == null) {
            ret.altLabel = null;
        } else {
            List<LanguageStringType> retAltLabel = new ArrayList<LanguageStringType>();
            for (LanguageStringType aItem: getAltLabel()) {
                retAltLabel.add(((aItem == null)?null:aItem.clone()));
            }
            ret.altLabel = retAltLabel;
        }
        ret.assessmentSpecification = ((assessmentSpecification == null)?null:assessmentSpecification.clone());
        ret.awardingOpportunities = ((awardingOpportunities == null)?null:awardingOpportunities.clone());
        if (definition == null) {
            ret.definition = null;
        } else {
            List<NoteType> retDefinition = new ArrayList<NoteType>();
            for (NoteType aItem: getDefinition()) {
                retDefinition.add(((aItem == null)?null:aItem.clone()));
            }
            ret.definition = retDefinition;
        }
        if (description == null) {
            ret.description = null;
        } else {
            List<NoteType> retDescription = new ArrayList<NoteType>();
            for (NoteType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.duration = duration;
        if (entitlementSpecification == null) {
            ret.entitlementSpecification = null;
        } else {
            List<IdReferenceType> retEntitlementSpecification = new ArrayList<IdReferenceType>();
            for (IdReferenceType aItem: getEntitlementSpecification()) {
                retEntitlementSpecification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.entitlementSpecification = retEntitlementSpecification;
        }
        if (entryRequirementsNote == null) {
            ret.entryRequirementsNote = null;
        } else {
            List<NoteType> retEntryRequirementsNote = new ArrayList<NoteType>();
            for (NoteType aItem: getEntryRequirementsNote()) {
                retEntryRequirementsNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.entryRequirementsNote = retEntryRequirementsNote;
        }
        if (hasCreditPoints == null) {
            ret.hasCreditPoints = null;
        } else {
            List<CreditPointsType> retHasCreditPoints = new ArrayList<CreditPointsType>();
            for (CreditPointsType aItem: getHasCreditPoints()) {
                retHasCreditPoints.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasCreditPoints = retHasCreditPoints;
        }
        ret.hasECTSCreditPoints = ((hasECTSCreditPoints == null)?null:hasECTSCreditPoints.clone());
        if (hasEducationLevel == null) {
            ret.hasEducationLevel = null;
        } else {
            List<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationLevel> retHasEducationLevel = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationLevel>();
            for (eu.europa.data.europass.model.credentials_.QualificationType.HasEducationLevel aItem: getHasEducationLevel()) {
                retHasEducationLevel.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasEducationLevel = retHasEducationLevel;
        }
        if (hasEducationSubject == null) {
            ret.hasEducationSubject = null;
        } else {
            List<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationSubject> retHasEducationSubject = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.HasEducationSubject>();
            for (eu.europa.data.europass.model.credentials_.QualificationType.HasEducationSubject aItem: getHasEducationSubject()) {
                retHasEducationSubject.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasEducationSubject = retHasEducationSubject;
        }
        if (hasISCEDFCode == null) {
            ret.hasISCEDFCode = null;
        } else {
            List<eu.europa.data.europass.model.credentials_.QualificationType.HasISCEDFCode> retHasISCEDFCode = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.HasISCEDFCode>();
            for (eu.europa.data.europass.model.credentials_.QualificationType.HasISCEDFCode aItem: getHasISCEDFCode()) {
                retHasISCEDFCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasISCEDFCode = retHasISCEDFCode;
        }
        if (hasPart == null) {
            ret.hasPart = null;
        } else {
            List<IdReferenceType> retHasPart = new ArrayList<IdReferenceType>();
            for (IdReferenceType aItem: getHasPart()) {
                retHasPart.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasPart = retHasPart;
        }
        if (homepage == null) {
            ret.homepage = null;
        } else {
            List<DocumentType> retHomepage = new ArrayList<DocumentType>();
            for (DocumentType aItem: getHomepage()) {
                retHomepage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.homepage = retHomepage;
        }
        ret.id = id;
        if (identifier == null) {
            ret.identifier = null;
        } else {
            List<IdentifierType> retIdentifier = new ArrayList<IdentifierType>();
            for (IdentifierType aItem: getIdentifier()) {
                retIdentifier.add(((aItem == null)?null:aItem.clone()));
            }
            ret.identifier = retIdentifier;
        }
        if (language == null) {
            ret.language = null;
        } else {
            List<eu.europa.data.europass.model.credentials_.QualificationType.Language> retLanguage = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.Language>();
            for (eu.europa.data.europass.model.credentials_.QualificationType.Language aItem: getLanguage()) {
                retLanguage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.language = retLanguage;
        }
        ret.learningActivitySpecification = ((learningActivitySpecification == null)?null:learningActivitySpecification.clone());
        ret.learningOutcomes = ((learningOutcomes == null)?null:learningOutcomes.clone());
        ret.learningSettingType = ((learningSettingType == null)?null:learningSettingType.clone());
        if (mode == null) {
            ret.mode = null;
        } else {
            List<eu.europa.data.europass.model.credentials_.QualificationType.Mode> retMode = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.Mode>();
            for (eu.europa.data.europass.model.credentials_.QualificationType.Mode aItem: getMode()) {
                retMode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.mode = retMode;
        }
        if (specializationOf == null) {
            ret.specializationOf = null;
        } else {
            List<IdReferenceType> retSpecializationOf = new ArrayList<IdReferenceType>();
            for (IdReferenceType aItem: getSpecializationOf()) {
                retSpecializationOf.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specializationOf = retSpecializationOf;
        }
        if (supplementaryDoc == null) {
            ret.supplementaryDoc = null;
        } else {
            List<DocumentType> retSupplementaryDoc = new ArrayList<DocumentType>();
            for (DocumentType aItem: getSupplementaryDoc()) {
                retSupplementaryDoc.add(((aItem == null)?null:aItem.clone()));
            }
            ret.supplementaryDoc = retSupplementaryDoc;
        }
        if (targetGroup == null) {
            ret.targetGroup = null;
        } else {
            List<eu.europa.data.europass.model.credentials_.QualificationType.TargetGroup> retTargetGroup = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.TargetGroup>();
            for (eu.europa.data.europass.model.credentials_.QualificationType.TargetGroup aItem: getTargetGroup()) {
                retTargetGroup.add(((aItem == null)?null:aItem.clone()));
            }
            ret.targetGroup = retTargetGroup;
        }
        if (title == null) {
            ret.title = null;
        } else {
            List<LanguageStringType> retTitle = new ArrayList<LanguageStringType>();
            for (LanguageStringType aItem: getTitle()) {
                retTitle.add(((aItem == null)?null:aItem.clone()));
            }
            ret.title = retTitle;
        }
        if (type == null) {
            ret.type = null;
        } else {
            List<eu.europa.data.europass.model.credentials_.QualificationType.Type> retType = new ArrayList<eu.europa.data.europass.model.credentials_.QualificationType.Type>();
            for (eu.europa.data.europass.model.credentials_.QualificationType.Type aItem: getType()) {
                retType.add(((aItem == null)?null:aItem.clone()));
            }
            ret.type = retType;
        }
        ret.volumeOfLearning = volumeOfLearning;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LearningSpecificationType clone() {
        LearningSpecificationType ret = new LearningSpecificationType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type ECTSCreditPointsType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public ECTSCreditPointsType setHasECTSCreditPoints(
        @Nullable
        final BigDecimal valueParam) {
        ECTSCreditPointsType aObj = getHasECTSCreditPoints();
        if (aObj == null) {
            aObj = new ECTSCreditPointsType(valueParam);
            setHasECTSCreditPoints(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained ECTSCreditPointsType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ECTSCreditPointsType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public BigDecimal getHasECTSCreditPointsValue() {
        ECTSCreditPointsType aObj = getHasECTSCreditPoints();
        return (aObj == null)?null:aObj.getValue();
    }

}
