
package eu.europa.data.europass.model.credentials_;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * 
 * 				Identifiers are needed to identify and link resources in a unique and persistent way.
 * 				A resource identifier must be unique and persistent, meaning the identifier will always refer to the same resource and cannot be reused to identify other resources.
 * 				A resource identifier consists of:
 * 				 - a string identifier, unique and persistent within the scope of the issuing system.
 * 				 - a unique identifier of the publishing system that issued the string identifier for that particular resource.
 * 				The combination of both, the string identifier and the unique identifier of the issuing system, makes the resource identifier globally unique.
 * 				
 * 				The IdentifierType is used to describe a full (alternative) identifier of an entity or resource.
 * 				- The text content of the IdentifierType-element contains the character string to identify and distinguish uniquely the resource within the scope of the identification scheme
 * 				- The schemeID attribute is used to specify the identifier scheme. The identifier schema (or identifier register) refers to the agent/system that issued the identifier, it specifies where the identifier originates from.
 * 				  It is the namespace in which the identifier is unique and persistent.
 * 								
 * 				The other attributes of the IdentifierType-element provide supplementary information such as the identifier of the used code list and the agency that maintains this list
 * 			
 * 
 * &lt;p&gt;Java class for IdentifierType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="IdentifierType"&amp;gt;
 *   &amp;lt;simpleContent&amp;gt;
 *     &amp;lt;extension base="&amp;lt;http://www.w3.org/2001/XMLSchema&amp;gt;normalizedString"&amp;gt;
 *       &amp;lt;attribute name="schemeID" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
 *       &amp;lt;attribute name="schemeName" type="{http://www.w3.org/2001/XMLSchema}string" /&amp;gt;
 *       &amp;lt;attribute name="schemeAgencyName" type="{http://www.w3.org/2001/XMLSchema}string" /&amp;gt;
 *       &amp;lt;attribute name="issuedDate" type="{http://www.w3.org/2001/XMLSchema}dateTime" /&amp;gt;
 *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
 *       &amp;lt;attribute name="spatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
 *     &amp;lt;/extension&amp;gt;
 *   &amp;lt;/simpleContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "IdentifierType", propOrder = {
    "value"
})
@XmlSeeAlso({
    LegalIdentifierType.class
})
@CodingStyleguideUnaware
public class IdentifierType implements IExplicitlyCloneable
{

    @XmlValue
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String value;
    @XmlAttribute(name = "schemeID")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String schemeID;
    @XmlAttribute(name = "schemeName")
    private String schemeName;
    @XmlAttribute(name = "schemeAgencyName")
    private String schemeAgencyName;
    @XmlAttribute(name = "issuedDate")
    @XmlSchemaType(name = "dateTime")
    private XMLGregorianCalendar issuedDate;
    @XmlAttribute(name = "type")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    private String type;
    @XmlAttribute(name = "spatialID")
    private String spatialID;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public IdentifierType() {
    }

    /**
     * Constructor for value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public IdentifierType(
        @Nullable
        final String valueParam) {
        setValue(valueParam);
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setValue(
        @Nullable
        String value) {
        this.value = value;
    }

    /**
     * Gets the value of the schemeID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSchemeID() {
        return schemeID;
    }

    /**
     * Sets the value of the schemeID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSchemeID(
        @Nullable
        String value) {
        this.schemeID = value;
    }

    /**
     * Gets the value of the schemeName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSchemeName() {
        return schemeName;
    }

    /**
     * Sets the value of the schemeName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSchemeName(
        @Nullable
        String value) {
        this.schemeName = value;
    }

    /**
     * Gets the value of the schemeAgencyName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSchemeAgencyName() {
        return schemeAgencyName;
    }

    /**
     * Sets the value of the schemeAgencyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSchemeAgencyName(
        @Nullable
        String value) {
        this.schemeAgencyName = value;
    }

    /**
     * Gets the value of the issuedDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getIssuedDate() {
        return issuedDate;
    }

    /**
     * Sets the value of the issuedDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setIssuedDate(
        @Nullable
        XMLGregorianCalendar value) {
        this.issuedDate = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setType(
        @Nullable
        String value) {
        this.type = value;
    }

    /**
     * Gets the value of the spatialID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSpatialID() {
        return spatialID;
    }

    /**
     * Sets the value of the spatialID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSpatialID(
        @Nullable
        String value) {
        this.spatialID = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final IdentifierType rhs = ((IdentifierType) o);
        if (!EqualsHelper.equals(issuedDate, rhs.issuedDate)) {
            return false;
        }
        if (!EqualsHelper.equals(schemeAgencyName, rhs.schemeAgencyName)) {
            return false;
        }
        if (!EqualsHelper.equals(schemeID, rhs.schemeID)) {
            return false;
        }
        if (!EqualsHelper.equals(schemeName, rhs.schemeName)) {
            return false;
        }
        if (!EqualsHelper.equals(spatialID, rhs.spatialID)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        if (!EqualsHelper.equals(value, rhs.value)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(issuedDate).append(schemeAgencyName).append(schemeID).append(schemeName).append(spatialID).append(type).append(value).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("issuedDate", issuedDate).append("schemeAgencyName", schemeAgencyName).append("schemeID", schemeID).append("schemeName", schemeName).append("spatialID", spatialID).append("type", type).append("value", value).getToString();
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        IdentifierType ret) {
        ret.issuedDate = ((issuedDate == null)?null:((XMLGregorianCalendar) issuedDate.clone()));
        ret.schemeAgencyName = schemeAgencyName;
        ret.schemeID = schemeID;
        ret.schemeName = schemeName;
        ret.spatialID = spatialID;
        ret.type = type;
        ret.value = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public IdentifierType clone() {
        IdentifierType ret = new IdentifierType();
        cloneTo(ret);
        return ret;
    }

}
