
package eu.europa.data.europass.model.credentials_;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.XMLGregorianCalendar;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xsds.xmldsig.SignatureType;
import eu.europa.data.europass.model.credentials.w3c_.IdReferenceType;
import eu.europa.data.europass.model.credentials.w3c_.ProofType;


/**
 * A set of claims made by an issuer in Europe, using the Europass Standards.  A Europass credential is a set of one or more claims which may be used to demonstrate that the owner has certain skills or has achieved certain learning outcomes through formal, non-formal or informal learning.
 * 
 * &lt;p&gt;Java class for EuropassCredentialType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="EuropassCredentialType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="identifier" type="{http://data.europa.eu/europass/model/credentials#}IdentifierType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="type" type="{http://data.europa.eu/europass/model/credentials#}CredentialTypeType"/&amp;gt;
 *         &amp;lt;element ref="{http://data.europa.eu/europass/model/credentials/w3c#}validFrom" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{http://data.europa.eu/europass/model/credentials/w3c#}issued"/&amp;gt;
 *         &amp;lt;element ref="{http://data.europa.eu/europass/model/credentials/w3c#}validUntil" minOccurs="0"/&amp;gt;
 *         &amp;lt;element ref="{http://data.europa.eu/europass/model/credentials/w3c#}issuer"/&amp;gt;
 *         &amp;lt;element name="title" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *         &amp;lt;element name="description" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="credentialSubject" type="{http://data.europa.eu/europass/model/credentials#}CredentialSubjectType"/&amp;gt;
 *         &amp;lt;element name="learningSpecificationReferences" type="{http://data.europa.eu/europass/model/credentials#}LearningSpecificationReferencesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="learningOutcomeReferences" type="{http://data.europa.eu/europass/model/credentials#}LearningOutcomeReferencesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="learningActivitySpecificationReferences" type="{http://data.europa.eu/europass/model/credentials#}LearningActivitySpecificationReferencesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="assessmentSpecificationReferences" type="{http://data.europa.eu/europass/model/credentials#}AssessmentSpecificationReferencesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="entitlementSpecificationReferences" type="{http://data.europa.eu/europass/model/credentials#}EntitlementSpecificationReferencesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="learningOpportunityReferences" type="{http://data.europa.eu/europass/model/credentials#}LearningOpportunityReferencesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="agentReferences" type="{http://data.europa.eu/europass/model/credentials#}AgentReferencesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="awardingProcessReferences" type="{http://data.europa.eu/europass/model/credentials#}AwardingProcessReferencesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="accreditationReferences" type="{http://data.europa.eu/europass/model/credentials#}AccreditationReferencesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="scoringSchemeReferences" type="{http://data.europa.eu/europass/model/credentials#}ScoringSchemeReferencesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="semanticFrameworkReferences" type="{http://data.europa.eu/europass/model/credentials#}FrameworkReferencesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="displayParameters" type="{http://data.europa.eu/europass/model/credentials#}DisplayParametersType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="attachmentList" type="{http://data.europa.eu/europass/model/credentials#}AttachmentListType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="proof"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;complexContent&amp;gt;
 *               &amp;lt;extension base="{http://data.europa.eu/europass/model/credentials/w3c#}ProofType"&amp;gt;
 *                 &amp;lt;sequence&amp;gt;
 *                   &amp;lt;element ref="{http://www.w3.org/2000/09/xmldsig#}Signature" minOccurs="0"/&amp;gt;
 *                 &amp;lt;/sequence&amp;gt;
 *               &amp;lt;/extension&amp;gt;
 *             &amp;lt;/complexContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="childCredentials" type="{http://data.europa.eu/europass/model/credentials#}ChildCredentialsType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *       &amp;lt;attribute ref="{http://data.europa.eu/europass/model/credentials/w3c#}id use="required""/&amp;gt;
 *       &amp;lt;attribute name="xsdVersion" default="0.10.0"&amp;gt;
 *         &amp;lt;simpleType&amp;gt;
 *           &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}token"&amp;gt;
 *             &amp;lt;enumeration value="0.10.0"/&amp;gt;
 *           &amp;lt;/restriction&amp;gt;
 *         &amp;lt;/simpleType&amp;gt;
 *       &amp;lt;/attribute&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EuropassCredentialType", propOrder = {
    "identifier",
    "type",
    "validFrom",
    "issued",
    "validUntil",
    "issuer",
    "title",
    "description",
    "credentialSubject",
    "learningSpecificationReferences",
    "learningOutcomeReferences",
    "learningActivitySpecificationReferences",
    "assessmentSpecificationReferences",
    "entitlementSpecificationReferences",
    "learningOpportunityReferences",
    "agentReferences",
    "awardingProcessReferences",
    "accreditationReferences",
    "scoringSchemeReferences",
    "semanticFrameworkReferences",
    "displayParameters",
    "attachmentList",
    "proof",
    "childCredentials"
})
@CodingStyleguideUnaware
public class EuropassCredentialType implements IExplicitlyCloneable
{

    private List<IdentifierType> identifier;
    @XmlElement(required = true)
    private CredentialTypeType type;
    @XmlElement(namespace = "http://data.europa.eu/europass/model/credentials/w3c#")
    @XmlSchemaType(name = "dateTime")
    private XMLGregorianCalendar validFrom;
    @XmlElement(namespace = "http://data.europa.eu/europass/model/credentials/w3c#", required = true)
    @XmlSchemaType(name = "dateTime")
    private XMLGregorianCalendar issued;
    @XmlElement(namespace = "http://data.europa.eu/europass/model/credentials/w3c#")
    @XmlSchemaType(name = "dateTime")
    private XMLGregorianCalendar validUntil;
    @XmlElement(namespace = "http://data.europa.eu/europass/model/credentials/w3c#", required = true)
    private IdReferenceType issuer;
    @XmlElement(required = true)
    private List<LanguageStringType> title;
    private List<NoteType> description;
    @XmlElement(required = true)
    private CredentialSubjectType credentialSubject;
    private LearningSpecificationReferencesType learningSpecificationReferences;
    private LearningOutcomeReferencesType learningOutcomeReferences;
    private LearningActivitySpecificationReferencesType learningActivitySpecificationReferences;
    private AssessmentSpecificationReferencesType assessmentSpecificationReferences;
    private EntitlementSpecificationReferencesType entitlementSpecificationReferences;
    private LearningOpportunityReferencesType learningOpportunityReferences;
    private AgentReferencesType agentReferences;
    private AwardingProcessReferencesType awardingProcessReferences;
    private AccreditationReferencesType accreditationReferences;
    private ScoringSchemeReferencesType scoringSchemeReferences;
    private FrameworkReferencesType semanticFrameworkReferences;
    private DisplayParametersType displayParameters;
    private AttachmentListType attachmentList;
    @XmlElement(required = true)
    private EuropassCredentialType.Proof proof;
    private List<ChildCredentialsType> childCredentials;
    @XmlAttribute(name = "id", namespace = "http://data.europa.eu/europass/model/credentials/w3c#", required = true)
    private String id;
    @XmlAttribute(name = "xsdVersion")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    private String xsdVersion;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public EuropassCredentialType() {
    }

    /**
     * Gets the value of the identifier property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the identifier property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getIdentifier().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdentifierType> getIdentifier() {
        if (identifier == null) {
            identifier = new ArrayList<IdentifierType>();
        }
        return this.identifier;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link CredentialTypeType }
     *     
     */
    @Nullable
    public CredentialTypeType getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link CredentialTypeType }
     *     
     */
    public void setType(
        @Nullable
        CredentialTypeType value) {
        this.type = value;
    }

    /**
     * The valid from date. The value of validFrom property represents the date and time from which the credential is valid.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getValidFrom() {
        return validFrom;
    }

    /**
     * Sets the value of the validFrom property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setValidFrom(
        @Nullable
        XMLGregorianCalendar value) {
        this.validFrom = value;
    }

    /**
     * The issued date. A verifiable credential MUST have an issuedDate property. The value represents the date and time the credential was issued. Note that this date represents the earliest date when the information associated with the credentialSubject property became valid. This is not the date of generation of the credential.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getIssued() {
        return issued;
    }

    /**
     * Sets the value of the issued property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setIssued(
        @Nullable
        XMLGregorianCalendar value) {
        this.issued = value;
    }

    /**
     * The valid until date. The value of the validUntil property  represents the date and time the credential ceases to be valid.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getValidUntil() {
        return validUntil;
    }

    /**
     * Sets the value of the validUntil property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setValidUntil(
        @Nullable
        XMLGregorianCalendar value) {
        this.validUntil = value;
    }

    /**
     * The issuer of the Europass credential. Must be an organization. It must refer to an existing organization-record in the 'agentReferences'-section.
     * 
     * @return
     *     possible object is
     *     {@link IdReferenceType }
     *     
     */
    @Nullable
    public IdReferenceType getIssuer() {
        return issuer;
    }

    /**
     * Sets the value of the issuer property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdReferenceType }
     *     
     */
    public void setIssuer(
        @Nullable
        IdReferenceType value) {
        this.issuer = value;
    }

    /**
     * Gets the value of the title property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the title property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getTitle().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageStringType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LanguageStringType> getTitle() {
        if (title == null) {
            title = new ArrayList<LanguageStringType>();
        }
        return this.title;
    }

    /**
     * Gets the value of the description property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the description property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getDescription().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getDescription() {
        if (description == null) {
            description = new ArrayList<NoteType>();
        }
        return this.description;
    }

    /**
     * Gets the value of the credentialSubject property.
     * 
     * @return
     *     possible object is
     *     {@link CredentialSubjectType }
     *     
     */
    @Nullable
    public CredentialSubjectType getCredentialSubject() {
        return credentialSubject;
    }

    /**
     * Sets the value of the credentialSubject property.
     * 
     * @param value
     *     allowed object is
     *     {@link CredentialSubjectType }
     *     
     */
    public void setCredentialSubject(
        @Nullable
        CredentialSubjectType value) {
        this.credentialSubject = value;
    }

    /**
     * Gets the value of the learningSpecificationReferences property.
     * 
     * @return
     *     possible object is
     *     {@link LearningSpecificationReferencesType }
     *     
     */
    @Nullable
    public LearningSpecificationReferencesType getLearningSpecificationReferences() {
        return learningSpecificationReferences;
    }

    /**
     * Sets the value of the learningSpecificationReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link LearningSpecificationReferencesType }
     *     
     */
    public void setLearningSpecificationReferences(
        @Nullable
        LearningSpecificationReferencesType value) {
        this.learningSpecificationReferences = value;
    }

    /**
     * Gets the value of the learningOutcomeReferences property.
     * 
     * @return
     *     possible object is
     *     {@link LearningOutcomeReferencesType }
     *     
     */
    @Nullable
    public LearningOutcomeReferencesType getLearningOutcomeReferences() {
        return learningOutcomeReferences;
    }

    /**
     * Sets the value of the learningOutcomeReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link LearningOutcomeReferencesType }
     *     
     */
    public void setLearningOutcomeReferences(
        @Nullable
        LearningOutcomeReferencesType value) {
        this.learningOutcomeReferences = value;
    }

    /**
     * Gets the value of the learningActivitySpecificationReferences property.
     * 
     * @return
     *     possible object is
     *     {@link LearningActivitySpecificationReferencesType }
     *     
     */
    @Nullable
    public LearningActivitySpecificationReferencesType getLearningActivitySpecificationReferences() {
        return learningActivitySpecificationReferences;
    }

    /**
     * Sets the value of the learningActivitySpecificationReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link LearningActivitySpecificationReferencesType }
     *     
     */
    public void setLearningActivitySpecificationReferences(
        @Nullable
        LearningActivitySpecificationReferencesType value) {
        this.learningActivitySpecificationReferences = value;
    }

    /**
     * Gets the value of the assessmentSpecificationReferences property.
     * 
     * @return
     *     possible object is
     *     {@link AssessmentSpecificationReferencesType }
     *     
     */
    @Nullable
    public AssessmentSpecificationReferencesType getAssessmentSpecificationReferences() {
        return assessmentSpecificationReferences;
    }

    /**
     * Sets the value of the assessmentSpecificationReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link AssessmentSpecificationReferencesType }
     *     
     */
    public void setAssessmentSpecificationReferences(
        @Nullable
        AssessmentSpecificationReferencesType value) {
        this.assessmentSpecificationReferences = value;
    }

    /**
     * Gets the value of the entitlementSpecificationReferences property.
     * 
     * @return
     *     possible object is
     *     {@link EntitlementSpecificationReferencesType }
     *     
     */
    @Nullable
    public EntitlementSpecificationReferencesType getEntitlementSpecificationReferences() {
        return entitlementSpecificationReferences;
    }

    /**
     * Sets the value of the entitlementSpecificationReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link EntitlementSpecificationReferencesType }
     *     
     */
    public void setEntitlementSpecificationReferences(
        @Nullable
        EntitlementSpecificationReferencesType value) {
        this.entitlementSpecificationReferences = value;
    }

    /**
     * Gets the value of the learningOpportunityReferences property.
     * 
     * @return
     *     possible object is
     *     {@link LearningOpportunityReferencesType }
     *     
     */
    @Nullable
    public LearningOpportunityReferencesType getLearningOpportunityReferences() {
        return learningOpportunityReferences;
    }

    /**
     * Sets the value of the learningOpportunityReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link LearningOpportunityReferencesType }
     *     
     */
    public void setLearningOpportunityReferences(
        @Nullable
        LearningOpportunityReferencesType value) {
        this.learningOpportunityReferences = value;
    }

    /**
     * Gets the value of the agentReferences property.
     * 
     * @return
     *     possible object is
     *     {@link AgentReferencesType }
     *     
     */
    @Nullable
    public AgentReferencesType getAgentReferences() {
        return agentReferences;
    }

    /**
     * Sets the value of the agentReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link AgentReferencesType }
     *     
     */
    public void setAgentReferences(
        @Nullable
        AgentReferencesType value) {
        this.agentReferences = value;
    }

    /**
     * Gets the value of the awardingProcessReferences property.
     * 
     * @return
     *     possible object is
     *     {@link AwardingProcessReferencesType }
     *     
     */
    @Nullable
    public AwardingProcessReferencesType getAwardingProcessReferences() {
        return awardingProcessReferences;
    }

    /**
     * Sets the value of the awardingProcessReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link AwardingProcessReferencesType }
     *     
     */
    public void setAwardingProcessReferences(
        @Nullable
        AwardingProcessReferencesType value) {
        this.awardingProcessReferences = value;
    }

    /**
     * Gets the value of the accreditationReferences property.
     * 
     * @return
     *     possible object is
     *     {@link AccreditationReferencesType }
     *     
     */
    @Nullable
    public AccreditationReferencesType getAccreditationReferences() {
        return accreditationReferences;
    }

    /**
     * Sets the value of the accreditationReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccreditationReferencesType }
     *     
     */
    public void setAccreditationReferences(
        @Nullable
        AccreditationReferencesType value) {
        this.accreditationReferences = value;
    }

    /**
     * Gets the value of the scoringSchemeReferences property.
     * 
     * @return
     *     possible object is
     *     {@link ScoringSchemeReferencesType }
     *     
     */
    @Nullable
    public ScoringSchemeReferencesType getScoringSchemeReferences() {
        return scoringSchemeReferences;
    }

    /**
     * Sets the value of the scoringSchemeReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link ScoringSchemeReferencesType }
     *     
     */
    public void setScoringSchemeReferences(
        @Nullable
        ScoringSchemeReferencesType value) {
        this.scoringSchemeReferences = value;
    }

    /**
     * Gets the value of the semanticFrameworkReferences property.
     * 
     * @return
     *     possible object is
     *     {@link FrameworkReferencesType }
     *     
     */
    @Nullable
    public FrameworkReferencesType getSemanticFrameworkReferences() {
        return semanticFrameworkReferences;
    }

    /**
     * Sets the value of the semanticFrameworkReferences property.
     * 
     * @param value
     *     allowed object is
     *     {@link FrameworkReferencesType }
     *     
     */
    public void setSemanticFrameworkReferences(
        @Nullable
        FrameworkReferencesType value) {
        this.semanticFrameworkReferences = value;
    }

    /**
     * Gets the value of the displayParameters property.
     * 
     * @return
     *     possible object is
     *     {@link DisplayParametersType }
     *     
     */
    @Nullable
    public DisplayParametersType getDisplayParameters() {
        return displayParameters;
    }

    /**
     * Sets the value of the displayParameters property.
     * 
     * @param value
     *     allowed object is
     *     {@link DisplayParametersType }
     *     
     */
    public void setDisplayParameters(
        @Nullable
        DisplayParametersType value) {
        this.displayParameters = value;
    }

    /**
     * Gets the value of the attachmentList property.
     * 
     * @return
     *     possible object is
     *     {@link AttachmentListType }
     *     
     */
    @Nullable
    public AttachmentListType getAttachmentList() {
        return attachmentList;
    }

    /**
     * Sets the value of the attachmentList property.
     * 
     * @param value
     *     allowed object is
     *     {@link AttachmentListType }
     *     
     */
    public void setAttachmentList(
        @Nullable
        AttachmentListType value) {
        this.attachmentList = value;
    }

    /**
     * Gets the value of the proof property.
     * 
     * @return
     *     possible object is
     *     {@link EuropassCredentialType.Proof }
     *     
     */
    @Nullable
    public EuropassCredentialType.Proof getProof() {
        return proof;
    }

    /**
     * Sets the value of the proof property.
     * 
     * @param value
     *     allowed object is
     *     {@link EuropassCredentialType.Proof }
     *     
     */
    public void setProof(
        @Nullable
        EuropassCredentialType.Proof value) {
        this.proof = value;
    }

    /**
     * Gets the value of the childCredentials property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the childCredentials property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getChildCredentials().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link ChildCredentialsType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ChildCredentialsType> getChildCredentials() {
        if (childCredentials == null) {
            childCredentials = new ArrayList<ChildCredentialsType>();
        }
        return this.childCredentials;
    }

    /**
     * A portable identifier of the credential.
     * 				(i.e. a urn in the uuid namespace, urn:uuid:f81d4fae-7dec-11d0-a765-00a0c91e6bf6)
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(
        @Nullable
        String value) {
        this.id = value;
    }

    /**
     * Gets the value of the xsdVersion property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getXsdVersion() {
        if (xsdVersion == null) {
            return "0.10.0";
        } else {
            return xsdVersion;
        }
    }

    /**
     * Sets the value of the xsdVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setXsdVersion(
        @Nullable
        String value) {
        this.xsdVersion = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final EuropassCredentialType rhs = ((EuropassCredentialType) o);
        if (!EqualsHelper.equals(accreditationReferences, rhs.accreditationReferences)) {
            return false;
        }
        if (!EqualsHelper.equals(agentReferences, rhs.agentReferences)) {
            return false;
        }
        if (!EqualsHelper.equals(assessmentSpecificationReferences, rhs.assessmentSpecificationReferences)) {
            return false;
        }
        if (!EqualsHelper.equals(attachmentList, rhs.attachmentList)) {
            return false;
        }
        if (!EqualsHelper.equals(awardingProcessReferences, rhs.awardingProcessReferences)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(childCredentials, rhs.childCredentials)) {
            return false;
        }
        if (!EqualsHelper.equals(credentialSubject, rhs.credentialSubject)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(displayParameters, rhs.displayParameters)) {
            return false;
        }
        if (!EqualsHelper.equals(entitlementSpecificationReferences, rhs.entitlementSpecificationReferences)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(identifier, rhs.identifier)) {
            return false;
        }
        if (!EqualsHelper.equals(issued, rhs.issued)) {
            return false;
        }
        if (!EqualsHelper.equals(issuer, rhs.issuer)) {
            return false;
        }
        if (!EqualsHelper.equals(learningActivitySpecificationReferences, rhs.learningActivitySpecificationReferences)) {
            return false;
        }
        if (!EqualsHelper.equals(learningOpportunityReferences, rhs.learningOpportunityReferences)) {
            return false;
        }
        if (!EqualsHelper.equals(learningOutcomeReferences, rhs.learningOutcomeReferences)) {
            return false;
        }
        if (!EqualsHelper.equals(learningSpecificationReferences, rhs.learningSpecificationReferences)) {
            return false;
        }
        if (!EqualsHelper.equals(proof, rhs.proof)) {
            return false;
        }
        if (!EqualsHelper.equals(scoringSchemeReferences, rhs.scoringSchemeReferences)) {
            return false;
        }
        if (!EqualsHelper.equals(semanticFrameworkReferences, rhs.semanticFrameworkReferences)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(title, rhs.title)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        if (!EqualsHelper.equals(validFrom, rhs.validFrom)) {
            return false;
        }
        if (!EqualsHelper.equals(validUntil, rhs.validUntil)) {
            return false;
        }
        if (!EqualsHelper.equals(xsdVersion, rhs.xsdVersion)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(accreditationReferences).append(agentReferences).append(assessmentSpecificationReferences).append(attachmentList).append(awardingProcessReferences).append(childCredentials).append(credentialSubject).append(description).append(displayParameters).append(entitlementSpecificationReferences).append(id).append(identifier).append(issued).append(issuer).append(learningActivitySpecificationReferences).append(learningOpportunityReferences).append(learningOutcomeReferences).append(learningSpecificationReferences).append(proof).append(scoringSchemeReferences).append(semanticFrameworkReferences).append(title).append(type).append(validFrom).append(validUntil).append(xsdVersion).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("accreditationReferences", accreditationReferences).append("agentReferences", agentReferences).append("assessmentSpecificationReferences", assessmentSpecificationReferences).append("attachmentList", attachmentList).append("awardingProcessReferences", awardingProcessReferences).append("childCredentials", childCredentials).append("credentialSubject", credentialSubject).append("description", description).append("displayParameters", displayParameters).append("entitlementSpecificationReferences", entitlementSpecificationReferences).append("id", id).append("identifier", identifier).append("issued", issued).append("issuer", issuer).append("learningActivitySpecificationReferences", learningActivitySpecificationReferences).append("learningOpportunityReferences", learningOpportunityReferences).append("learningOutcomeReferences", learningOutcomeReferences).append("learningSpecificationReferences", learningSpecificationReferences).append("proof", proof).append("scoringSchemeReferences", scoringSchemeReferences).append("semanticFrameworkReferences", semanticFrameworkReferences).append("title", title).append("type", type).append("validFrom", validFrom).append("validUntil", validUntil).append("xsdVersion", xsdVersion).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setIdentifier(
        @Nullable
        final List<IdentifierType> aList) {
        identifier = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTitle(
        @Nullable
        final List<LanguageStringType> aList) {
        title = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDescription(
        @Nullable
        final List<NoteType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setChildCredentials(
        @Nullable
        final List<ChildCredentialsType> aList) {
        childCredentials = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasIdentifierEntries() {
        return (!getIdentifier().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoIdentifierEntries() {
        return getIdentifier().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getIdentifierCount() {
        return getIdentifier().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdentifierType getIdentifierAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIdentifier().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addIdentifier(
        @Nonnull
        final IdentifierType elem) {
        getIdentifier().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTitleEntries() {
        return (!getTitle().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTitleEntries() {
        return getTitle().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTitleCount() {
        return getTitle().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LanguageStringType getTitleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTitle().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addTitle(
        @Nonnull
        final LanguageStringType elem) {
        getTitle().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addDescription(
        @Nonnull
        final NoteType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasChildCredentialsEntries() {
        return (!getChildCredentials().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoChildCredentialsEntries() {
        return getChildCredentials().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getChildCredentialsCount() {
        return getChildCredentials().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ChildCredentialsType getChildCredentialsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getChildCredentials().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addChildCredentials(
        @Nonnull
        final ChildCredentialsType elem) {
        getChildCredentials().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        EuropassCredentialType ret) {
        ret.accreditationReferences = ((accreditationReferences == null)?null:accreditationReferences.clone());
        ret.agentReferences = ((agentReferences == null)?null:agentReferences.clone());
        ret.assessmentSpecificationReferences = ((assessmentSpecificationReferences == null)?null:assessmentSpecificationReferences.clone());
        ret.attachmentList = ((attachmentList == null)?null:attachmentList.clone());
        ret.awardingProcessReferences = ((awardingProcessReferences == null)?null:awardingProcessReferences.clone());
        if (childCredentials == null) {
            ret.childCredentials = null;
        } else {
            List<ChildCredentialsType> retChildCredentials = new ArrayList<ChildCredentialsType>();
            for (ChildCredentialsType aItem: getChildCredentials()) {
                retChildCredentials.add(((aItem == null)?null:aItem.clone()));
            }
            ret.childCredentials = retChildCredentials;
        }
        ret.credentialSubject = ((credentialSubject == null)?null:credentialSubject.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<NoteType> retDescription = new ArrayList<NoteType>();
            for (NoteType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.displayParameters = ((displayParameters == null)?null:displayParameters.clone());
        ret.entitlementSpecificationReferences = ((entitlementSpecificationReferences == null)?null:entitlementSpecificationReferences.clone());
        ret.id = id;
        if (identifier == null) {
            ret.identifier = null;
        } else {
            List<IdentifierType> retIdentifier = new ArrayList<IdentifierType>();
            for (IdentifierType aItem: getIdentifier()) {
                retIdentifier.add(((aItem == null)?null:aItem.clone()));
            }
            ret.identifier = retIdentifier;
        }
        ret.issued = ((issued == null)?null:((XMLGregorianCalendar) issued.clone()));
        ret.issuer = ((issuer == null)?null:issuer.clone());
        ret.learningActivitySpecificationReferences = ((learningActivitySpecificationReferences == null)?null:learningActivitySpecificationReferences.clone());
        ret.learningOpportunityReferences = ((learningOpportunityReferences == null)?null:learningOpportunityReferences.clone());
        ret.learningOutcomeReferences = ((learningOutcomeReferences == null)?null:learningOutcomeReferences.clone());
        ret.learningSpecificationReferences = ((learningSpecificationReferences == null)?null:learningSpecificationReferences.clone());
        ret.proof = ((proof == null)?null:proof.clone());
        ret.scoringSchemeReferences = ((scoringSchemeReferences == null)?null:scoringSchemeReferences.clone());
        ret.semanticFrameworkReferences = ((semanticFrameworkReferences == null)?null:semanticFrameworkReferences.clone());
        if (title == null) {
            ret.title = null;
        } else {
            List<LanguageStringType> retTitle = new ArrayList<LanguageStringType>();
            for (LanguageStringType aItem: getTitle()) {
                retTitle.add(((aItem == null)?null:aItem.clone()));
            }
            ret.title = retTitle;
        }
        ret.type = ((type == null)?null:type.clone());
        ret.validFrom = ((validFrom == null)?null:((XMLGregorianCalendar) validFrom.clone()));
        ret.validUntil = ((validUntil == null)?null:((XMLGregorianCalendar) validUntil.clone()));
        ret.xsdVersion = xsdVersion;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public EuropassCredentialType clone() {
        EuropassCredentialType ret = new EuropassCredentialType();
        cloneTo(ret);
        return ret;
    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;extension base="{http://data.europa.eu/europass/model/credentials/w3c#}ProofType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element ref="{http://www.w3.org/2000/09/xmldsig#}Signature" minOccurs="0"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *     &amp;lt;/extension&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "signature"
    })
    @CodingStyleguideUnaware
    public static class Proof
        extends ProofType
    {

        @XmlElement(name = "Signature", namespace = "http://www.w3.org/2000/09/xmldsig#")
        private SignatureType signature;

        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public Proof() {
        }

        /**
         * Gets the value of the signature property.
         * 
         * @return
         *     possible object is
         *     {@link SignatureType }
         *     
         */
        @Nullable
        public SignatureType getSignature() {
            return signature;
        }

        /**
         * Sets the value of the signature property.
         * 
         * @param value
         *     allowed object is
         *     {@link SignatureType }
         *     
         */
        public void setSignature(
            @Nullable
            SignatureType value) {
            this.signature = value;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            if (o == this) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            final EuropassCredentialType.Proof rhs = ((EuropassCredentialType.Proof) o);
            if (!EqualsHelper.equals(signature, rhs.signature)) {
                return false;
            }
            return true;
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return HashCodeGenerator.getDerived(super.hashCode()).append(signature).getHashCode();
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-tostring
         * 
         */
        @Override
        public String toString() {
            return ToStringGenerator.getDerived(super.toString()).append("signature", signature).getToString();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            EuropassCredentialType.Proof ret) {
            super.cloneTo(ret);
            ret.signature = ((signature == null)?null:signature.clone());
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public EuropassCredentialType.Proof clone() {
            EuropassCredentialType.Proof ret = new EuropassCredentialType.Proof();
            cloneTo(ret);
            return ret;
        }

    }

}
