
package eu.europa.data.europass.model.credentials_;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * A public accessible web document.
 * 
 * &lt;p&gt;Java class for DocumentType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="DocumentType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="title" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="language" maxOccurs="unbounded" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;complexContent&amp;gt;
 *               &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
 *                 &amp;lt;sequence&amp;gt;
 *                   &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *                   &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *                   &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *                 &amp;lt;/sequence&amp;gt;
 *                 &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}LanguageEnumType" /&amp;gt;
 *                 &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *                 &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *                 &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
 *                 &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
 *               &amp;lt;/restriction&amp;gt;
 *             &amp;lt;/complexContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *         &amp;lt;element name="subject" maxOccurs="unbounded" minOccurs="0"&amp;gt;
 *           &amp;lt;complexType&amp;gt;
 *             &amp;lt;complexContent&amp;gt;
 *               &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
 *                 &amp;lt;sequence&amp;gt;
 *                   &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *                   &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *                   &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *                 &amp;lt;/sequence&amp;gt;
 *                 &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}SubjectTypeCodeEnumType" /&amp;gt;
 *                 &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *                 &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *                 &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
 *                 &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
 *                 &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
 *               &amp;lt;/restriction&amp;gt;
 *             &amp;lt;/complexContent&amp;gt;
 *           &amp;lt;/complexType&amp;gt;
 *         &amp;lt;/element&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *       &amp;lt;attribute name="uri" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DocumentType", propOrder = {
    "title",
    "language",
    "subject"
})
@CodingStyleguideUnaware
public class DocumentType implements IExplicitlyCloneable
{

    private List<LanguageStringType> title;
    private List<DocumentType.Language> language;
    private List<DocumentType.Subject> subject;
    @XmlAttribute(name = "uri", required = true)
    private String uri;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public DocumentType() {
    }

    /**
     * Gets the value of the title property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the title property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getTitle().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageStringType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LanguageStringType> getTitle() {
        if (title == null) {
            title = new ArrayList<LanguageStringType>();
        }
        return this.title;
    }

    /**
     * Gets the value of the language property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the language property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getLanguage().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentType.Language }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentType.Language> getLanguage() {
        if (language == null) {
            language = new ArrayList<DocumentType.Language>();
        }
        return this.language;
    }

    /**
     * Gets the value of the subject property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the subject property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getSubject().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentType.Subject }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentType.Subject> getSubject() {
        if (subject == null) {
            subject = new ArrayList<DocumentType.Subject>();
        }
        return this.subject;
    }

    /**
     * Gets the value of the uri property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getUri() {
        return uri;
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUri(
        @Nullable
        String value) {
        this.uri = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DocumentType rhs = ((DocumentType) o);
        if (!EqualsHelper.equalsCollection(language, rhs.language)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(subject, rhs.subject)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(title, rhs.title)) {
            return false;
        }
        if (!EqualsHelper.equals(uri, rhs.uri)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(language).append(subject).append(title).append(uri).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("language", language).append("subject", subject).append("title", title).append("uri", uri).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTitle(
        @Nullable
        final List<LanguageStringType> aList) {
        title = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setLanguage(
        @Nullable
        final List<DocumentType.Language> aList) {
        language = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setSubject(
        @Nullable
        final List<DocumentType.Subject> aList) {
        subject = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTitleEntries() {
        return (!getTitle().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTitleEntries() {
        return getTitle().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTitleCount() {
        return getTitle().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LanguageStringType getTitleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTitle().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addTitle(
        @Nonnull
        final LanguageStringType elem) {
        getTitle().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasLanguageEntries() {
        return (!getLanguage().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoLanguageEntries() {
        return getLanguage().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getLanguageCount() {
        return getLanguage().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentType.Language getLanguageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLanguage().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addLanguage(
        @Nonnull
        final DocumentType.Language elem) {
        getLanguage().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasSubjectEntries() {
        return (!getSubject().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoSubjectEntries() {
        return getSubject().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getSubjectCount() {
        return getSubject().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentType.Subject getSubjectAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSubject().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addSubject(
        @Nonnull
        final DocumentType.Subject elem) {
        getSubject().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        DocumentType ret) {
        if (language == null) {
            ret.language = null;
        } else {
            List<DocumentType.Language> retLanguage = new ArrayList<DocumentType.Language>();
            for (DocumentType.Language aItem: getLanguage()) {
                retLanguage.add(((aItem == null)?null:aItem.clone()));
            }
            ret.language = retLanguage;
        }
        if (subject == null) {
            ret.subject = null;
        } else {
            List<DocumentType.Subject> retSubject = new ArrayList<DocumentType.Subject>();
            for (DocumentType.Subject aItem: getSubject()) {
                retSubject.add(((aItem == null)?null:aItem.clone()));
            }
            ret.subject = retSubject;
        }
        if (title == null) {
            ret.title = null;
        } else {
            List<LanguageStringType> retTitle = new ArrayList<LanguageStringType>();
            for (LanguageStringType aItem: getTitle()) {
                retTitle.add(((aItem == null)?null:aItem.clone()));
            }
            ret.title = retTitle;
        }
        ret.uri = uri;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DocumentType clone() {
        DocumentType ret = new DocumentType();
        cloneTo(ret);
        return ret;
    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}LanguageEnumType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class Language
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public Language() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            DocumentType.Language ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public DocumentType.Language clone() {
            DocumentType.Language ret = new DocumentType.Language();
            cloneTo(ret);
            return ret;
        }

    }


    /**
     * &lt;p&gt;Java class for anonymous complex type.
     * 
     * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
     * 
     * &lt;pre&gt;
     * &amp;lt;complexType&amp;gt;
     *   &amp;lt;complexContent&amp;gt;
     *     &amp;lt;restriction base="{http://data.europa.eu/europass/model/credentials#}CodeType"&amp;gt;
     *       &amp;lt;sequence&amp;gt;
     *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
     *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
     *       &amp;lt;/sequence&amp;gt;
     *       &amp;lt;attribute name="uri" type="{http://data.europa.eu/europass/model/credentials#}SubjectTypeCodeEnumType" /&amp;gt;
     *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
     *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
     *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkID" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
     *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
     *     &amp;lt;/restriction&amp;gt;
     *   &amp;lt;/complexContent&amp;gt;
     * &amp;lt;/complexType&amp;gt;
     * &lt;/pre&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
     * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    @CodingStyleguideUnaware
    public static class Subject
        extends CodeType
    {


        /**
         * Default constructor&lt;br&gt;
         * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
         * 
         */
        public Subject() {
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public boolean equals(final Object o) {
            return super.equals(o);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-equalshashcode
         * 
         */
        @Override
        public int hashCode() {
            return super.hashCode();
        }

        /**
         * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @param ret
         *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
         */
        public void cloneTo(
            @Nonnull
            DocumentType.Subject ret) {
            super.cloneTo(ret);
        }

        /**
         * Created by ph-jaxb22-plugin -Xph-cloneable2
         * 
         * @return
         *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
         */
        @Nonnull
        @ReturnsMutableCopy
        @Override
        public DocumentType.Subject clone() {
            DocumentType.Subject ret = new DocumentType.Subject();
            cloneTo(ret);
            return ret;
        }

    }

}
