
package eu.europa.data.europass.model.credentials_;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;


/**
 * &lt;p&gt;Java class for CredentialSubjectType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="CredentialSubjectType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;extension base="{http://data.europa.eu/europass/model/credentials#}PersonType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="achievements" type="{http://data.europa.eu/europass/model/credentials#}AchievementsType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="activities" type="{http://data.europa.eu/europass/model/credentials#}ActivitiesType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="entitlements" type="{http://data.europa.eu/europass/model/credentials#}EntitlementsType" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/extension&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CredentialSubjectType", propOrder = {
    "achievements",
    "activities",
    "entitlements"
})
@CodingStyleguideUnaware
public class CredentialSubjectType
    extends PersonType
{

    private AchievementsType achievements;
    private ActivitiesType activities;
    private EntitlementsType entitlements;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CredentialSubjectType() {
    }

    /**
     * Gets the value of the achievements property.
     * 
     * @return
     *     possible object is
     *     {@link AchievementsType }
     *     
     */
    @Nullable
    public AchievementsType getAchievements() {
        return achievements;
    }

    /**
     * Sets the value of the achievements property.
     * 
     * @param value
     *     allowed object is
     *     {@link AchievementsType }
     *     
     */
    public void setAchievements(
        @Nullable
        AchievementsType value) {
        this.achievements = value;
    }

    /**
     * Gets the value of the activities property.
     * 
     * @return
     *     possible object is
     *     {@link ActivitiesType }
     *     
     */
    @Nullable
    public ActivitiesType getActivities() {
        return activities;
    }

    /**
     * Sets the value of the activities property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActivitiesType }
     *     
     */
    public void setActivities(
        @Nullable
        ActivitiesType value) {
        this.activities = value;
    }

    /**
     * Gets the value of the entitlements property.
     * 
     * @return
     *     possible object is
     *     {@link EntitlementsType }
     *     
     */
    @Nullable
    public EntitlementsType getEntitlements() {
        return entitlements;
    }

    /**
     * Sets the value of the entitlements property.
     * 
     * @param value
     *     allowed object is
     *     {@link EntitlementsType }
     *     
     */
    public void setEntitlements(
        @Nullable
        EntitlementsType value) {
        this.entitlements = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final CredentialSubjectType rhs = ((CredentialSubjectType) o);
        if (!EqualsHelper.equals(achievements, rhs.achievements)) {
            return false;
        }
        if (!EqualsHelper.equals(activities, rhs.activities)) {
            return false;
        }
        if (!EqualsHelper.equals(entitlements, rhs.entitlements)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(achievements).append(activities).append(entitlements).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("achievements", achievements).append("activities", activities).append("entitlements", entitlements).getToString();
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        CredentialSubjectType ret) {
        super.cloneTo(ret);
        ret.achievements = ((achievements == null)?null:achievements.clone());
        ret.activities = ((activities == null)?null:activities.clone());
        ret.entitlements = ((entitlements == null)?null:entitlements.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CredentialSubjectType clone() {
        CredentialSubjectType ret = new CredentialSubjectType();
        cloneTo(ret);
        return ret;
    }

}
