
package eu.europa.data.europass.model.credentials_;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * 
 *                 A term from a controlled vocabulary. 
 *                 
 *                 A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
 *                 It represents a definitive value, a method, or a property description in an abbreviated or language-independent form that is part of a finite list of allowed values.
 *                 The CodeType is used for all elements that are used to enable a common coded value representation. Typical example of code types are: Country Code and Language Code.
 *                 The CodeType should be used in case of a finite list of allowed values. The IdentifierType should be used in case of an infinite set of objects.
 *                 
 *                 This CodeType is a generic data type which is also used to represent association objects.
 *             
 * 
 * &lt;p&gt;Java class for CodeType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="CodeType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="targetName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *         &amp;lt;element name="targetDescription" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="targetFrameworkName" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *       &amp;lt;attribute name="uri" type="{http://www.w3.org/2001/XMLSchema}anySimpleType" /&amp;gt;
 *       &amp;lt;attribute name="targetID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *       &amp;lt;attribute name="type" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *       &amp;lt;attribute name="description" type="{http://www.w3.org/2001/XMLSchema}normalizedString" /&amp;gt;
 *       &amp;lt;attribute name="targetNotation" type="{http://www.w3.org/2001/XMLSchema}token" /&amp;gt;
 *       &amp;lt;attribute name="targetFrameworkID" type="{http://www.w3.org/2001/XMLSchema}anyURI" /&amp;gt;
 *       &amp;lt;attribute name="targetFrameworkUrl" use="required" type="{http://data.europa.eu/europass/model/credentials#}DocumentURLType" /&amp;gt;
 *       &amp;lt;attribute name="targetFrameworkSpatialID" type="{http://data.europa.eu/europass/model/credentials#}LocationCodeContentType" /&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CodeType", propOrder = {
    "targetName",
    "targetDescription",
    "targetFrameworkName"
})
@XmlSeeAlso({
    eu.europa.data.europass.model.credentials_.DocumentType.Language.class,
    eu.europa.data.europass.model.credentials_.DocumentType.Subject.class,
    eu.europa.data.europass.model.credentials_.LocationType.SpatialCode.class,
    eu.europa.data.europass.model.credentials_.SpatialCodeLocationType.SpatialCode.class,
    eu.europa.data.europass.model.credentials_.AddressType.Country.class,
    eu.europa.data.europass.model.credentials_.MediaObjectType.ContentType.class,
    eu.europa.data.europass.model.credentials_.MediaObjectType.ContentEncoding.class,
    eu.europa.data.europass.model.credentials_.ImageObjectType.ContentType.class,
    eu.europa.data.europass.model.credentials_.ImageObjectType.ContentEncoding.class,
    PersonGenderCodeType.class,
    PersonCountryCodeType.class,
    eu.europa.data.europass.model.credentials_.OrganizationType.Type.class,
    AccreditationTypeCodeType.class,
    eu.europa.data.europass.model.credentials_.AccreditationType.LimitField.class,
    eu.europa.data.europass.model.credentials_.AccreditationType.LimitEQFLevel.class,
    eu.europa.data.europass.model.credentials_.AccreditationType.LimitJurisdiction.class,
    eu.europa.data.europass.model.credentials_.LearningOpportunityType.LearningSchedule.class,
    eu.europa.data.europass.model.credentials_.LearningActivitySpecificationType.Type.class,
    eu.europa.data.europass.model.credentials_.LearningActivitySpecificationType.Language.class,
    eu.europa.data.europass.model.credentials_.LearningActivitySpecificationType.Mode.class,
    eu.europa.data.europass.model.credentials_.AssessmentSpecificationType.Type.class,
    eu.europa.data.europass.model.credentials_.AssessmentSpecificationType.Language.class,
    eu.europa.data.europass.model.credentials_.AssessmentSpecificationType.Mode.class,
    eu.europa.data.europass.model.credentials_.QualificationType.Type.class,
    eu.europa.data.europass.model.credentials_.QualificationType.HasISCEDFCode.class,
    eu.europa.data.europass.model.credentials_.QualificationType.HasEducationSubject.class,
    eu.europa.data.europass.model.credentials_.QualificationType.HasEducationLevel.class,
    eu.europa.data.europass.model.credentials_.QualificationType.Language.class,
    eu.europa.data.europass.model.credentials_.QualificationType.Mode.class,
    eu.europa.data.europass.model.credentials_.QualificationType.LearningSettingType.class,
    eu.europa.data.europass.model.credentials_.QualificationType.TargetGroup.class,
    eu.europa.data.europass.model.credentials_.QualificationType.EqfLevel.class,
    eu.europa.data.europass.model.credentials_.QualificationType.NqfLevel.class,
    eu.europa.data.europass.model.credentials_.QualificationType.QualificationCode.class,
    LearningOutcomeTypeCodeType.class,
    eu.europa.data.europass.model.credentials_.LearningOutcomeType.ReusabilityLevel.class,
    eu.europa.data.europass.model.credentials_.LearningOutcomeType.RelatedEscoSkill.class,
    eu.europa.data.europass.model.credentials_.AwardingOpportunityType.Location.class,
    eu.europa.data.europass.model.credentials_.EntitlementSpecificationType.Type.class,
    eu.europa.data.europass.model.credentials_.EntitlementSpecificationType.Status.class,
    eu.europa.data.europass.model.credentials_.EntitlementSpecificationType.LimitJurisdiction.class,
    eu.europa.data.europass.model.credentials_.EntitlementSpecificationType.LimitOccupation.class,
    eu.europa.data.europass.model.credentials_.EntitlementSpecificationType.LimitNationalOccupation.class,
    eu.europa.data.europass.model.credentials_.AgentType.Type.class,
    eu.europa.data.europass.model.credentials_.AssessmentType.IdVerificationMethod.class
})
@CodingStyleguideUnaware
public class CodeType implements IExplicitlyCloneable
{

    @XmlElement(required = true)
    private List<LanguageStringType> targetName;
    private List<NoteType> targetDescription;
    @XmlElement(required = true)
    private List<LanguageStringType> targetFrameworkName;
    @XmlAttribute(name = "uri")
    @XmlSchemaType(name = "anySimpleType")
    private String uri;
    @XmlAttribute(name = "targetID")
    @XmlSchemaType(name = "anyURI")
    private String targetID;
    @XmlAttribute(name = "type")
    @XmlSchemaType(name = "anyURI")
    private String type;
    @XmlAttribute(name = "description")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String description;
    @XmlAttribute(name = "targetNotation")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    private String targetNotation;
    @XmlAttribute(name = "targetFrameworkID")
    @XmlSchemaType(name = "anyURI")
    private String targetFrameworkID;
    @XmlAttribute(name = "targetFrameworkUrl", required = true)
    private String targetFrameworkUrl;
    @XmlAttribute(name = "targetFrameworkSpatialID")
    private String targetFrameworkSpatialID;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CodeType() {
    }

    /**
     * Gets the value of the targetName property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the targetName property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getTargetName().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageStringType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LanguageStringType> getTargetName() {
        if (targetName == null) {
            targetName = new ArrayList<LanguageStringType>();
        }
        return this.targetName;
    }

    /**
     * Gets the value of the targetDescription property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the targetDescription property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getTargetDescription().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getTargetDescription() {
        if (targetDescription == null) {
            targetDescription = new ArrayList<NoteType>();
        }
        return this.targetDescription;
    }

    /**
     * Gets the value of the targetFrameworkName property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the targetFrameworkName property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getTargetFrameworkName().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageStringType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LanguageStringType> getTargetFrameworkName() {
        if (targetFrameworkName == null) {
            targetFrameworkName = new ArrayList<LanguageStringType>();
        }
        return this.targetFrameworkName;
    }

    /**
     * Gets the value of the uri property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getUri() {
        return uri;
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUri(
        @Nullable
        String value) {
        this.uri = value;
    }

    /**
     * Gets the value of the targetID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getTargetID() {
        return targetID;
    }

    /**
     * Sets the value of the targetID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetID(
        @Nullable
        String value) {
        this.targetID = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setType(
        @Nullable
        String value) {
        this.type = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(
        @Nullable
        String value) {
        this.description = value;
    }

    /**
     * Gets the value of the targetNotation property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getTargetNotation() {
        return targetNotation;
    }

    /**
     * Sets the value of the targetNotation property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetNotation(
        @Nullable
        String value) {
        this.targetNotation = value;
    }

    /**
     * Gets the value of the targetFrameworkID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getTargetFrameworkID() {
        return targetFrameworkID;
    }

    /**
     * Sets the value of the targetFrameworkID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetFrameworkID(
        @Nullable
        String value) {
        this.targetFrameworkID = value;
    }

    /**
     * Gets the value of the targetFrameworkUrl property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getTargetFrameworkUrl() {
        return targetFrameworkUrl;
    }

    /**
     * Sets the value of the targetFrameworkUrl property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetFrameworkUrl(
        @Nullable
        String value) {
        this.targetFrameworkUrl = value;
    }

    /**
     * Gets the value of the targetFrameworkSpatialID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getTargetFrameworkSpatialID() {
        return targetFrameworkSpatialID;
    }

    /**
     * Sets the value of the targetFrameworkSpatialID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTargetFrameworkSpatialID(
        @Nullable
        String value) {
        this.targetFrameworkSpatialID = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CodeType rhs = ((CodeType) o);
        if (!EqualsHelper.equals(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(targetDescription, rhs.targetDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(targetFrameworkID, rhs.targetFrameworkID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(targetFrameworkName, rhs.targetFrameworkName)) {
            return false;
        }
        if (!EqualsHelper.equals(targetFrameworkSpatialID, rhs.targetFrameworkSpatialID)) {
            return false;
        }
        if (!EqualsHelper.equals(targetFrameworkUrl, rhs.targetFrameworkUrl)) {
            return false;
        }
        if (!EqualsHelper.equals(targetID, rhs.targetID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(targetName, rhs.targetName)) {
            return false;
        }
        if (!EqualsHelper.equals(targetNotation, rhs.targetNotation)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        if (!EqualsHelper.equals(uri, rhs.uri)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(description).append(targetDescription).append(targetFrameworkID).append(targetFrameworkName).append(targetFrameworkSpatialID).append(targetFrameworkUrl).append(targetID).append(targetName).append(targetNotation).append(type).append(uri).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("description", description).append("targetDescription", targetDescription).append("targetFrameworkID", targetFrameworkID).append("targetFrameworkName", targetFrameworkName).append("targetFrameworkSpatialID", targetFrameworkSpatialID).append("targetFrameworkUrl", targetFrameworkUrl).append("targetID", targetID).append("targetName", targetName).append("targetNotation", targetNotation).append("type", type).append("uri", uri).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTargetName(
        @Nullable
        final List<LanguageStringType> aList) {
        targetName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTargetDescription(
        @Nullable
        final List<NoteType> aList) {
        targetDescription = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTargetFrameworkName(
        @Nullable
        final List<LanguageStringType> aList) {
        targetFrameworkName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTargetNameEntries() {
        return (!getTargetName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTargetNameEntries() {
        return getTargetName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTargetNameCount() {
        return getTargetName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LanguageStringType getTargetNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTargetName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addTargetName(
        @Nonnull
        final LanguageStringType elem) {
        getTargetName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTargetDescriptionEntries() {
        return (!getTargetDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTargetDescriptionEntries() {
        return getTargetDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTargetDescriptionCount() {
        return getTargetDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getTargetDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTargetDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addTargetDescription(
        @Nonnull
        final NoteType elem) {
        getTargetDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTargetFrameworkNameEntries() {
        return (!getTargetFrameworkName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTargetFrameworkNameEntries() {
        return getTargetFrameworkName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTargetFrameworkNameCount() {
        return getTargetFrameworkName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LanguageStringType getTargetFrameworkNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTargetFrameworkName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addTargetFrameworkName(
        @Nonnull
        final LanguageStringType elem) {
        getTargetFrameworkName().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        CodeType ret) {
        ret.description = description;
        if (targetDescription == null) {
            ret.targetDescription = null;
        } else {
            List<NoteType> retTargetDescription = new ArrayList<NoteType>();
            for (NoteType aItem: getTargetDescription()) {
                retTargetDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.targetDescription = retTargetDescription;
        }
        ret.targetFrameworkID = targetFrameworkID;
        if (targetFrameworkName == null) {
            ret.targetFrameworkName = null;
        } else {
            List<LanguageStringType> retTargetFrameworkName = new ArrayList<LanguageStringType>();
            for (LanguageStringType aItem: getTargetFrameworkName()) {
                retTargetFrameworkName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.targetFrameworkName = retTargetFrameworkName;
        }
        ret.targetFrameworkSpatialID = targetFrameworkSpatialID;
        ret.targetFrameworkUrl = targetFrameworkUrl;
        ret.targetID = targetID;
        if (targetName == null) {
            ret.targetName = null;
        } else {
            List<LanguageStringType> retTargetName = new ArrayList<LanguageStringType>();
            for (LanguageStringType aItem: getTargetName()) {
                retTargetName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.targetName = retTargetName;
        }
        ret.targetNotation = targetNotation;
        ret.type = type;
        ret.uri = uri;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CodeType clone() {
        CodeType ret = new CodeType();
        cloneTo(ret);
        return ret;
    }

}
