
package eu.europa.data.europass.model.credentials_;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * An awarding process represents the activity of awarding a LearningSpecification (e.g a qualification) to an individual resulting in a personal LearningAchievement. It is used to specify the organization that awarded the LearningSpecification to the individual, the country or region where the LearningSpecification was awarded, and optionally the date of awarding.
 * 
 * &lt;p&gt;Java class for AwardingProcessType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="AwardingProcessType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="identifier" type="{http://data.europa.eu/europass/model/credentials#}IdentifierType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="description" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="additionalNote" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="used" type="{http://data.europa.eu/europass/model/credentials#}AssessmentType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="learningAchievement" type="{http://data.europa.eu/europass/model/credentials#}RestrictedAchievementsType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="awardingBody" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType" maxOccurs="unbounded"/&amp;gt;
 *         &amp;lt;element name="location" type="{http://data.europa.eu/europass/model/credentials#}LocationType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="date" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *       &amp;lt;attribute name="id" use="required" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AwardingProcessType", propOrder = {
    "identifier",
    "description",
    "additionalNote",
    "used",
    "learningAchievement",
    "awardingBody",
    "location",
    "date"
})
@CodingStyleguideUnaware
public class AwardingProcessType implements IExplicitlyCloneable
{

    private List<IdentifierType> identifier;
    private List<NoteType> description;
    private List<NoteType> additionalNote;
    private List<AssessmentType> used;
    private List<RestrictedAchievementsType> learningAchievement;
    @XmlElement(required = true)
    private List<IdReferenceType> awardingBody;
    private LocationType location;
    @XmlSchemaType(name = "dateTime")
    private XMLGregorianCalendar date;
    @XmlAttribute(name = "id", required = true)
    private String id;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public AwardingProcessType() {
    }

    /**
     * Gets the value of the identifier property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the identifier property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getIdentifier().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdentifierType> getIdentifier() {
        if (identifier == null) {
            identifier = new ArrayList<IdentifierType>();
        }
        return this.identifier;
    }

    /**
     * Gets the value of the description property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the description property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getDescription().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getDescription() {
        if (description == null) {
            description = new ArrayList<NoteType>();
        }
        return this.description;
    }

    /**
     * Gets the value of the additionalNote property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the additionalNote property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getAdditionalNote().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getAdditionalNote() {
        if (additionalNote == null) {
            additionalNote = new ArrayList<NoteType>();
        }
        return this.additionalNote;
    }

    /**
     * Gets the value of the used property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the used property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getUsed().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link AssessmentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AssessmentType> getUsed() {
        if (used == null) {
            used = new ArrayList<AssessmentType>();
        }
        return this.used;
    }

    /**
     * Gets the value of the learningAchievement property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the learningAchievement property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getLearningAchievement().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link RestrictedAchievementsType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RestrictedAchievementsType> getLearningAchievement() {
        if (learningAchievement == null) {
            learningAchievement = new ArrayList<RestrictedAchievementsType>();
        }
        return this.learningAchievement;
    }

    /**
     * Gets the value of the awardingBody property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the awardingBody property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getAwardingBody().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdReferenceType> getAwardingBody() {
        if (awardingBody == null) {
            awardingBody = new ArrayList<IdReferenceType>();
        }
        return this.awardingBody;
    }

    /**
     * Gets the value of the location property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getLocation() {
        return location;
    }

    /**
     * Sets the value of the location property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setLocation(
        @Nullable
        LocationType value) {
        this.location = value;
    }

    /**
     * Gets the value of the date property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getDate() {
        return date;
    }

    /**
     * Sets the value of the date property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setDate(
        @Nullable
        XMLGregorianCalendar value) {
        this.date = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(
        @Nullable
        String value) {
        this.id = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final AwardingProcessType rhs = ((AwardingProcessType) o);
        if (!EqualsHelper.equalsCollection(additionalNote, rhs.additionalNote)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(awardingBody, rhs.awardingBody)) {
            return false;
        }
        if (!EqualsHelper.equals(date, rhs.date)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(identifier, rhs.identifier)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(learningAchievement, rhs.learningAchievement)) {
            return false;
        }
        if (!EqualsHelper.equals(location, rhs.location)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(used, rhs.used)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalNote).append(awardingBody).append(date).append(description).append(id).append(identifier).append(learningAchievement).append(location).append(used).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalNote", additionalNote).append("awardingBody", awardingBody).append("date", date).append("description", description).append("id", id).append("identifier", identifier).append("learningAchievement", learningAchievement).append("location", location).append("used", used).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setIdentifier(
        @Nullable
        final List<IdentifierType> aList) {
        identifier = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDescription(
        @Nullable
        final List<NoteType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setAdditionalNote(
        @Nullable
        final List<NoteType> aList) {
        additionalNote = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setUsed(
        @Nullable
        final List<AssessmentType> aList) {
        used = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setLearningAchievement(
        @Nullable
        final List<RestrictedAchievementsType> aList) {
        learningAchievement = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setAwardingBody(
        @Nullable
        final List<IdReferenceType> aList) {
        awardingBody = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasIdentifierEntries() {
        return (!getIdentifier().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoIdentifierEntries() {
        return getIdentifier().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getIdentifierCount() {
        return getIdentifier().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdentifierType getIdentifierAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIdentifier().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addIdentifier(
        @Nonnull
        final IdentifierType elem) {
        getIdentifier().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addDescription(
        @Nonnull
        final NoteType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasAdditionalNoteEntries() {
        return (!getAdditionalNote().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoAdditionalNoteEntries() {
        return getAdditionalNote().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getAdditionalNoteCount() {
        return getAdditionalNote().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getAdditionalNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalNote().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addAdditionalNote(
        @Nonnull
        final NoteType elem) {
        getAdditionalNote().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasUsedEntries() {
        return (!getUsed().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoUsedEntries() {
        return getUsed().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getUsedCount() {
        return getUsed().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AssessmentType getUsedAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUsed().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addUsed(
        @Nonnull
        final AssessmentType elem) {
        getUsed().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasLearningAchievementEntries() {
        return (!getLearningAchievement().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoLearningAchievementEntries() {
        return getLearningAchievement().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getLearningAchievementCount() {
        return getLearningAchievement().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RestrictedAchievementsType getLearningAchievementAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLearningAchievement().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addLearningAchievement(
        @Nonnull
        final RestrictedAchievementsType elem) {
        getLearningAchievement().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasAwardingBodyEntries() {
        return (!getAwardingBody().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoAwardingBodyEntries() {
        return getAwardingBody().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getAwardingBodyCount() {
        return getAwardingBody().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdReferenceType getAwardingBodyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAwardingBody().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addAwardingBody(
        @Nonnull
        final IdReferenceType elem) {
        getAwardingBody().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        AwardingProcessType ret) {
        if (additionalNote == null) {
            ret.additionalNote = null;
        } else {
            List<NoteType> retAdditionalNote = new ArrayList<NoteType>();
            for (NoteType aItem: getAdditionalNote()) {
                retAdditionalNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalNote = retAdditionalNote;
        }
        if (awardingBody == null) {
            ret.awardingBody = null;
        } else {
            List<IdReferenceType> retAwardingBody = new ArrayList<IdReferenceType>();
            for (IdReferenceType aItem: getAwardingBody()) {
                retAwardingBody.add(((aItem == null)?null:aItem.clone()));
            }
            ret.awardingBody = retAwardingBody;
        }
        ret.date = ((date == null)?null:((XMLGregorianCalendar) date.clone()));
        if (description == null) {
            ret.description = null;
        } else {
            List<NoteType> retDescription = new ArrayList<NoteType>();
            for (NoteType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.id = id;
        if (identifier == null) {
            ret.identifier = null;
        } else {
            List<IdentifierType> retIdentifier = new ArrayList<IdentifierType>();
            for (IdentifierType aItem: getIdentifier()) {
                retIdentifier.add(((aItem == null)?null:aItem.clone()));
            }
            ret.identifier = retIdentifier;
        }
        if (learningAchievement == null) {
            ret.learningAchievement = null;
        } else {
            List<RestrictedAchievementsType> retLearningAchievement = new ArrayList<RestrictedAchievementsType>();
            for (RestrictedAchievementsType aItem: getLearningAchievement()) {
                retLearningAchievement.add(((aItem == null)?null:aItem.clone()));
            }
            ret.learningAchievement = retLearningAchievement;
        }
        ret.location = ((location == null)?null:location.clone());
        if (used == null) {
            ret.used = null;
        } else {
            List<AssessmentType> retUsed = new ArrayList<AssessmentType>();
            for (AssessmentType aItem: getUsed()) {
                retUsed.add(((aItem == null)?null:aItem.clone()));
            }
            ret.used = retUsed;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public AwardingProcessType clone() {
        AwardingProcessType ret = new AwardingProcessType();
        cloneTo(ret);
        return ret;
    }

}
