
package eu.europa.data.europass.model.credentials_;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * Any process which leads to the acquisition of knowledge, skills or responsibility and autonomy. Activities are used to represent any learning activity of an individual in a formal or non formal setting (e.g. attending an educational- or training program, a course, a working or practising activity). Typically the learning activity leads or contributes to an achievement after a formal and/or informal assessment procedure. The achievement is typically the result of a formal and/or informal assessment process during or after a learning activity.
 * 
 * &lt;p&gt;Java class for ActivityType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="ActivityType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="identifier" type="{http://data.europa.eu/europass/model/credentials#}IdentifierType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="title" type="{http://data.europa.eu/europass/model/credentials#}LanguageStringType" maxOccurs="unbounded"/&amp;gt;
 *         &amp;lt;element name="description" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="additionalNote" type="{http://data.europa.eu/europass/model/credentials#}NoteType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="workload" type="{http://www.w3.org/2001/XMLSchema}duration" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="startedAtTime" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="endedAtTime" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="directedBy" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="location" type="{http://data.europa.eu/europass/model/credentials#}LocationType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="specifiedBy" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="usedLearningOpportunity" type="{http://data.europa.eu/europass/model/credentials#}IdReferenceType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="influenced" type="{http://data.europa.eu/europass/model/credentials#}RestrictedAchievementsType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="hasPart" type="{http://data.europa.eu/europass/model/credentials#}ActivityType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *       &amp;lt;attribute name="id" use="required" type="{http://data.europa.eu/europass/model/credentials#}IdType" /&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ActivityType", propOrder = {
    "identifier",
    "title",
    "description",
    "additionalNote",
    "workload",
    "startedAtTime",
    "endedAtTime",
    "directedBy",
    "location",
    "specifiedBy",
    "usedLearningOpportunity",
    "influenced",
    "hasPart"
})
@CodingStyleguideUnaware
public class ActivityType implements IExplicitlyCloneable
{

    private List<IdentifierType> identifier;
    @XmlElement(required = true)
    private List<LanguageStringType> title;
    private List<NoteType> description;
    private List<NoteType> additionalNote;
    private Duration workload;
    @XmlSchemaType(name = "dateTime")
    private XMLGregorianCalendar startedAtTime;
    @XmlSchemaType(name = "dateTime")
    private XMLGregorianCalendar endedAtTime;
    private List<IdReferenceType> directedBy;
    private List<LocationType> location;
    private IdReferenceType specifiedBy;
    private IdReferenceType usedLearningOpportunity;
    private List<RestrictedAchievementsType> influenced;
    private List<ActivityType> hasPart;
    @XmlAttribute(name = "id", required = true)
    private String id;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ActivityType() {
    }

    /**
     * Gets the value of the identifier property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the identifier property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getIdentifier().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdentifierType> getIdentifier() {
        if (identifier == null) {
            identifier = new ArrayList<IdentifierType>();
        }
        return this.identifier;
    }

    /**
     * Gets the value of the title property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the title property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getTitle().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageStringType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LanguageStringType> getTitle() {
        if (title == null) {
            title = new ArrayList<LanguageStringType>();
        }
        return this.title;
    }

    /**
     * Gets the value of the description property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the description property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getDescription().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getDescription() {
        if (description == null) {
            description = new ArrayList<NoteType>();
        }
        return this.description;
    }

    /**
     * Gets the value of the additionalNote property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the additionalNote property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getAdditionalNote().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getAdditionalNote() {
        if (additionalNote == null) {
            additionalNote = new ArrayList<NoteType>();
        }
        return this.additionalNote;
    }

    /**
     * Gets the value of the workload property.
     * 
     * @return
     *     possible object is
     *     {@link Duration }
     *     
     */
    @Nullable
    public Duration getWorkload() {
        return workload;
    }

    /**
     * Sets the value of the workload property.
     * 
     * @param value
     *     allowed object is
     *     {@link Duration }
     *     
     */
    public void setWorkload(
        @Nullable
        Duration value) {
        this.workload = value;
    }

    /**
     * Gets the value of the startedAtTime property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getStartedAtTime() {
        return startedAtTime;
    }

    /**
     * Sets the value of the startedAtTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setStartedAtTime(
        @Nullable
        XMLGregorianCalendar value) {
        this.startedAtTime = value;
    }

    /**
     * Gets the value of the endedAtTime property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getEndedAtTime() {
        return endedAtTime;
    }

    /**
     * Sets the value of the endedAtTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEndedAtTime(
        @Nullable
        XMLGregorianCalendar value) {
        this.endedAtTime = value;
    }

    /**
     * Gets the value of the directedBy property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the directedBy property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getDirectedBy().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link IdReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdReferenceType> getDirectedBy() {
        if (directedBy == null) {
            directedBy = new ArrayList<IdReferenceType>();
        }
        return this.directedBy;
    }

    /**
     * Gets the value of the location property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the location property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getLocation().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LocationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LocationType> getLocation() {
        if (location == null) {
            location = new ArrayList<LocationType>();
        }
        return this.location;
    }

    /**
     * Gets the value of the specifiedBy property.
     * 
     * @return
     *     possible object is
     *     {@link IdReferenceType }
     *     
     */
    @Nullable
    public IdReferenceType getSpecifiedBy() {
        return specifiedBy;
    }

    /**
     * Sets the value of the specifiedBy property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdReferenceType }
     *     
     */
    public void setSpecifiedBy(
        @Nullable
        IdReferenceType value) {
        this.specifiedBy = value;
    }

    /**
     * Gets the value of the usedLearningOpportunity property.
     * 
     * @return
     *     possible object is
     *     {@link IdReferenceType }
     *     
     */
    @Nullable
    public IdReferenceType getUsedLearningOpportunity() {
        return usedLearningOpportunity;
    }

    /**
     * Sets the value of the usedLearningOpportunity property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdReferenceType }
     *     
     */
    public void setUsedLearningOpportunity(
        @Nullable
        IdReferenceType value) {
        this.usedLearningOpportunity = value;
    }

    /**
     * Gets the value of the influenced property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the influenced property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getInfluenced().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link RestrictedAchievementsType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RestrictedAchievementsType> getInfluenced() {
        if (influenced == null) {
            influenced = new ArrayList<RestrictedAchievementsType>();
        }
        return this.influenced;
    }

    /**
     * Gets the value of the hasPart property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the hasPart property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getHasPart().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link ActivityType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ActivityType> getHasPart() {
        if (hasPart == null) {
            hasPart = new ArrayList<ActivityType>();
        }
        return this.hasPart;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(
        @Nullable
        String value) {
        this.id = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ActivityType rhs = ((ActivityType) o);
        if (!EqualsHelper.equalsCollection(additionalNote, rhs.additionalNote)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(directedBy, rhs.directedBy)) {
            return false;
        }
        if (!EqualsHelper.equals(endedAtTime, rhs.endedAtTime)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hasPart, rhs.hasPart)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(identifier, rhs.identifier)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(influenced, rhs.influenced)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(location, rhs.location)) {
            return false;
        }
        if (!EqualsHelper.equals(specifiedBy, rhs.specifiedBy)) {
            return false;
        }
        if (!EqualsHelper.equals(startedAtTime, rhs.startedAtTime)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(title, rhs.title)) {
            return false;
        }
        if (!EqualsHelper.equals(usedLearningOpportunity, rhs.usedLearningOpportunity)) {
            return false;
        }
        if (!EqualsHelper.equals(workload, rhs.workload)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalNote).append(description).append(directedBy).append(endedAtTime).append(hasPart).append(id).append(identifier).append(influenced).append(location).append(specifiedBy).append(startedAtTime).append(title).append(usedLearningOpportunity).append(workload).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalNote", additionalNote).append("description", description).append("directedBy", directedBy).append("endedAtTime", endedAtTime).append("hasPart", hasPart).append("id", id).append("identifier", identifier).append("influenced", influenced).append("location", location).append("specifiedBy", specifiedBy).append("startedAtTime", startedAtTime).append("title", title).append("usedLearningOpportunity", usedLearningOpportunity).append("workload", workload).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setIdentifier(
        @Nullable
        final List<IdentifierType> aList) {
        identifier = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTitle(
        @Nullable
        final List<LanguageStringType> aList) {
        title = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDescription(
        @Nullable
        final List<NoteType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setAdditionalNote(
        @Nullable
        final List<NoteType> aList) {
        additionalNote = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDirectedBy(
        @Nullable
        final List<IdReferenceType> aList) {
        directedBy = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setLocation(
        @Nullable
        final List<LocationType> aList) {
        location = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setInfluenced(
        @Nullable
        final List<RestrictedAchievementsType> aList) {
        influenced = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setHasPart(
        @Nullable
        final List<ActivityType> aList) {
        hasPart = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasIdentifierEntries() {
        return (!getIdentifier().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoIdentifierEntries() {
        return getIdentifier().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getIdentifierCount() {
        return getIdentifier().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdentifierType getIdentifierAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIdentifier().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addIdentifier(
        @Nonnull
        final IdentifierType elem) {
        getIdentifier().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasTitleEntries() {
        return (!getTitle().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoTitleEntries() {
        return getTitle().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getTitleCount() {
        return getTitle().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LanguageStringType getTitleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTitle().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addTitle(
        @Nonnull
        final LanguageStringType elem) {
        getTitle().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addDescription(
        @Nonnull
        final NoteType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasAdditionalNoteEntries() {
        return (!getAdditionalNote().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoAdditionalNoteEntries() {
        return getAdditionalNote().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getAdditionalNoteCount() {
        return getAdditionalNote().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getAdditionalNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalNote().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addAdditionalNote(
        @Nonnull
        final NoteType elem) {
        getAdditionalNote().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasDirectedByEntries() {
        return (!getDirectedBy().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoDirectedByEntries() {
        return getDirectedBy().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getDirectedByCount() {
        return getDirectedBy().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdReferenceType getDirectedByAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDirectedBy().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addDirectedBy(
        @Nonnull
        final IdReferenceType elem) {
        getDirectedBy().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasLocationEntries() {
        return (!getLocation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoLocationEntries() {
        return getLocation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getLocationCount() {
        return getLocation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LocationType getLocationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLocation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addLocation(
        @Nonnull
        final LocationType elem) {
        getLocation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasInfluencedEntries() {
        return (!getInfluenced().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoInfluencedEntries() {
        return getInfluenced().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getInfluencedCount() {
        return getInfluenced().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RestrictedAchievementsType getInfluencedAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInfluenced().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addInfluenced(
        @Nonnull
        final RestrictedAchievementsType elem) {
        getInfluenced().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasHasPartEntries() {
        return (!getHasPart().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoHasPartEntries() {
        return getHasPart().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getHasPartCount() {
        return getHasPart().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ActivityType getHasPartAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHasPart().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addHasPart(
        @Nonnull
        final ActivityType elem) {
        getHasPart().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        ActivityType ret) {
        if (additionalNote == null) {
            ret.additionalNote = null;
        } else {
            List<NoteType> retAdditionalNote = new ArrayList<NoteType>();
            for (NoteType aItem: getAdditionalNote()) {
                retAdditionalNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalNote = retAdditionalNote;
        }
        if (description == null) {
            ret.description = null;
        } else {
            List<NoteType> retDescription = new ArrayList<NoteType>();
            for (NoteType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (directedBy == null) {
            ret.directedBy = null;
        } else {
            List<IdReferenceType> retDirectedBy = new ArrayList<IdReferenceType>();
            for (IdReferenceType aItem: getDirectedBy()) {
                retDirectedBy.add(((aItem == null)?null:aItem.clone()));
            }
            ret.directedBy = retDirectedBy;
        }
        ret.endedAtTime = ((endedAtTime == null)?null:((XMLGregorianCalendar) endedAtTime.clone()));
        if (hasPart == null) {
            ret.hasPart = null;
        } else {
            List<ActivityType> retHasPart = new ArrayList<ActivityType>();
            for (ActivityType aItem: getHasPart()) {
                retHasPart.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hasPart = retHasPart;
        }
        ret.id = id;
        if (identifier == null) {
            ret.identifier = null;
        } else {
            List<IdentifierType> retIdentifier = new ArrayList<IdentifierType>();
            for (IdentifierType aItem: getIdentifier()) {
                retIdentifier.add(((aItem == null)?null:aItem.clone()));
            }
            ret.identifier = retIdentifier;
        }
        if (influenced == null) {
            ret.influenced = null;
        } else {
            List<RestrictedAchievementsType> retInfluenced = new ArrayList<RestrictedAchievementsType>();
            for (RestrictedAchievementsType aItem: getInfluenced()) {
                retInfluenced.add(((aItem == null)?null:aItem.clone()));
            }
            ret.influenced = retInfluenced;
        }
        if (location == null) {
            ret.location = null;
        } else {
            List<LocationType> retLocation = new ArrayList<LocationType>();
            for (LocationType aItem: getLocation()) {
                retLocation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.location = retLocation;
        }
        ret.specifiedBy = ((specifiedBy == null)?null:specifiedBy.clone());
        ret.startedAtTime = ((startedAtTime == null)?null:((XMLGregorianCalendar) startedAtTime.clone()));
        if (title == null) {
            ret.title = null;
        } else {
            List<LanguageStringType> retTitle = new ArrayList<LanguageStringType>();
            for (LanguageStringType aItem: getTitle()) {
                retTitle.add(((aItem == null)?null:aItem.clone()));
            }
            ret.title = retTitle;
        }
        ret.usedLearningOpportunity = ((usedLearningOpportunity == null)?null:usedLearningOpportunity.clone());
        ret.workload = workload;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ActivityType clone() {
        ActivityType ret = new ActivityType();
        cloneTo(ret);
        return ret;
    }

}
