
package eu.europa.data.europass.model.credentials_;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * Container element to record achievements of the person. An achievement is the outcome of a learning process and/or assessment in formal, non-formal or informal settings. Such outcome consists of the acquisition of learning outcomes or of an entitlement by the person who underwent the learning process. An achievement is awarded as a result of assessment(s), after the person has undergone learning activity(ies). These do not necessarily need to be described in the credential, although it is recommended. Achievement examples.:
 * - An awarded or recognised set of learning outcomes
 * - An awarded qualification or a diploma
 * - An entitlement (e.g. a permit)
 * - ...
 * 
 * &lt;p&gt;Java class for AchievementsType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="AchievementsType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;choice maxOccurs="unbounded" minOccurs="0"&amp;gt;
 *         &amp;lt;element name="learningAchievement" type="{http://data.europa.eu/europass/model/credentials#}LearningAchievementType"/&amp;gt;
 *         &amp;lt;element name="qualificationAward" type="{http://data.europa.eu/europass/model/credentials#}QualificationAwardType"/&amp;gt;
 *       &amp;lt;/choice&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AchievementsType", propOrder = {
    "learningAchievementOrQualificationAward"
})
@XmlSeeAlso({
    RestrictedAchievementsType.class
})
@CodingStyleguideUnaware
public class AchievementsType implements IExplicitlyCloneable
{

    @XmlElements({
        @XmlElement(name = "learningAchievement", type = LearningAchievementType.class),
        @XmlElement(name = "qualificationAward", type = QualificationAwardType.class)
    })
    private List<AchievementType> learningAchievementOrQualificationAward;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public AchievementsType() {
    }

    /**
     * Gets the value of the learningAchievementOrQualificationAward property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the learningAchievementOrQualificationAward property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getLearningAchievementOrQualificationAward().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link LearningAchievementType }
     * {@link QualificationAwardType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AchievementType> getLearningAchievementOrQualificationAward() {
        if (learningAchievementOrQualificationAward == null) {
            learningAchievementOrQualificationAward = new ArrayList<AchievementType>();
        }
        return this.learningAchievementOrQualificationAward;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final AchievementsType rhs = ((AchievementsType) o);
        if (!EqualsHelper.equalsCollection(learningAchievementOrQualificationAward, rhs.learningAchievementOrQualificationAward)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(learningAchievementOrQualificationAward).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("learningAchievementOrQualificationAward", learningAchievementOrQualificationAward).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setLearningAchievementOrQualificationAward(
        @Nullable
        final List<AchievementType> aList) {
        learningAchievementOrQualificationAward = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasLearningAchievementOrQualificationAwardEntries() {
        return (!getLearningAchievementOrQualificationAward().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoLearningAchievementOrQualificationAwardEntries() {
        return getLearningAchievementOrQualificationAward().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getLearningAchievementOrQualificationAwardCount() {
        return getLearningAchievementOrQualificationAward().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AchievementType getLearningAchievementOrQualificationAwardAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLearningAchievementOrQualificationAward().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addLearningAchievementOrQualificationAward(
        @Nonnull
        final AchievementType elem) {
        getLearningAchievementOrQualificationAward().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        AchievementsType ret) {
        if (learningAchievementOrQualificationAward == null) {
            ret.learningAchievementOrQualificationAward = null;
        } else {
            List<AchievementType> retLearningAchievementOrQualificationAward = new ArrayList<AchievementType>();
            for (AchievementType aItem: getLearningAchievementOrQualificationAward()) {
                retLearningAchievementOrQualificationAward.add(((aItem == null)?null:aItem.clone()));
            }
            ret.learningAchievementOrQualificationAward = retLearningAchievementOrQualificationAward;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public AchievementsType clone() {
        AchievementsType ret = new AchievementsType();
        cloneTo(ret);
        return ret;
    }

}
