
package eu.de4a.iem.jaxb.t43.marriage.v1_6b;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import eu.de4a.iem.jaxb.w3.cv10.ac.CvidentifierType;
import oasis.names.specification.bdndr.schema.xsd.unqualifieddatatypes_1.CodeType;


/**
 * 
 * 				An individual natural person who may be dead or alive, but not imaginary.
 * 			
 * 
 * &lt;p&gt;Java class for PersonType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="PersonType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="DateOfBirth" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::MarriageEvidence:v1.6}DateObjectType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="PersonName" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::MarriageEvidence:v1.6}NameType"/&amp;gt;
 *         &amp;lt;element name="Identifier" type="{http://www.w3.org/ns/corevocabulary/AggregateComponents}CvidentifierType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="PlaceOfBirth" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::MarriageEvidence:v1.6}LocationAddressType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="Gender" type="{urn:oasis:names:specification:bdndr:schema:xsd:UnqualifiedDataTypes-1}CodeType"/&amp;gt;
 *         &amp;lt;element name="Citizenship" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::MarriageEvidence:v1.6}JurisdictionType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PersonType", propOrder = {
    "dateOfBirth",
    "personName",
    "identifier",
    "placeOfBirth",
    "gender",
    "citizenship"
})
@XmlSeeAlso({
    MarriedPersonType.class
})
@CodingStyleguideUnaware
public class PersonType implements IExplicitlyCloneable
{

    @XmlElement(name = "DateOfBirth")
    private DateObjectType dateOfBirth;
    @XmlElement(name = "PersonName", required = true)
    private NameType personName;
    @XmlElement(name = "Identifier")
    private List<CvidentifierType> identifier;
    @XmlElement(name = "PlaceOfBirth")
    private LocationAddressType placeOfBirth;
    @XmlElement(name = "Gender", required = true)
    private CodeType gender;
    @XmlElement(name = "Citizenship")
    private List<JurisdictionType> citizenship;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public PersonType() {
    }

    /**
     * Gets the value of the dateOfBirth property.
     * 
     * @return
     *     possible object is
     *     {@link DateObjectType }
     *     
     */
    @Nullable
    public DateObjectType getDateOfBirth() {
        return dateOfBirth;
    }

    /**
     * Sets the value of the dateOfBirth property.
     * 
     * @param value
     *     allowed object is
     *     {@link DateObjectType }
     *     
     */
    public void setDateOfBirth(
        @Nullable
        DateObjectType value) {
        this.dateOfBirth = value;
    }

    /**
     * Gets the value of the personName property.
     * 
     * @return
     *     possible object is
     *     {@link NameType }
     *     
     */
    @Nullable
    public NameType getPersonName() {
        return personName;
    }

    /**
     * Sets the value of the personName property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameType }
     *     
     */
    public void setPersonName(
        @Nullable
        NameType value) {
        this.personName = value;
    }

    /**
     * Gets the value of the identifier property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the identifier property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getIdentifier().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link CvidentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CvidentifierType> getIdentifier() {
        if (identifier == null) {
            identifier = new ArrayList<CvidentifierType>();
        }
        return this.identifier;
    }

    /**
     * Gets the value of the placeOfBirth property.
     * 
     * @return
     *     possible object is
     *     {@link LocationAddressType }
     *     
     */
    @Nullable
    public LocationAddressType getPlaceOfBirth() {
        return placeOfBirth;
    }

    /**
     * Sets the value of the placeOfBirth property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationAddressType }
     *     
     */
    public void setPlaceOfBirth(
        @Nullable
        LocationAddressType value) {
        this.placeOfBirth = value;
    }

    /**
     * Gets the value of the gender property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getGender() {
        return gender;
    }

    /**
     * Sets the value of the gender property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setGender(
        @Nullable
        CodeType value) {
        this.gender = value;
    }

    /**
     * Gets the value of the citizenship property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the citizenship property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getCitizenship().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link JurisdictionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<JurisdictionType> getCitizenship() {
        if (citizenship == null) {
            citizenship = new ArrayList<JurisdictionType>();
        }
        return this.citizenship;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PersonType rhs = ((PersonType) o);
        if (!EqualsHelper.equalsCollection(citizenship, rhs.citizenship)) {
            return false;
        }
        if (!EqualsHelper.equals(dateOfBirth, rhs.dateOfBirth)) {
            return false;
        }
        if (!EqualsHelper.equals(gender, rhs.gender)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(identifier, rhs.identifier)) {
            return false;
        }
        if (!EqualsHelper.equals(personName, rhs.personName)) {
            return false;
        }
        if (!EqualsHelper.equals(placeOfBirth, rhs.placeOfBirth)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(citizenship).append(dateOfBirth).append(gender).append(identifier).append(personName).append(placeOfBirth).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("citizenship", citizenship).append("dateOfBirth", dateOfBirth).append("gender", gender).append("identifier", identifier).append("personName", personName).append("placeOfBirth", placeOfBirth).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setIdentifier(
        @Nullable
        final List<CvidentifierType> aList) {
        identifier = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setCitizenship(
        @Nullable
        final List<JurisdictionType> aList) {
        citizenship = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasIdentifierEntries() {
        return (!getIdentifier().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoIdentifierEntries() {
        return getIdentifier().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getIdentifierCount() {
        return getIdentifier().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CvidentifierType getIdentifierAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIdentifier().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addIdentifier(
        @Nonnull
        final CvidentifierType elem) {
        getIdentifier().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasCitizenshipEntries() {
        return (!getCitizenship().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoCitizenshipEntries() {
        return getCitizenship().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getCitizenshipCount() {
        return getCitizenship().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public JurisdictionType getCitizenshipAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCitizenship().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addCitizenship(
        @Nonnull
        final JurisdictionType elem) {
        getCitizenship().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        PersonType ret) {
        if (citizenship == null) {
            ret.citizenship = null;
        } else {
            List<JurisdictionType> retCitizenship = new ArrayList<JurisdictionType>();
            for (JurisdictionType aItem: getCitizenship()) {
                retCitizenship.add(((aItem == null)?null:aItem.clone()));
            }
            ret.citizenship = retCitizenship;
        }
        ret.dateOfBirth = ((dateOfBirth == null)?null:dateOfBirth.clone());
        ret.gender = ((gender == null)?null:gender.clone());
        if (identifier == null) {
            ret.identifier = null;
        } else {
            List<CvidentifierType> retIdentifier = new ArrayList<CvidentifierType>();
            for (CvidentifierType aItem: getIdentifier()) {
                retIdentifier.add(((aItem == null)?null:aItem.clone()));
            }
            ret.identifier = retIdentifier;
        }
        ret.personName = ((personName == null)?null:personName.clone());
        ret.placeOfBirth = ((placeOfBirth == null)?null:placeOfBirth.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PersonType clone() {
        PersonType ret = new PersonType();
        cloneTo(ret);
        return ret;
    }

}
