
package eu.de4a.iem.jaxb.t42.v0_6;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * 
 *         Company's legal information
 *         - CompanyName: This is the primary name of the company. Can be provided for multiple languages.
 *         - CompanyType: Type of the company based on ISO 20275 (e.g: SA, PLC, LLC, GmbH etc) 
 *         - CompanyStatus: Company status as defined in BRIS (closed, struck off the register, wound up, dissolved, economically active or inactive)
 *         - CompanyActivity: The activity of a company 
 *         - RegistrationDate: Date of registration of the company
 *         - CompanyEndDate: The company end date
 *         - CompanyEUID: Identification of the company following the BRIS-structure: country code + register identifier + registration number + verification digit (optional)
 *         - VatNumber: The VAT registration number of the company
 *         - CompanyContactData: the contact information of the company (email and Telephone)
 *         - RegisteredAddress: Links a Legal Entity to its registered address. 
 *         - PostalAddress: Company physical address
 *         - HasBranch: The branch information
 *       
 * 
 * &lt;p&gt;Java class for LegalEntityType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="LegalEntityType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="CompanyName" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::CompanyRegistration:v0.6}NamesType" maxOccurs="unbounded"/&amp;gt;
 *         &amp;lt;element name="CompanyType" type="{http://www.w3.org/2001/XMLSchema}string"/&amp;gt;
 *         &amp;lt;element name="CompanyStatus" type="{http://www.w3.org/2001/XMLSchema}string"/&amp;gt;
 *         &amp;lt;element name="CompanyActivity" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::CompanyRegistration:v0.6}ActivityType"/&amp;gt;
 *         &amp;lt;element name="RegistrationDate" type="{http://www.w3.org/2001/XMLSchema}date"/&amp;gt;
 *         &amp;lt;element name="CompanyEndDate" type="{http://www.w3.org/2001/XMLSchema}date" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="CompanyEUID" type="{http://www.w3.org/2001/XMLSchema}string"/&amp;gt;
 *         &amp;lt;element name="VatNumber" type="{http://www.w3.org/2001/XMLSchema}string" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="CompanyContactData" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::CompanyRegistration:v0.6}ContactPointType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="RegisteredAddress" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::CompanyRegistration:v0.6}AddressType" maxOccurs="unbounded"/&amp;gt;
 *         &amp;lt;element name="PostalAddress" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::CompanyRegistration:v0.6}AddressType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="HasBranch" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::CompanyRegistration:v0.6}BranchType" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LegalEntityType", propOrder = {
    "companyName",
    "companyType",
    "companyStatus",
    "companyActivity",
    "registrationDate",
    "companyEndDate",
    "companyEUID",
    "vatNumber",
    "companyContactData",
    "registeredAddress",
    "postalAddress",
    "hasBranch"
})
@CodingStyleguideUnaware
public class LegalEntityType implements IExplicitlyCloneable
{

    @XmlElement(name = "CompanyName", required = true)
    private List<NamesType> companyName;
    @XmlElement(name = "CompanyType", required = true)
    private String companyType;
    @XmlElement(name = "CompanyStatus", required = true)
    private String companyStatus;
    @XmlElement(name = "CompanyActivity", required = true)
    private ActivityType companyActivity;
    @XmlElement(name = "RegistrationDate", required = true)
    @XmlSchemaType(name = "date")
    private XMLGregorianCalendar registrationDate;
    @XmlElement(name = "CompanyEndDate")
    @XmlSchemaType(name = "date")
    private XMLGregorianCalendar companyEndDate;
    @XmlElement(name = "CompanyEUID", required = true)
    private String companyEUID;
    @XmlElement(name = "VatNumber")
    private List<String> vatNumber;
    @XmlElement(name = "CompanyContactData")
    private ContactPointType companyContactData;
    @XmlElement(name = "RegisteredAddress", required = true)
    private List<AddressType> registeredAddress;
    @XmlElement(name = "PostalAddress")
    private List<AddressType> postalAddress;
    @XmlElement(name = "HasBranch")
    private BranchType hasBranch;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public LegalEntityType() {
    }

    /**
     * Gets the value of the companyName property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the companyName property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getCompanyName().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link NamesType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NamesType> getCompanyName() {
        if (companyName == null) {
            companyName = new ArrayList<NamesType>();
        }
        return this.companyName;
    }

    /**
     * Gets the value of the companyType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getCompanyType() {
        return companyType;
    }

    /**
     * Sets the value of the companyType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCompanyType(
        @Nullable
        String value) {
        this.companyType = value;
    }

    /**
     * Gets the value of the companyStatus property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getCompanyStatus() {
        return companyStatus;
    }

    /**
     * Sets the value of the companyStatus property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCompanyStatus(
        @Nullable
        String value) {
        this.companyStatus = value;
    }

    /**
     * Gets the value of the companyActivity property.
     * 
     * @return
     *     possible object is
     *     {@link ActivityType }
     *     
     */
    @Nullable
    public ActivityType getCompanyActivity() {
        return companyActivity;
    }

    /**
     * Sets the value of the companyActivity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActivityType }
     *     
     */
    public void setCompanyActivity(
        @Nullable
        ActivityType value) {
        this.companyActivity = value;
    }

    /**
     * Gets the value of the registrationDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getRegistrationDate() {
        return registrationDate;
    }

    /**
     * Sets the value of the registrationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setRegistrationDate(
        @Nullable
        XMLGregorianCalendar value) {
        this.registrationDate = value;
    }

    /**
     * Gets the value of the companyEndDate property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    @Nullable
    public XMLGregorianCalendar getCompanyEndDate() {
        return companyEndDate;
    }

    /**
     * Sets the value of the companyEndDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setCompanyEndDate(
        @Nullable
        XMLGregorianCalendar value) {
        this.companyEndDate = value;
    }

    /**
     * Gets the value of the companyEUID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getCompanyEUID() {
        return companyEUID;
    }

    /**
     * Sets the value of the companyEUID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCompanyEUID(
        @Nullable
        String value) {
        this.companyEUID = value;
    }

    /**
     * Gets the value of the vatNumber property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the vatNumber property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getVatNumber().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getVatNumber() {
        if (vatNumber == null) {
            vatNumber = new ArrayList<String>();
        }
        return this.vatNumber;
    }

    /**
     * Gets the value of the companyContactData property.
     * 
     * @return
     *     possible object is
     *     {@link ContactPointType }
     *     
     */
    @Nullable
    public ContactPointType getCompanyContactData() {
        return companyContactData;
    }

    /**
     * Sets the value of the companyContactData property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactPointType }
     *     
     */
    public void setCompanyContactData(
        @Nullable
        ContactPointType value) {
        this.companyContactData = value;
    }

    /**
     * Gets the value of the registeredAddress property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the registeredAddress property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getRegisteredAddress().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link AddressType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressType> getRegisteredAddress() {
        if (registeredAddress == null) {
            registeredAddress = new ArrayList<AddressType>();
        }
        return this.registeredAddress;
    }

    /**
     * Gets the value of the postalAddress property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the postalAddress property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getPostalAddress().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link AddressType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AddressType> getPostalAddress() {
        if (postalAddress == null) {
            postalAddress = new ArrayList<AddressType>();
        }
        return this.postalAddress;
    }

    /**
     * Gets the value of the hasBranch property.
     * 
     * @return
     *     possible object is
     *     {@link BranchType }
     *     
     */
    @Nullable
    public BranchType getHasBranch() {
        return hasBranch;
    }

    /**
     * Sets the value of the hasBranch property.
     * 
     * @param value
     *     allowed object is
     *     {@link BranchType }
     *     
     */
    public void setHasBranch(
        @Nullable
        BranchType value) {
        this.hasBranch = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final LegalEntityType rhs = ((LegalEntityType) o);
        if (!EqualsHelper.equals(companyActivity, rhs.companyActivity)) {
            return false;
        }
        if (!EqualsHelper.equals(companyContactData, rhs.companyContactData)) {
            return false;
        }
        if (!EqualsHelper.equals(companyEUID, rhs.companyEUID)) {
            return false;
        }
        if (!EqualsHelper.equals(companyEndDate, rhs.companyEndDate)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(companyName, rhs.companyName)) {
            return false;
        }
        if (!EqualsHelper.equals(companyStatus, rhs.companyStatus)) {
            return false;
        }
        if (!EqualsHelper.equals(companyType, rhs.companyType)) {
            return false;
        }
        if (!EqualsHelper.equals(hasBranch, rhs.hasBranch)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(postalAddress, rhs.postalAddress)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(registeredAddress, rhs.registeredAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(registrationDate, rhs.registrationDate)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(vatNumber, rhs.vatNumber)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(companyActivity).append(companyContactData).append(companyEUID).append(companyEndDate).append(companyName).append(companyStatus).append(companyType).append(hasBranch).append(postalAddress).append(registeredAddress).append(registrationDate).append(vatNumber).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("companyActivity", companyActivity).append("companyContactData", companyContactData).append("companyEUID", companyEUID).append("companyEndDate", companyEndDate).append("companyName", companyName).append("companyStatus", companyStatus).append("companyType", companyType).append("hasBranch", hasBranch).append("postalAddress", postalAddress).append("registeredAddress", registeredAddress).append("registrationDate", registrationDate).append("vatNumber", vatNumber).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setCompanyName(
        @Nullable
        final List<NamesType> aList) {
        companyName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setVatNumber(
        @Nullable
        final List<String> aList) {
        vatNumber = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setRegisteredAddress(
        @Nullable
        final List<AddressType> aList) {
        registeredAddress = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setPostalAddress(
        @Nullable
        final List<AddressType> aList) {
        postalAddress = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasCompanyNameEntries() {
        return (!getCompanyName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoCompanyNameEntries() {
        return getCompanyName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getCompanyNameCount() {
        return getCompanyName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NamesType getCompanyNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCompanyName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addCompanyName(
        @Nonnull
        final NamesType elem) {
        getCompanyName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasVatNumberEntries() {
        return (!getVatNumber().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoVatNumberEntries() {
        return getVatNumber().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getVatNumberCount() {
        return getVatNumber().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getVatNumberAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getVatNumber().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addVatNumber(
        @Nonnull
        final String elem) {
        getVatNumber().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasRegisteredAddressEntries() {
        return (!getRegisteredAddress().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoRegisteredAddressEntries() {
        return getRegisteredAddress().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getRegisteredAddressCount() {
        return getRegisteredAddress().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressType getRegisteredAddressAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRegisteredAddress().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addRegisteredAddress(
        @Nonnull
        final AddressType elem) {
        getRegisteredAddress().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasPostalAddressEntries() {
        return (!getPostalAddress().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoPostalAddressEntries() {
        return getPostalAddress().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getPostalAddressCount() {
        return getPostalAddress().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AddressType getPostalAddressAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPostalAddress().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addPostalAddress(
        @Nonnull
        final AddressType elem) {
        getPostalAddress().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        LegalEntityType ret) {
        ret.companyActivity = ((companyActivity == null)?null:companyActivity.clone());
        ret.companyContactData = ((companyContactData == null)?null:companyContactData.clone());
        ret.companyEUID = companyEUID;
        ret.companyEndDate = ((companyEndDate == null)?null:((XMLGregorianCalendar) companyEndDate.clone()));
        if (companyName == null) {
            ret.companyName = null;
        } else {
            List<NamesType> retCompanyName = new ArrayList<NamesType>();
            for (NamesType aItem: getCompanyName()) {
                retCompanyName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.companyName = retCompanyName;
        }
        ret.companyStatus = companyStatus;
        ret.companyType = companyType;
        ret.hasBranch = ((hasBranch == null)?null:hasBranch.clone());
        if (postalAddress == null) {
            ret.postalAddress = null;
        } else {
            List<AddressType> retPostalAddress = new ArrayList<AddressType>();
            for (AddressType aItem: getPostalAddress()) {
                retPostalAddress.add(((aItem == null)?null:aItem.clone()));
            }
            ret.postalAddress = retPostalAddress;
        }
        if (registeredAddress == null) {
            ret.registeredAddress = null;
        } else {
            List<AddressType> retRegisteredAddress = new ArrayList<AddressType>();
            for (AddressType aItem: getRegisteredAddress()) {
                retRegisteredAddress.add(((aItem == null)?null:aItem.clone()));
            }
            ret.registeredAddress = retRegisteredAddress;
        }
        ret.registrationDate = ((registrationDate == null)?null:((XMLGregorianCalendar) registrationDate.clone()));
        if (vatNumber == null) {
            ret.vatNumber = null;
        } else {
            List<String> retVatNumber = new ArrayList<String>();
            for (String aItem: getVatNumber()) {
                retVatNumber.add(aItem);
            }
            ret.vatNumber = retVatNumber;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public LegalEntityType clone() {
        LegalEntityType ret = new LegalEntityType();
        cloneTo(ret);
        return ret;
    }

}
