
package eu.de4a.iem.jaxb.t42.v0_6;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * 
 *         - BranchName: Primary name of the branch. Can be provided for multiple languages
 *         - BranchEUID: Identification of the branch of the company following the BRIS-structure: country code + register identifier + registration number + verification digit (optional)
 *         - BranchActivity: The activity of the branch presented by the NACE code and description
 *         - BranchRegistredAddress: The legal registered address of the branch  
 *         - BranchPostalAddress: The Physical address of the branch
 *       
 * 
 * &lt;p&gt;Java class for BranchType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="BranchType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="BranchName" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::CompanyRegistration:v0.6}NamesType"/&amp;gt;
 *         &amp;lt;element name="BranchEUID" type="{http://www.w3.org/2001/XMLSchema}string"/&amp;gt;
 *         &amp;lt;element name="BranchActivity" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::CompanyRegistration:v0.6}ActivityType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="BranchRegistredAddress" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::CompanyRegistration:v0.6}AddressType"/&amp;gt;
 *         &amp;lt;element name="BranchPostalAddress" type="{urn:eu-de4a:xsd:CanonicalEvidenceType::CompanyRegistration:v0.6}AddressType" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BranchType", propOrder = {
    "branchName",
    "branchEUID",
    "branchActivity",
    "branchRegistredAddress",
    "branchPostalAddress"
})
@CodingStyleguideUnaware
public class BranchType implements IExplicitlyCloneable
{

    @XmlElement(name = "BranchName", required = true)
    private NamesType branchName;
    @XmlElement(name = "BranchEUID", required = true)
    private String branchEUID;
    @XmlElement(name = "BranchActivity")
    private ActivityType branchActivity;
    @XmlElement(name = "BranchRegistredAddress", required = true)
    private AddressType branchRegistredAddress;
    @XmlElement(name = "BranchPostalAddress")
    private AddressType branchPostalAddress;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public BranchType() {
    }

    /**
     * Gets the value of the branchName property.
     * 
     * @return
     *     possible object is
     *     {@link NamesType }
     *     
     */
    @Nullable
    public NamesType getBranchName() {
        return branchName;
    }

    /**
     * Sets the value of the branchName property.
     * 
     * @param value
     *     allowed object is
     *     {@link NamesType }
     *     
     */
    public void setBranchName(
        @Nullable
        NamesType value) {
        this.branchName = value;
    }

    /**
     * Gets the value of the branchEUID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getBranchEUID() {
        return branchEUID;
    }

    /**
     * Sets the value of the branchEUID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBranchEUID(
        @Nullable
        String value) {
        this.branchEUID = value;
    }

    /**
     * Gets the value of the branchActivity property.
     * 
     * @return
     *     possible object is
     *     {@link ActivityType }
     *     
     */
    @Nullable
    public ActivityType getBranchActivity() {
        return branchActivity;
    }

    /**
     * Sets the value of the branchActivity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ActivityType }
     *     
     */
    public void setBranchActivity(
        @Nullable
        ActivityType value) {
        this.branchActivity = value;
    }

    /**
     * Gets the value of the branchRegistredAddress property.
     * 
     * @return
     *     possible object is
     *     {@link AddressType }
     *     
     */
    @Nullable
    public AddressType getBranchRegistredAddress() {
        return branchRegistredAddress;
    }

    /**
     * Sets the value of the branchRegistredAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddressType }
     *     
     */
    public void setBranchRegistredAddress(
        @Nullable
        AddressType value) {
        this.branchRegistredAddress = value;
    }

    /**
     * Gets the value of the branchPostalAddress property.
     * 
     * @return
     *     possible object is
     *     {@link AddressType }
     *     
     */
    @Nullable
    public AddressType getBranchPostalAddress() {
        return branchPostalAddress;
    }

    /**
     * Sets the value of the branchPostalAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddressType }
     *     
     */
    public void setBranchPostalAddress(
        @Nullable
        AddressType value) {
        this.branchPostalAddress = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final BranchType rhs = ((BranchType) o);
        if (!EqualsHelper.equals(branchActivity, rhs.branchActivity)) {
            return false;
        }
        if (!EqualsHelper.equals(branchEUID, rhs.branchEUID)) {
            return false;
        }
        if (!EqualsHelper.equals(branchName, rhs.branchName)) {
            return false;
        }
        if (!EqualsHelper.equals(branchPostalAddress, rhs.branchPostalAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(branchRegistredAddress, rhs.branchRegistredAddress)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(branchActivity).append(branchEUID).append(branchName).append(branchPostalAddress).append(branchRegistredAddress).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("branchActivity", branchActivity).append("branchEUID", branchEUID).append("branchName", branchName).append("branchPostalAddress", branchPostalAddress).append("branchRegistredAddress", branchRegistredAddress).getToString();
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        BranchType ret) {
        ret.branchActivity = ((branchActivity == null)?null:branchActivity.clone());
        ret.branchEUID = branchEUID;
        ret.branchName = ((branchName == null)?null:branchName.clone());
        ret.branchPostalAddress = ((branchPostalAddress == null)?null:branchPostalAddress.clone());
        ret.branchRegistredAddress = ((branchRegistredAddress == null)?null:branchRegistredAddress.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public BranchType clone() {
        BranchType ret = new BranchType();
        cloneTo(ret);
        return ret;
    }

}
