/*
 * Decompiled with CFR 0.152.
 */
package eu.de4a.iem.core.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.ByteBufferInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.SAXReaderFactory;
import com.helger.xml.serialize.read.SAXReaderSettings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public interface IJAXBVersatileReader<T> {
    @Nullable
    default public T read(@Nonnull InputSource inputSource) {
        return this.read(new SAXReaderSettings(), inputSource);
    }

    @Nullable
    default public T read(@Nonnull SAXReaderSettings sAXReaderSettings, @Nonnull InputSource inputSource) {
        ValueEnforcer.notNull((Object)sAXReaderSettings, (String)"Settings");
        ValueEnforcer.notNull((Object)inputSource, (String)"InputSource");
        sAXReaderSettings.setFeatureValues(EXMLParserFeature.AVOID_XML_ATTACKS);
        XMLReader xMLReader = SAXReaderFactory.createXMLReader();
        sAXReaderSettings.applyToSAXReader(xMLReader);
        return this.read(new SAXSource(xMLReader, inputSource));
    }

    @Nullable
    default public T read(@Nonnull InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        CharsetHelper.InputStreamAndCharset inputStreamAndCharset = CharsetHelper.getInputStreamAndCharsetFromBOM((InputStream)inputStream);
        if (inputStreamAndCharset.hasCharset()) {
            return this.read(StreamHelper.createReader((InputStream)inputStreamAndCharset.getInputStream(), (Charset)inputStreamAndCharset.getCharset()));
        }
        return this.read(InputSourceFactory.create((InputStream)inputStreamAndCharset.getInputStream()));
    }

    @Nullable
    default public T read(@Nonnull Reader reader) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        return this.read(InputSourceFactory.create((Reader)reader));
    }

    @Nullable
    default public T read(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"File");
        return this.read(InputSourceFactory.create((File)file));
    }

    @Nullable
    default public T read(@Nonnull Path path) {
        ValueEnforcer.notNull((Object)path, (String)"Path");
        return this.read(InputSourceFactory.create((Path)path));
    }

    @Nullable
    default public T read(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        return this.read(InputSourceFactory.create((IReadableResource)iReadableResource));
    }

    @Nullable
    default public T read(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"Resource");
        return this.read(iHasInputStream.getInputStream());
    }

    @Nullable
    default public T read(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull((Object)byArray, (String)"XML");
        return this.read((InputStream)new NonBlockingByteArrayInputStream(byArray));
    }

    @Nullable
    default public T read(@Nonnull ByteBuffer byteBuffer) {
        ValueEnforcer.notNull((Object)byteBuffer, (String)"XML");
        return this.read((InputStream)new ByteBufferInputStream(byteBuffer));
    }

    @Nullable
    default public T read(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"XML");
        return this.read((Reader)new NonBlockingStringReader(string));
    }

    @Nullable
    default public T read(@Nonnull char[] cArray) {
        ValueEnforcer.notNull((Object)cArray, (String)"XML");
        return this.read((Reader)new NonBlockingStringReader(cArray));
    }

    @Nullable
    public T read(@Nonnull Source var1);

    @Nullable
    public T read(@Nonnull Node var1);
}

