
package eu.de4a.iem.core.jaxb.common;

import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterXMLOffsetDateTime;


/**
 * &lt;p&gt;Java class for RequestExtractMultiEvidenceType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="RequestExtractMultiEvidenceType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="RequestId" type="{http://www.de4a.eu/2020/commons/type/v2}IdType"/&amp;gt;
 *         &amp;lt;element name="SpecificationId" type="{http://www.de4a.eu/2020/commons/type/v2}IdType"/&amp;gt;
 *         &amp;lt;element name="TimeStamp" type="{http://www.w3.org/2001/XMLSchema}dateTime"/&amp;gt;
 *         &amp;lt;element name="ProcedureId" type="{http://www.de4a.eu/2020/commons/type/v2}ProcedureIdType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="DataEvaluator" type="{http://www.de4a.eu/2020/commons/type/v2}AgentType"/&amp;gt;
 *         &amp;lt;element name="DataOwner" type="{http://www.de4a.eu/2020/commons/type/v2}AgentType"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-offset-dt-extension&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RequestExtractMultiEvidenceType", propOrder = {
    "requestId",
    "specificationId",
    "timeStamp",
    "procedureId",
    "dataEvaluator",
    "dataOwner"
})
@XmlSeeAlso({
    RequestExtractMultiEvidenceIMType.class,
    RequestExtractMultiEvidenceUSIType.class,
    RequestExtractMultiEvidenceLUType.class,
    RequestEventSubscriptionType.class
})
@CodingStyleguideUnaware
public abstract class RequestExtractMultiEvidenceType implements IExplicitlyCloneable
{

    @XmlElement(name = "RequestId", required = true)
    private String requestId;
    @XmlElement(name = "SpecificationId", required = true)
    private String specificationId;
    @XmlElement(name = "TimeStamp", required = true, type = String.class)
    @XmlJavaTypeAdapter(AdapterXMLOffsetDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private XMLOffsetDateTime timeStamp;
    @XmlElement(name = "ProcedureId")
    private String procedureId;
    @XmlElement(name = "DataEvaluator", required = true)
    private AgentType dataEvaluator;
    @XmlElement(name = "DataOwner", required = true)
    private AgentType dataOwner;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public RequestExtractMultiEvidenceType() {
    }

    /**
     * Gets the value of the requestId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getRequestId() {
        return requestId;
    }

    /**
     * Sets the value of the requestId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRequestId(
        @Nullable
        String value) {
        this.requestId = value;
    }

    /**
     * Gets the value of the specificationId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSpecificationId() {
        return specificationId;
    }

    /**
     * Sets the value of the specificationId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSpecificationId(
        @Nullable
        String value) {
        this.specificationId = value;
    }

    /**
     * Gets the value of the timeStamp property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDateTime getTimeStamp() {
        return timeStamp;
    }

    /**
     * Sets the value of the timeStamp property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTimeStamp(
        @Nullable
        XMLOffsetDateTime value) {
        this.timeStamp = value;
    }

    /**
     * Gets the value of the procedureId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getProcedureId() {
        return procedureId;
    }

    /**
     * Sets the value of the procedureId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setProcedureId(
        @Nullable
        String value) {
        this.procedureId = value;
    }

    /**
     * Gets the value of the dataEvaluator property.
     * 
     * @return
     *     possible object is
     *     {@link AgentType }
     *     
     */
    @Nullable
    public AgentType getDataEvaluator() {
        return dataEvaluator;
    }

    /**
     * Sets the value of the dataEvaluator property.
     * 
     * @param value
     *     allowed object is
     *     {@link AgentType }
     *     
     */
    public void setDataEvaluator(
        @Nullable
        AgentType value) {
        this.dataEvaluator = value;
    }

    /**
     * Gets the value of the dataOwner property.
     * 
     * @return
     *     possible object is
     *     {@link AgentType }
     *     
     */
    @Nullable
    public AgentType getDataOwner() {
        return dataOwner;
    }

    /**
     * Sets the value of the dataOwner property.
     * 
     * @param value
     *     allowed object is
     *     {@link AgentType }
     *     
     */
    public void setDataOwner(
        @Nullable
        AgentType value) {
        this.dataOwner = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final RequestExtractMultiEvidenceType rhs = ((RequestExtractMultiEvidenceType) o);
        if (!EqualsHelper.equals(dataEvaluator, rhs.dataEvaluator)) {
            return false;
        }
        if (!EqualsHelper.equals(dataOwner, rhs.dataOwner)) {
            return false;
        }
        if (!EqualsHelper.equals(procedureId, rhs.procedureId)) {
            return false;
        }
        if (!EqualsHelper.equals(requestId, rhs.requestId)) {
            return false;
        }
        if (!EqualsHelper.equals(specificationId, rhs.specificationId)) {
            return false;
        }
        if (!EqualsHelper.equals(timeStamp, rhs.timeStamp)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(dataEvaluator).append(dataOwner).append(procedureId).append(requestId).append(specificationId).append(timeStamp).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("dataEvaluator", dataEvaluator).append("dataOwner", dataOwner).append("procedureId", procedureId).append("requestId", requestId).append("specificationId", specificationId).append("timeStamp", timeStamp).getToString();
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        RequestExtractMultiEvidenceType ret) {
        ret.dataEvaluator = ((dataEvaluator == null)?null:dataEvaluator.clone());
        ret.dataOwner = ((dataOwner == null)?null:dataOwner.clone());
        ret.procedureId = procedureId;
        ret.requestId = requestId;
        ret.specificationId = specificationId;
        ret.timeStamp = timeStamp;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public abstract RequestExtractMultiEvidenceType clone();

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDateTime representation of timeStamp. May be &lt;code&gt;null&lt;/code&gt;.
     */
    @Nullable
    public LocalDateTime getTimeStampLocal() {
        return (timeStamp == null)?null:timeStamp.toLocalDateTime();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDateTime to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTimeStamp(
        @Nullable
        final LocalDateTime aValue) {
        timeStamp = (aValue == null)?null:XMLOffsetDateTime.of(aValue, null);
    }

}
