
package eu.de4a.iem.core.jaxb.common;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterXMLOffsetDateTime;


/**
 * &lt;p&gt;Java class for RedirectUserType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="RedirectUserType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="RequestId" type="{http://www.de4a.eu/2020/commons/type/v2}IdType"/&amp;gt;
 *         &amp;lt;element name="SpecificationId" type="{http://www.de4a.eu/2020/commons/type/v2}IdType"/&amp;gt;
 *         &amp;lt;element name="TimeStamp" type="{http://www.w3.org/2001/XMLSchema}dateTime"/&amp;gt;
 *         &amp;lt;element name="DataEvaluator" type="{http://www.de4a.eu/2020/commons/type/v2}AgentType"/&amp;gt;
 *         &amp;lt;element name="DataOwner" type="{http://www.de4a.eu/2020/commons/type/v2}AgentType"/&amp;gt;
 *         &amp;lt;element name="CanonicalEvidenceTypeId" type="{http://www.de4a.eu/2020/commons/type/v2}IdType"/&amp;gt;
 *         &amp;lt;element name="RedirectUrl" type="{http://www.de4a.eu/2020/commons/type/v2}RedirectURLType"/&amp;gt;
 *         &amp;lt;element name="Error" type="{http://www.de4a.eu/2020/commons/type/v2}ErrorType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-offset-dt-extension&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RedirectUserType", propOrder = {
    "requestId",
    "specificationId",
    "timeStamp",
    "dataEvaluator",
    "dataOwner",
    "canonicalEvidenceTypeId",
    "redirectUrl",
    "error"
})
@CodingStyleguideUnaware
public class RedirectUserType implements IExplicitlyCloneable
{

    @XmlElement(name = "RequestId", required = true)
    private String requestId;
    @XmlElement(name = "SpecificationId", required = true)
    private String specificationId;
    @XmlElement(name = "TimeStamp", required = true, type = String.class)
    @XmlJavaTypeAdapter(AdapterXMLOffsetDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private XMLOffsetDateTime timeStamp;
    @XmlElement(name = "DataEvaluator", required = true)
    private AgentType dataEvaluator;
    @XmlElement(name = "DataOwner", required = true)
    private AgentType dataOwner;
    @XmlElement(name = "CanonicalEvidenceTypeId", required = true)
    private String canonicalEvidenceTypeId;
    @XmlElement(name = "RedirectUrl", required = true)
    @XmlSchemaType(name = "anyURI")
    private String redirectUrl;
    @XmlElement(name = "Error")
    private List<ErrorType> error;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public RedirectUserType() {
    }

    /**
     * Gets the value of the requestId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getRequestId() {
        return requestId;
    }

    /**
     * Sets the value of the requestId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRequestId(
        @Nullable
        String value) {
        this.requestId = value;
    }

    /**
     * Gets the value of the specificationId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSpecificationId() {
        return specificationId;
    }

    /**
     * Sets the value of the specificationId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSpecificationId(
        @Nullable
        String value) {
        this.specificationId = value;
    }

    /**
     * Gets the value of the timeStamp property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDateTime getTimeStamp() {
        return timeStamp;
    }

    /**
     * Sets the value of the timeStamp property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTimeStamp(
        @Nullable
        XMLOffsetDateTime value) {
        this.timeStamp = value;
    }

    /**
     * Gets the value of the dataEvaluator property.
     * 
     * @return
     *     possible object is
     *     {@link AgentType }
     *     
     */
    @Nullable
    public AgentType getDataEvaluator() {
        return dataEvaluator;
    }

    /**
     * Sets the value of the dataEvaluator property.
     * 
     * @param value
     *     allowed object is
     *     {@link AgentType }
     *     
     */
    public void setDataEvaluator(
        @Nullable
        AgentType value) {
        this.dataEvaluator = value;
    }

    /**
     * Gets the value of the dataOwner property.
     * 
     * @return
     *     possible object is
     *     {@link AgentType }
     *     
     */
    @Nullable
    public AgentType getDataOwner() {
        return dataOwner;
    }

    /**
     * Sets the value of the dataOwner property.
     * 
     * @param value
     *     allowed object is
     *     {@link AgentType }
     *     
     */
    public void setDataOwner(
        @Nullable
        AgentType value) {
        this.dataOwner = value;
    }

    /**
     * Gets the value of the canonicalEvidenceTypeId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getCanonicalEvidenceTypeId() {
        return canonicalEvidenceTypeId;
    }

    /**
     * Sets the value of the canonicalEvidenceTypeId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCanonicalEvidenceTypeId(
        @Nullable
        String value) {
        this.canonicalEvidenceTypeId = value;
    }

    /**
     * Gets the value of the redirectUrl property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getRedirectUrl() {
        return redirectUrl;
    }

    /**
     * Sets the value of the redirectUrl property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setRedirectUrl(
        @Nullable
        String value) {
        this.redirectUrl = value;
    }

    /**
     * Gets the value of the error property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the error property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getError().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link ErrorType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ErrorType> getError() {
        if (error == null) {
            error = new ArrayList<ErrorType>();
        }
        return this.error;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final RedirectUserType rhs = ((RedirectUserType) o);
        if (!EqualsHelper.equals(canonicalEvidenceTypeId, rhs.canonicalEvidenceTypeId)) {
            return false;
        }
        if (!EqualsHelper.equals(dataEvaluator, rhs.dataEvaluator)) {
            return false;
        }
        if (!EqualsHelper.equals(dataOwner, rhs.dataOwner)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(error, rhs.error)) {
            return false;
        }
        if (!EqualsHelper.equals(redirectUrl, rhs.redirectUrl)) {
            return false;
        }
        if (!EqualsHelper.equals(requestId, rhs.requestId)) {
            return false;
        }
        if (!EqualsHelper.equals(specificationId, rhs.specificationId)) {
            return false;
        }
        if (!EqualsHelper.equals(timeStamp, rhs.timeStamp)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(canonicalEvidenceTypeId).append(dataEvaluator).append(dataOwner).append(error).append(redirectUrl).append(requestId).append(specificationId).append(timeStamp).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("canonicalEvidenceTypeId", canonicalEvidenceTypeId).append("dataEvaluator", dataEvaluator).append("dataOwner", dataOwner).append("error", error).append("redirectUrl", redirectUrl).append("requestId", requestId).append("specificationId", specificationId).append("timeStamp", timeStamp).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setError(
        @Nullable
        final List<ErrorType> aList) {
        error = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasErrorEntries() {
        return (!getError().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoErrorEntries() {
        return getError().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getErrorCount() {
        return getError().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ErrorType getErrorAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getError().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addError(
        @Nonnull
        final ErrorType elem) {
        getError().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        RedirectUserType ret) {
        ret.canonicalEvidenceTypeId = canonicalEvidenceTypeId;
        ret.dataEvaluator = ((dataEvaluator == null)?null:dataEvaluator.clone());
        ret.dataOwner = ((dataOwner == null)?null:dataOwner.clone());
        if (error == null) {
            ret.error = null;
        } else {
            List<ErrorType> retError = new ArrayList<ErrorType>();
            for (ErrorType aItem: getError()) {
                retError.add(((aItem == null)?null:aItem.clone()));
            }
            ret.error = retError;
        }
        ret.redirectUrl = redirectUrl;
        ret.requestId = requestId;
        ret.specificationId = specificationId;
        ret.timeStamp = timeStamp;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public RedirectUserType clone() {
        RedirectUserType ret = new RedirectUserType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDateTime representation of timeStamp. May be &lt;code&gt;null&lt;/code&gt;.
     */
    @Nullable
    public LocalDateTime getTimeStampLocal() {
        return (timeStamp == null)?null:timeStamp.toLocalDateTime();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDateTime to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTimeStamp(
        @Nullable
        final LocalDateTime aValue) {
        timeStamp = (aValue == null)?null:XMLOffsetDateTime.of(aValue, null);
    }

}
