
package eu.de4a.iem.core.jaxb.common;

import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterXMLOffsetDate;
import eu.de4a.iem.core.jaxb.eidas.np.BirthNameType;
import eu.de4a.iem.core.jaxb.eidas.np.CurrentFamilyNameType;
import eu.de4a.iem.core.jaxb.eidas.np.CurrentGivenNameType;
import eu.de4a.iem.core.jaxb.eidas.np.GenderType;
import eu.de4a.iem.core.jaxb.eidas.np.PlaceOfBirthType;


/**
 * 
 *         Natural Person eIDAS mandatory dataset and optional dataset
 * 
 * &lt;p&gt;Java class for NaturalPersonIdentifierType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="NaturalPersonIdentifierType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="PersonIdentifier" type="{http://eidas.europa.eu/attributes/naturalperson}PersonIdentifierType"/&amp;gt;
 *         &amp;lt;element name="FirstName" type="{http://eidas.europa.eu/attributes/naturalperson}CurrentGivenNameType"/&amp;gt;
 *         &amp;lt;element name="FamilyName" type="{http://eidas.europa.eu/attributes/naturalperson}CurrentFamilyNameType"/&amp;gt;
 *         &amp;lt;element name="DateOfBirth" type="{http://eidas.europa.eu/attributes/naturalperson}DateOfBirthType"/&amp;gt;
 *         &amp;lt;element name="Gender" type="{http://eidas.europa.eu/attributes/naturalperson}GenderType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="BirthName" type="{http://eidas.europa.eu/attributes/naturalperson}BirthNameType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="PlaceOfBirth" type="{http://eidas.europa.eu/attributes/naturalperson}PlaceOfBirthType" minOccurs="0"/&amp;gt;
 *         &amp;lt;element name="CurrentAddress" type="{http://eidas.europa.eu/attributes/naturalperson}CurrentAddressType" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-offset-dt-extension&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "NaturalPersonIdentifierType", propOrder = {
    "personIdentifier",
    "firstName",
    "familyName",
    "dateOfBirth",
    "gender",
    "birthName",
    "placeOfBirth",
    "currentAddress"
})
@CodingStyleguideUnaware
public class NaturalPersonIdentifierType implements IExplicitlyCloneable
{

    @XmlElement(name = "PersonIdentifier", required = true)
    private String personIdentifier;
    @XmlElement(name = "FirstName", required = true)
    private CurrentGivenNameType firstName;
    @XmlElement(name = "FamilyName", required = true)
    private CurrentFamilyNameType familyName;
    @XmlElement(name = "DateOfBirth", required = true, type = String.class)
    @XmlJavaTypeAdapter(AdapterXMLOffsetDate.class)
    @XmlSchemaType(name = "date")
    private XMLOffsetDate dateOfBirth;
    @XmlElement(name = "Gender")
    @XmlSchemaType(name = "string")
    private GenderType gender;
    @XmlElement(name = "BirthName")
    private BirthNameType birthName;
    @XmlElement(name = "PlaceOfBirth")
    private PlaceOfBirthType placeOfBirth;
    @XmlElement(name = "CurrentAddress")
    private String currentAddress;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public NaturalPersonIdentifierType() {
    }

    /**
     * Gets the value of the personIdentifier property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getPersonIdentifier() {
        return personIdentifier;
    }

    /**
     * Sets the value of the personIdentifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPersonIdentifier(
        @Nullable
        String value) {
        this.personIdentifier = value;
    }

    /**
     * Gets the value of the firstName property.
     * 
     * @return
     *     possible object is
     *     {@link CurrentGivenNameType }
     *     
     */
    @Nullable
    public CurrentGivenNameType getFirstName() {
        return firstName;
    }

    /**
     * Sets the value of the firstName property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrentGivenNameType }
     *     
     */
    public void setFirstName(
        @Nullable
        CurrentGivenNameType value) {
        this.firstName = value;
    }

    /**
     * Gets the value of the familyName property.
     * 
     * @return
     *     possible object is
     *     {@link CurrentFamilyNameType }
     *     
     */
    @Nullable
    public CurrentFamilyNameType getFamilyName() {
        return familyName;
    }

    /**
     * Sets the value of the familyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link CurrentFamilyNameType }
     *     
     */
    public void setFamilyName(
        @Nullable
        CurrentFamilyNameType value) {
        this.familyName = value;
    }

    /**
     * Gets the value of the dateOfBirth property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDate getDateOfBirth() {
        return dateOfBirth;
    }

    /**
     * Sets the value of the dateOfBirth property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDateOfBirth(
        @Nullable
        XMLOffsetDate value) {
        this.dateOfBirth = value;
    }

    /**
     * Gets the value of the gender property.
     * 
     * @return
     *     possible object is
     *     {@link GenderType }
     *     
     */
    @Nullable
    public GenderType getGender() {
        return gender;
    }

    /**
     * Sets the value of the gender property.
     * 
     * @param value
     *     allowed object is
     *     {@link GenderType }
     *     
     */
    public void setGender(
        @Nullable
        GenderType value) {
        this.gender = value;
    }

    /**
     * Gets the value of the birthName property.
     * 
     * @return
     *     possible object is
     *     {@link BirthNameType }
     *     
     */
    @Nullable
    public BirthNameType getBirthName() {
        return birthName;
    }

    /**
     * Sets the value of the birthName property.
     * 
     * @param value
     *     allowed object is
     *     {@link BirthNameType }
     *     
     */
    public void setBirthName(
        @Nullable
        BirthNameType value) {
        this.birthName = value;
    }

    /**
     * Gets the value of the placeOfBirth property.
     * 
     * @return
     *     possible object is
     *     {@link PlaceOfBirthType }
     *     
     */
    @Nullable
    public PlaceOfBirthType getPlaceOfBirth() {
        return placeOfBirth;
    }

    /**
     * Sets the value of the placeOfBirth property.
     * 
     * @param value
     *     allowed object is
     *     {@link PlaceOfBirthType }
     *     
     */
    public void setPlaceOfBirth(
        @Nullable
        PlaceOfBirthType value) {
        this.placeOfBirth = value;
    }

    /**
     * Gets the value of the currentAddress property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getCurrentAddress() {
        return currentAddress;
    }

    /**
     * Sets the value of the currentAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCurrentAddress(
        @Nullable
        String value) {
        this.currentAddress = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final NaturalPersonIdentifierType rhs = ((NaturalPersonIdentifierType) o);
        if (!EqualsHelper.equals(birthName, rhs.birthName)) {
            return false;
        }
        if (!EqualsHelper.equals(currentAddress, rhs.currentAddress)) {
            return false;
        }
        if (!EqualsHelper.equals(dateOfBirth, rhs.dateOfBirth)) {
            return false;
        }
        if (!EqualsHelper.equals(familyName, rhs.familyName)) {
            return false;
        }
        if (!EqualsHelper.equals(firstName, rhs.firstName)) {
            return false;
        }
        if (!EqualsHelper.equals(gender, rhs.gender)) {
            return false;
        }
        if (!EqualsHelper.equals(personIdentifier, rhs.personIdentifier)) {
            return false;
        }
        if (!EqualsHelper.equals(placeOfBirth, rhs.placeOfBirth)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(birthName).append(currentAddress).append(dateOfBirth).append(familyName).append(firstName).append(gender).append(personIdentifier).append(placeOfBirth).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("birthName", birthName).append("currentAddress", currentAddress).append("dateOfBirth", dateOfBirth).append("familyName", familyName).append("firstName", firstName).append("gender", gender).append("personIdentifier", personIdentifier).append("placeOfBirth", placeOfBirth).getToString();
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        NaturalPersonIdentifierType ret) {
        ret.birthName = ((birthName == null)?null:birthName.clone());
        ret.currentAddress = currentAddress;
        ret.dateOfBirth = dateOfBirth;
        ret.familyName = ((familyName == null)?null:familyName.clone());
        ret.firstName = ((firstName == null)?null:firstName.clone());
        ret.gender = gender;
        ret.personIdentifier = personIdentifier;
        ret.placeOfBirth = ((placeOfBirth == null)?null:placeOfBirth.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public NaturalPersonIdentifierType clone() {
        NaturalPersonIdentifierType ret = new NaturalPersonIdentifierType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type CurrentFamilyNameType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public CurrentFamilyNameType setFamilyName(
        @Nullable
        final String valueParam) {
        CurrentFamilyNameType aObj = getFamilyName();
        if (aObj == null) {
            aObj = new CurrentFamilyNameType(valueParam);
            setFamilyName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type CurrentGivenNameType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public CurrentGivenNameType setFirstName(
        @Nullable
        final String valueParam) {
        CurrentGivenNameType aObj = getFirstName();
        if (aObj == null) {
            aObj = new CurrentGivenNameType(valueParam);
            setFirstName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type BirthNameType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public BirthNameType setBirthName(
        @Nullable
        final String valueParam) {
        BirthNameType aObj = getBirthName();
        if (aObj == null) {
            aObj = new BirthNameType(valueParam);
            setBirthName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be &lt;code&gt;null&lt;/code&gt;.
     * @return
     *     The created intermediary object of type PlaceOfBirthType and never &lt;code&gt;null&lt;/code&gt;
     */
    @Nonnull
    public PlaceOfBirthType setPlaceOfBirth(
        @Nullable
        final String valueParam) {
        PlaceOfBirthType aObj = getPlaceOfBirth();
        if (aObj == null) {
            aObj = new PlaceOfBirthType(valueParam);
            setPlaceOfBirth(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CurrentGivenNameType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CurrentGivenNameType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getFirstNameValue() {
        CurrentGivenNameType aObj = getFirstName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CurrentFamilyNameType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CurrentFamilyNameType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getFamilyNameValue() {
        CurrentFamilyNameType aObj = getFamilyName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained BirthNameType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BirthNameType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getBirthNameValue() {
        BirthNameType aObj = getBirthName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PlaceOfBirthType object&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PlaceOfBirthType object or &lt;code&gt;null&lt;/code&gt;
     */
    @Nullable
    public String getPlaceOfBirthValue() {
        PlaceOfBirthType aObj = getPlaceOfBirth();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDate representation of dateOfBirth. May be &lt;code&gt;null&lt;/code&gt;.
     */
    @Nullable
    public LocalDate getDateOfBirthLocal() {
        return (dateOfBirth == null)?null:dateOfBirth.toLocalDate();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDate to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setDateOfBirth(
        @Nullable
        final LocalDate aValue) {
        dateOfBirth = (aValue == null)?null:XMLOffsetDate.of(aValue, null);
    }

}
