
package eu.de4a.iem.core.jaxb.common;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterXMLOffsetDateTime;


/**
 * &lt;p&gt;Java class for EventNotificationItemType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="EventNotificationItemType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="NotificationItemId" type="{http://www.de4a.eu/2020/commons/type/v2}IdType"/&amp;gt;
 *         &amp;lt;element name="EventId" type="{http://www.de4a.eu/2020/commons/type/v2}IdType"/&amp;gt;
 *         &amp;lt;element name="EventSubject" type="{http://www.de4a.eu/2020/commons/type/v2}DataRequestSubjectCVType"/&amp;gt;
 *         &amp;lt;element name="CanonicalEventCatalogUri" type="{http://www.w3.org/2001/XMLSchema}anyURI"/&amp;gt;
 *         &amp;lt;element name="EventDate" type="{http://www.w3.org/2001/XMLSchema}dateTime"/&amp;gt;
 *         &amp;lt;element name="RelatedEventSubject" type="{http://www.de4a.eu/2020/commons/type/v2}DataRequestSubjectCVType" maxOccurs="unbounded" minOccurs="0"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-offset-dt-extension&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EventNotificationItemType", propOrder = {
    "notificationItemId",
    "eventId",
    "eventSubject",
    "canonicalEventCatalogUri",
    "eventDate",
    "relatedEventSubject"
})
@CodingStyleguideUnaware
public class EventNotificationItemType implements IExplicitlyCloneable
{

    @XmlElement(name = "NotificationItemId", required = true)
    private String notificationItemId;
    @XmlElement(name = "EventId", required = true)
    private String eventId;
    @XmlElement(name = "EventSubject", required = true)
    private DataRequestSubjectCVType eventSubject;
    @XmlElement(name = "CanonicalEventCatalogUri", required = true)
    @XmlSchemaType(name = "anyURI")
    private String canonicalEventCatalogUri;
    @XmlElement(name = "EventDate", required = true, type = String.class)
    @XmlJavaTypeAdapter(AdapterXMLOffsetDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private XMLOffsetDateTime eventDate;
    @XmlElement(name = "RelatedEventSubject")
    private List<DataRequestSubjectCVType> relatedEventSubject;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public EventNotificationItemType() {
    }

    /**
     * Gets the value of the notificationItemId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getNotificationItemId() {
        return notificationItemId;
    }

    /**
     * Sets the value of the notificationItemId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNotificationItemId(
        @Nullable
        String value) {
        this.notificationItemId = value;
    }

    /**
     * Gets the value of the eventId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getEventId() {
        return eventId;
    }

    /**
     * Sets the value of the eventId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEventId(
        @Nullable
        String value) {
        this.eventId = value;
    }

    /**
     * Gets the value of the eventSubject property.
     * 
     * @return
     *     possible object is
     *     {@link DataRequestSubjectCVType }
     *     
     */
    @Nullable
    public DataRequestSubjectCVType getEventSubject() {
        return eventSubject;
    }

    /**
     * Sets the value of the eventSubject property.
     * 
     * @param value
     *     allowed object is
     *     {@link DataRequestSubjectCVType }
     *     
     */
    public void setEventSubject(
        @Nullable
        DataRequestSubjectCVType value) {
        this.eventSubject = value;
    }

    /**
     * Gets the value of the canonicalEventCatalogUri property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getCanonicalEventCatalogUri() {
        return canonicalEventCatalogUri;
    }

    /**
     * Sets the value of the canonicalEventCatalogUri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCanonicalEventCatalogUri(
        @Nullable
        String value) {
        this.canonicalEventCatalogUri = value;
    }

    /**
     * Gets the value of the eventDate property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDateTime getEventDate() {
        return eventDate;
    }

    /**
     * Sets the value of the eventDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEventDate(
        @Nullable
        XMLOffsetDateTime value) {
        this.eventDate = value;
    }

    /**
     * Gets the value of the relatedEventSubject property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the relatedEventSubject property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getRelatedEventSubject().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link DataRequestSubjectCVType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DataRequestSubjectCVType> getRelatedEventSubject() {
        if (relatedEventSubject == null) {
            relatedEventSubject = new ArrayList<DataRequestSubjectCVType>();
        }
        return this.relatedEventSubject;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final EventNotificationItemType rhs = ((EventNotificationItemType) o);
        if (!EqualsHelper.equals(canonicalEventCatalogUri, rhs.canonicalEventCatalogUri)) {
            return false;
        }
        if (!EqualsHelper.equals(eventDate, rhs.eventDate)) {
            return false;
        }
        if (!EqualsHelper.equals(eventId, rhs.eventId)) {
            return false;
        }
        if (!EqualsHelper.equals(eventSubject, rhs.eventSubject)) {
            return false;
        }
        if (!EqualsHelper.equals(notificationItemId, rhs.notificationItemId)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(relatedEventSubject, rhs.relatedEventSubject)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(canonicalEventCatalogUri).append(eventDate).append(eventId).append(eventSubject).append(notificationItemId).append(relatedEventSubject).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("canonicalEventCatalogUri", canonicalEventCatalogUri).append("eventDate", eventDate).append("eventId", eventId).append("eventSubject", eventSubject).append("notificationItemId", notificationItemId).append("relatedEventSubject", relatedEventSubject).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setRelatedEventSubject(
        @Nullable
        final List<DataRequestSubjectCVType> aList) {
        relatedEventSubject = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasRelatedEventSubjectEntries() {
        return (!getRelatedEventSubject().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoRelatedEventSubjectEntries() {
        return getRelatedEventSubject().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getRelatedEventSubjectCount() {
        return getRelatedEventSubject().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DataRequestSubjectCVType getRelatedEventSubjectAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRelatedEventSubject().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addRelatedEventSubject(
        @Nonnull
        final DataRequestSubjectCVType elem) {
        getRelatedEventSubject().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        EventNotificationItemType ret) {
        ret.canonicalEventCatalogUri = canonicalEventCatalogUri;
        ret.eventDate = eventDate;
        ret.eventId = eventId;
        ret.eventSubject = ((eventSubject == null)?null:eventSubject.clone());
        ret.notificationItemId = notificationItemId;
        if (relatedEventSubject == null) {
            ret.relatedEventSubject = null;
        } else {
            List<DataRequestSubjectCVType> retRelatedEventSubject = new ArrayList<DataRequestSubjectCVType>();
            for (DataRequestSubjectCVType aItem: getRelatedEventSubject()) {
                retRelatedEventSubject.add(((aItem == null)?null:aItem.clone()));
            }
            ret.relatedEventSubject = retRelatedEventSubject;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public EventNotificationItemType clone() {
        EventNotificationItemType ret = new EventNotificationItemType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDateTime representation of eventDate. May be &lt;code&gt;null&lt;/code&gt;.
     */
    @Nullable
    public LocalDateTime getEventDateLocal() {
        return (eventDate == null)?null:eventDate.toLocalDateTime();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDateTime to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setEventDate(
        @Nullable
        final LocalDateTime aValue) {
        eventDate = (aValue == null)?null:XMLOffsetDateTime.of(aValue, null);
    }

}
