
package eu.de4a.iem.core.jaxb.common;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.jaxb.adapter.AdapterXMLOffsetDateTime;


/**
 * &lt;p&gt;Java class for EventNotificationType complex type.
 * 
 * &lt;p&gt;The following schema fragment specifies the expected content contained within this class.
 * 
 * &lt;pre&gt;
 * &amp;lt;complexType name="EventNotificationType"&amp;gt;
 *   &amp;lt;complexContent&amp;gt;
 *     &amp;lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&amp;gt;
 *       &amp;lt;sequence&amp;gt;
 *         &amp;lt;element name="NotificationId" type="{http://www.de4a.eu/2020/commons/type/v2}IdType"/&amp;gt;
 *         &amp;lt;element name="SpecificationId" type="{http://www.de4a.eu/2020/commons/type/v2}IdType"/&amp;gt;
 *         &amp;lt;element name="TimeStamp" type="{http://www.w3.org/2001/XMLSchema}dateTime"/&amp;gt;
 *         &amp;lt;element name="DataEvaluator" type="{http://www.de4a.eu/2020/commons/type/v2}AgentType"/&amp;gt;
 *         &amp;lt;element name="DataOwner" type="{http://www.de4a.eu/2020/commons/type/v2}AgentType"/&amp;gt;
 *         &amp;lt;element name="EventNotificationItem" type="{http://www.de4a.eu/2020/commons/type/v2}EventNotificationItemType" maxOccurs="unbounded"/&amp;gt;
 *       &amp;lt;/sequence&amp;gt;
 *     &amp;lt;/restriction&amp;gt;
 *   &amp;lt;/complexContent&amp;gt;
 * &amp;lt;/complexType&amp;gt;
 * &lt;/pre&gt;
 * &lt;p&gt;This class was annotated by ph-jaxb22-plugin -Xph-annotate&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-tostring&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-list-extension&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-value-extender&lt;/p&gt;
 * &lt;p&gt;This class contains methods created by ph-jaxb22-plugin -Xph-offset-dt-extension&lt;/p&gt;
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EventNotificationType", propOrder = {
    "notificationId",
    "specificationId",
    "timeStamp",
    "dataEvaluator",
    "dataOwner",
    "eventNotificationItem"
})
@CodingStyleguideUnaware
public class EventNotificationType implements IExplicitlyCloneable
{

    @XmlElement(name = "NotificationId", required = true)
    private String notificationId;
    @XmlElement(name = "SpecificationId", required = true)
    private String specificationId;
    @XmlElement(name = "TimeStamp", required = true, type = String.class)
    @XmlJavaTypeAdapter(AdapterXMLOffsetDateTime.class)
    @XmlSchemaType(name = "dateTime")
    private XMLOffsetDateTime timeStamp;
    @XmlElement(name = "DataEvaluator", required = true)
    private AgentType dataEvaluator;
    @XmlElement(name = "DataOwner", required = true)
    private AgentType dataOwner;
    @XmlElement(name = "EventNotificationItem", required = true)
    private List<EventNotificationItemType> eventNotificationItem;

    /**
     * Default constructor&lt;br&gt;
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public EventNotificationType() {
    }

    /**
     * Gets the value of the notificationId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getNotificationId() {
        return notificationId;
    }

    /**
     * Sets the value of the notificationId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNotificationId(
        @Nullable
        String value) {
        this.notificationId = value;
    }

    /**
     * Gets the value of the specificationId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSpecificationId() {
        return specificationId;
    }

    /**
     * Sets the value of the specificationId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSpecificationId(
        @Nullable
        String value) {
        this.specificationId = value;
    }

    /**
     * Gets the value of the timeStamp property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public XMLOffsetDateTime getTimeStamp() {
        return timeStamp;
    }

    /**
     * Sets the value of the timeStamp property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTimeStamp(
        @Nullable
        XMLOffsetDateTime value) {
        this.timeStamp = value;
    }

    /**
     * Gets the value of the dataEvaluator property.
     * 
     * @return
     *     possible object is
     *     {@link AgentType }
     *     
     */
    @Nullable
    public AgentType getDataEvaluator() {
        return dataEvaluator;
    }

    /**
     * Sets the value of the dataEvaluator property.
     * 
     * @param value
     *     allowed object is
     *     {@link AgentType }
     *     
     */
    public void setDataEvaluator(
        @Nullable
        AgentType value) {
        this.dataEvaluator = value;
    }

    /**
     * Gets the value of the dataOwner property.
     * 
     * @return
     *     possible object is
     *     {@link AgentType }
     *     
     */
    @Nullable
    public AgentType getDataOwner() {
        return dataOwner;
    }

    /**
     * Sets the value of the dataOwner property.
     * 
     * @param value
     *     allowed object is
     *     {@link AgentType }
     *     
     */
    public void setDataOwner(
        @Nullable
        AgentType value) {
        this.dataOwner = value;
    }

    /**
     * Gets the value of the eventNotificationItem property.
     * 
     * &lt;p&gt;
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a &lt;CODE&gt;set&lt;/CODE&gt; method for the eventNotificationItem property.
     * 
     * &lt;p&gt;
     * For example, to add a new item, do as follows:
     * &lt;pre&gt;
     *    getEventNotificationItem().add(newItem);
     * &lt;/pre&gt;
     * 
     * 
     * &lt;p&gt;
     * Objects of the following type(s) are allowed in the list
     * {@link EventNotificationItemType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EventNotificationItemType> getEventNotificationItem() {
        if (eventNotificationItem == null) {
            eventNotificationItem = new ArrayList<EventNotificationItemType>();
        }
        return this.eventNotificationItem;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final EventNotificationType rhs = ((EventNotificationType) o);
        if (!EqualsHelper.equals(dataEvaluator, rhs.dataEvaluator)) {
            return false;
        }
        if (!EqualsHelper.equals(dataOwner, rhs.dataOwner)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(eventNotificationItem, rhs.eventNotificationItem)) {
            return false;
        }
        if (!EqualsHelper.equals(notificationId, rhs.notificationId)) {
            return false;
        }
        if (!EqualsHelper.equals(specificationId, rhs.specificationId)) {
            return false;
        }
        if (!EqualsHelper.equals(timeStamp, rhs.timeStamp)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(dataEvaluator).append(dataOwner).append(eventNotificationItem).append(notificationId).append(specificationId).append(timeStamp).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("dataEvaluator", dataEvaluator).append("dataOwner", dataOwner).append("eventNotificationItem", eventNotificationItem).append("notificationId", notificationId).append("specificationId", specificationId).append("timeStamp", timeStamp).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setEventNotificationItem(
        @Nullable
        final List<EventNotificationItemType> aList) {
        eventNotificationItem = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if at least one item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasEventNotificationItemEntries() {
        return (!getEventNotificationItem().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     &lt;code&gt;true&lt;/code&gt; if no item is contained, &lt;code&gt;false&lt;/code&gt; otherwise.
     */
    public boolean hasNoEventNotificationItemEntries() {
        return getEventNotificationItem().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &amp;ge; 0.
     */
    @Nonnegative
    public int getEventNotificationItemCount() {
        return getEventNotificationItem().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be &lt;code&gt;null&lt;/code&gt;
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EventNotificationItemType getEventNotificationItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEventNotificationItem().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void addEventNotificationItem(
        @Nonnull
        final EventNotificationItemType elem) {
        getEventNotificationItem().add(elem);
    }

    /**
     * This method clones all values from &lt;code&gt;this&lt;/code&gt; to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be &lt;code&gt;null&lt;/code&gt;.
     */
    public void cloneTo(
        @Nonnull
        EventNotificationType ret) {
        ret.dataEvaluator = ((dataEvaluator == null)?null:dataEvaluator.clone());
        ret.dataOwner = ((dataOwner == null)?null:dataOwner.clone());
        if (eventNotificationItem == null) {
            ret.eventNotificationItem = null;
        } else {
            List<EventNotificationItemType> retEventNotificationItem = new ArrayList<EventNotificationItemType>();
            for (EventNotificationItemType aItem: getEventNotificationItem()) {
                retEventNotificationItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.eventNotificationItem = retEventNotificationItem;
        }
        ret.notificationId = notificationId;
        ret.specificationId = specificationId;
        ret.timeStamp = timeStamp;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never &lt;code&gt;null&lt;/code&gt;.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public EventNotificationType clone() {
        EventNotificationType ret = new EventNotificationType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @return
     *     The LocalDateTime representation of timeStamp. May be &lt;code&gt;null&lt;/code&gt;.
     */
    @Nullable
    public LocalDateTime getTimeStampLocal() {
        return (timeStamp == null)?null:timeStamp.toLocalDateTime();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-offset-dt-extension
     * 
     * @param aValue
     *     The LocalDateTime to set. May be &lt;code&gt;null&lt;/code&gt;.
     */
    public void setTimeStamp(
        @Nullable
        final LocalDateTime aValue) {
        timeStamp = (aValue == null)?null:XMLOffsetDateTime.of(aValue, null);
    }

}
